/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.wpdd.part.DiagramVisualIDRegistry;
import org.eclipse.epf.diagram.wpdd.providers.DiagramElementTypes;
import org.eclipse.epf.diagram.wpdd.view.factories.LinkNameViewFactory;
import org.eclipse.epf.diagram.wpdd.view.factories.LinkViewFactory;
import org.eclipse.epf.diagram.wpdd.view.factories.WorkProductDependencyDiagramViewFactory;
import org.eclipse.epf.diagram.wpdd.view.factories.WorkProductNodeNameViewFactory;
import org.eclipse.epf.diagram.wpdd.view.factories.WorkProductNodeViewFactory;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramViewProvider
extends AbstractViewProvider {
    protected Class getDiagramViewClass(IAdaptable iAdaptable, String string) {
        EObject eObject = this.getSemanticElement(iAdaptable);
        if ("WPDD".equals(string) && DiagramVisualIDRegistry.getDiagramVisualID(eObject) != -1) {
            return WorkProductDependencyDiagramViewFactory.class;
        }
        return null;
    }

    protected Class getNodeViewClass(IAdaptable iAdaptable, View view, String string) {
        if (view == null) {
            return null;
        }
        IElementType iElementType = this.getSemanticElementType(iAdaptable);
        if (iElementType != null && !DiagramElementTypes.isKnownElementType(iElementType)) {
            return null;
        }
        EClass eClass = this.getSemanticEClass(iAdaptable);
        EObject eObject = this.getSemanticElement(iAdaptable);
        int n = DiagramVisualIDRegistry.getNodeVisualID(view, eObject, eClass, string);
        switch (n) {
            case 1001: {
                return WorkProductNodeViewFactory.class;
            }
            case 4001: {
                return WorkProductNodeNameViewFactory.class;
            }
            case 4002: {
                return LinkNameViewFactory.class;
            }
        }
        return null;
    }

    protected Class getEdgeViewClass(IAdaptable iAdaptable, View view, String string) {
        IElementType iElementType = this.getSemanticElementType(iAdaptable);
        if (iElementType != null && !DiagramElementTypes.isKnownElementType(iElementType)) {
            return null;
        }
        EClass eClass = this.getSemanticEClass(iAdaptable);
        if (eClass == null) {
            return null;
        }
        EObject eObject = this.getSemanticElement(iAdaptable);
        int n = DiagramVisualIDRegistry.getLinkWithClassVisualID(eObject, eClass);
        switch (n) {
            case 3001: {
                return LinkViewFactory.class;
            }
        }
        return this.getUnrecognizedConnectorViewClass(iAdaptable, view, string);
    }

    private IElementType getSemanticElementType(IAdaptable iAdaptable) {
        if (iAdaptable == null) {
            return null;
        }
        return (IElementType)iAdaptable.getAdapter(IElementType.class);
    }

    private Class getUnrecognizedConnectorViewClass(IAdaptable iAdaptable, View view, String string) {
        return null;
    }
}

