/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ActionDelegate
extends Action
implements IObjectActionDelegate {
    protected IWorkbenchPart targetPart;
    protected List<EditPart> selectedParts = new ArrayList<EditPart>();
    protected Request targetRequest;

    public ActionDelegate() {
    }

    public ActionDelegate(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        this.execute(this.getCommand(), (IProgressMonitor)new NullProgressMonitor());
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        this.dropMenuItems();
        this.selectedParts.clear();
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() > 0 && iStructuredSelection.getFirstElement() instanceof EditPart) {
            this.selectedParts.addAll(iStructuredSelection.toList());
        }
    }

    protected DiagramCommandStack getDiagramCommandStack() {
        Object object = this.targetPart.getAdapter(CommandStack.class);
        return object instanceof DiagramCommandStack ? (DiagramCommandStack)object : null;
    }

    protected final IWorkbenchPart getWorkbenchPart() {
        return this.targetPart;
    }

    protected DiagramContextMenuProvider getDiagramContextMenuProvider() {
        if (this.targetPart != null) {
            DiagramGraphicalViewer diagramGraphicalViewer = (DiagramGraphicalViewer)this.targetPart.getAdapter(GraphicalViewer.class);
            DiagramContextMenuProvider diagramContextMenuProvider = (DiagramContextMenuProvider)diagramGraphicalViewer.getContextMenu();
            return diagramContextMenuProvider;
        }
        return null;
    }

    protected final void execute(Command command, IProgressMonitor iProgressMonitor) {
        if (command == null || !command.canExecute()) {
            return;
        }
        if (this.getDiagramCommandStack() != null) {
            this.getDiagramCommandStack().execute(command, iProgressMonitor);
        }
    }

    protected abstract Command getCommand();

    protected void dropMenuItems() {
    }

    protected TransactionalEditingDomain getEditingDomain() {
        EditingDomain editingDomain;
        IEditingDomainProvider iEditingDomainProvider;
        IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
        if (iWorkbenchPart != null && (iEditingDomainProvider = (IEditingDomainProvider)iWorkbenchPart.getAdapter(IEditingDomainProvider.class)) != null && (editingDomain = iEditingDomainProvider.getEditingDomain()) instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)editingDomain;
        }
        return null;
    }

    protected Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected abstract Request createTargetRequest();
}

