/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;

public class WorkBreakdownElementNodeAdapter
extends NodeAdapter {
    public WorkBreakdownElementNodeAdapter(MethodElement methodElement) {
        super(methodElement);
    }

    public void handleSuppressed(boolean bl) {
        if (bl) {
            NodeAdapter nodeAdapter;
            Object object;
            EList eList = this.getNode().getIncomings();
            int n = 0;
            while (n < eList.size()) {
                Object e = eList.get(n);
                object = null;
                if (e != null) {
                    object = (ActivityEdge)e;
                }
                if (object != null && object.getSource() != null) {
                    nodeAdapter = BridgeHelper.getNodeAdapter((EObject)object.getSource());
                    boolean bl2 = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
                    try {
                        if (nodeAdapter != null) {
                            nodeAdapter.notificationEnabled = false;
                        }
                        object.setTarget(null);
                        this.getNode().getIncomings().remove(object);
                    }
                    finally {
                        if (nodeAdapter != null) {
                            nodeAdapter.notificationEnabled = bl2;
                        }
                    }
                }
                ++n;
            }
            EList eList2 = this.getNode().getOutgoings();
            int n2 = 0;
            while (n2 < eList2.size()) {
                object = eList2.get(n2);
                nodeAdapter = null;
                if (object != null) {
                    nodeAdapter = object;
                }
                if (nodeAdapter != null && nodeAdapter.getTarget() != null) {
                    NodeAdapter nodeAdapter2 = BridgeHelper.getNodeAdapter((EObject)nodeAdapter.getTarget());
                    boolean bl3 = nodeAdapter2 != null ? nodeAdapter2.notificationEnabled : false;
                    try {
                        if (nodeAdapter2 != null) {
                            nodeAdapter2.notificationEnabled = false;
                        }
                        nodeAdapter.setSource(null);
                        this.getNode().getIncomings().remove((Object)nodeAdapter);
                    }
                    finally {
                        if (nodeAdapter2 != null) {
                            nodeAdapter2.notificationEnabled = bl3;
                        }
                    }
                }
                ++n2;
            }
        } else {
            EList eList = this.getDiagram().getNodes();
            for (ActivityNode activityNode : eList) {
                MethodElement methodElement;
                if (activityNode == this.getNode() || !(this.target instanceof MethodElement) || (methodElement = BridgeHelper.getMethodElement((EModelElement)activityNode)) == null) continue;
                this.addIncomingConnection(methodElement);
                this.addOutgoingConnection(methodElement);
            }
        }
    }

    protected NodeAdapter.MethodElementAdapter createMethodElementAdapter() {
        return new WorkBreakdownElementAdapter();
    }

    protected boolean addToUMA(ActivityEdge activityEdge) {
        if (!super.addToUMA(activityEdge)) {
            return false;
        }
        MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)activityEdge.getSource());
        if (methodElement instanceof WorkBreakdownElement) {
            WorkBreakdownElement workBreakdownElement;
            WorkOrder workOrder = null;
            WorkBreakdownElement workBreakdownElement2 = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)activityEdge.getTarget());
            if (UmaUtil.findWorkOrder((WorkBreakdownElement)workBreakdownElement2, (Object)(workBreakdownElement = (WorkBreakdownElement)methodElement)) == null) {
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityEdge.getSource());
                boolean bl = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
                try {
                    if (nodeAdapter != null) {
                        nodeAdapter.notificationEnabled = false;
                    }
                    workOrder = this.addDefaultWorkOrder(activityEdge.getTarget(), workBreakdownElement);
                }
                finally {
                    if (nodeAdapter != null) {
                        nodeAdapter.notificationEnabled = bl;
                    }
                }
            }
            BridgeHelper.setSemanticModel(activityEdge, workOrder);
        } else if (BridgeHelper.isSynchBar(activityEdge.getSource())) {
            ArrayList arrayList = new ArrayList();
            BridgeHelper.getSyncBarSourceNodes(activityEdge.getSource(), arrayList);
            WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)activityEdge.getTarget());
            for (ActivityNode activityNode : arrayList) {
                WorkBreakdownElement workBreakdownElement3 = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)activityNode);
                if (UmaUtil.findWorkOrder((WorkBreakdownElement)workBreakdownElement, (Object)workBreakdownElement3) != null) continue;
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
                boolean bl = nodeAdapter.notificationEnabled;
                try {
                    nodeAdapter.notificationEnabled = false;
                    this.addDefaultWorkOrder(activityEdge.getTarget(), workBreakdownElement3);
                }
                finally {
                    nodeAdapter.notificationEnabled = bl;
                }
            }
        }
        return true;
    }

    protected ActivityEdge addIncomingConnection(MethodElement methodElement) {
        ActivityEdge activityEdge = super.addIncomingConnection(methodElement);
        if (activityEdge == null) {
            return activityEdge;
        }
        WorkOrder workOrder = UmaUtil.findWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)this.getElement()), (Object)methodElement);
        BridgeHelper.setSemanticModel(activityEdge, workOrder);
        return activityEdge;
    }

    protected ActivityEdge addOutgoingConnection(MethodElement methodElement) {
        ActivityEdge activityEdge = super.addOutgoingConnection(methodElement);
        WorkOrder workOrder = UmaUtil.findWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)methodElement), (Object)this.getElement());
        BridgeHelper.setSemanticModel(activityEdge, workOrder);
        return activityEdge;
    }

    protected boolean removeIncomingConnection(MethodElement methodElement) {
        for (ActivityEdge activityEdge : this.getNode().getIncomings()) {
            if (activityEdge.getSource() == null || BridgeHelper.getMethodElement((EModelElement)activityEdge.getSource()) != methodElement) continue;
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityEdge.getSource());
            boolean bl = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
            try {
                if (nodeAdapter != null) {
                    nodeAdapter.notificationEnabled = false;
                }
                activityEdge.setSource(null);
            }
            finally {
                if (nodeAdapter != null) {
                    nodeAdapter.notificationEnabled = bl;
                }
            }
            activityEdge.setTarget(null);
            BridgeHelper.setSemanticModel(activityEdge, null);
            this.getDiagram().getEdges().remove((Object)activityEdge);
            return true;
        }
        return false;
    }

    private class WorkBreakdownElementAdapter
    extends NodeAdapter.MethodElementAdapter {
        private WorkBreakdownElementAdapter() {
        }

        protected Collection handleNotification(Notification notification) {
            block0 : switch (notification.getFeatureID(WorkBreakdownElement.class)) {
                case 22: {
                    switch (notification.getEventType()) {
                        case 3: {
                            WorkOrder workOrder = (WorkOrder)notification.getNewValue();
                            WorkBreakdownElementNodeAdapter.this.addIncomingConnection((MethodElement)workOrder.getPred());
                            break;
                        }
                        case 4: {
                            WorkOrder workOrder = (WorkOrder)notification.getOldValue();
                            WorkBreakdownElementNodeAdapter.this.removeIncomingConnection((MethodElement)workOrder.getPred());
                            break;
                        }
                        case 5: {
                            Collection collection = (Collection)notification.getNewValue();
                            for (WorkOrder workOrder : collection) {
                                WorkBreakdownElementNodeAdapter.this.addIncomingConnection((MethodElement)workOrder.getPred());
                            }
                            break block0;
                        }
                        case 6: {
                            Collection collection = (Collection)notification.getOldValue();
                            for (WorkOrder workOrder : collection) {
                                WorkBreakdownElementNodeAdapter.this.removeIncomingConnection((MethodElement)workOrder.getPred());
                            }
                        }
                    }
                    break;
                }
                case 5: {
                    switch (notification.getEventType()) {
                        default: 
                    }
                    break;
                }
                default: {
                    return super.handleNotification(notification);
                }
            }
            return Collections.EMPTY_LIST;
        }
    }
}

