/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.Activity;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDiagramNodeCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Activity activity;
    private Collection<?> breakdownElements;
    private DiagramService diagramSvc;

    public DeleteDiagramNodeCommand(Activity activity, Collection<?> collection) {
        this.activity = activity;
        this.breakdownElements = collection;
    }

    public Collection<Resource> getModifiedResources() {
        DiagramManager diagramManager;
        if (this.diagramSvc != null && (diagramManager = this.diagramSvc.getDiagramManager(this.activity)) != null) {
            try {
                Resource resource = diagramManager.getResource();
                if (resource != null) {
                    return Collections.singleton(resource);
                }
            }
            catch (CoreException coreException) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)coreException);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void execute() {
        Collection<Diagram> collection = this.diagramSvc.getDiagrams(this.activity);
        ArrayList<View> arrayList = new ArrayList<View>();
        for (Diagram diagram : collection) {
            AbstractTreeIterator<View> abstractTreeIterator = new AbstractTreeIterator<View>((Object)diagram, false){
                private static final long serialVersionUID = 1L;

                protected Iterator<? extends View> getChildren(Object object) {
                    if (object instanceof View) {
                        return ((View)object).getChildren().iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
            };
            while (abstractTreeIterator.hasNext()) {
                View view = (View)abstractTreeIterator.next();
                if (!this.breakdownElements.contains(BridgeHelper.getMethodElement(view, this.activity))) continue;
                arrayList.add(view);
            }
        }
        if (!arrayList.isEmpty()) {
            for (View view : arrayList) {
                ViewUtil.destroy((View)view);
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public boolean canUndo() {
        return false;
    }

    protected boolean prepare() {
        this.diagramSvc = new DiagramService();
        Collection<Diagram> collection = this.diagramSvc.getDiagrams(this.activity);
        return !collection.isEmpty();
    }

    public void dispose() {
        this.activity = null;
        this.breakdownElements = null;
        this.diagramSvc.dispose();
    }
}

