/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.util;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.ActivityNode;

public abstract class ValidatingTextDirectEditManager
extends TextDirectEditManager {
    public ValidatingTextDirectEditManager(GraphicalEditPart graphicalEditPart, Class clazz, CellEditorLocator cellEditorLocator) {
        super(graphicalEditPart, clazz, cellEditorLocator);
    }

    protected void commit() {
        String string = this.validate((String)this.getCellEditor().getValue());
        if (string != null) {
            this.bringDown(false);
            Display.getCurrent().asyncExec((Runnable)new PromptEdit(this, string));
            return;
        }
        super.commit();
    }

    protected void bringDown() {
        this.bringDown(true);
    }

    protected void bringDown(boolean bl) {
        super.bringDown();
        if (bl) {
            Node node = (Node)this.getEditPart().getModel();
            EObject eObject = node.getElement();
            String string = null;
            if (eObject instanceof ActivityNode) {
                string = ((ActivityNode)eObject).getName();
                MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)eObject);
                if (methodElement instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)methodElement))) {
                    string = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)methodElement));
                }
            } else if (eObject instanceof NamedNode) {
                Object object;
                NamedNode namedNode = (NamedNode)eObject;
                string = namedNode.getName();
                if (node instanceof WorkBreakdownElementNode && (object = namedNode.getObject()) instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)object))) {
                    string = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)object));
                }
            }
            if (string == null || string.trim().length() == 0) {
                Display.getCurrent().asyncExec((Runnable)new PromptEdit(this, DiagramCoreResources.err_name_empty));
            }
        }
    }

    protected abstract String validate(String var1);

    protected abstract void performDirectEdit();

    static class PromptEdit
    implements Runnable {
        private ValidatingTextDirectEditManager manager;
        private String msg;

        PromptEdit(ValidatingTextDirectEditManager validatingTextDirectEditManager, String string) {
            this.manager = validatingTextDirectEditManager;
            this.msg = string;
        }

        public void run() {
            String string = DiagramCoreResources.diagram_errorDialog_title;
            MsgDialog msgDialog = DiagramCorePlugin.getDefault().getMsgDialog();
            msgDialog.displayError(string, this.msg);
            this.manager.performDirectEdit();
        }
    }
}

