/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.service.AbstractValidationContext;
import org.eclipse.emf.validation.internal.service.IClientContext;
import org.eclipse.emf.validation.internal.service.IProviderOperation;
import org.eclipse.emf.validation.internal.service.IProviderOperationExecutor;
import org.eclipse.emf.validation.internal.service.ValidationCanceledException;
import org.eclipse.emf.validation.internal.util.DisabledConstraintStatus;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;

abstract class AbstractValidator
implements IValidator {
    private final EvaluationMode mode;
    private final Map clientData = new HashMap();
    private final IProviderOperationExecutor executor;
    private boolean reportSuccesses = false;
    private Collection filters = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.internal.service.AbstractValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected AbstractValidator(EvaluationMode mode, IProviderOperationExecutor executor) {
        if (!$assertionsDisabled && (mode == null || mode.isNull())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && executor == null) {
            throw new AssertionError();
        }
        this.mode = mode;
        this.executor = executor;
    }

    public final EvaluationMode getEvaluationMode() {
        return this.mode;
    }

    public boolean isReportSuccesses() {
        return this.reportSuccesses;
    }

    public void setReportSuccesses(boolean reportSuccesses) {
        this.reportSuccesses = reportSuccesses;
    }

    public void putClientData(String key, Object data) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError((Object)"null key");
        }
        if (data == null) {
            this.clientData.remove(key);
        } else {
            this.clientData.put(key, data);
        }
    }

    public Object getClientData(String key) {
        return this.clientData.get(key);
    }

    public final IStatus validate(Object object) {
        return this.validate(Collections.singleton(object));
    }

    public final IStatus validate(Collection objects) {
        IStatus result;
        HashSet encounteredClientContexts = new HashSet();
        try {
            result = this.createStatus(this.doValidate(objects, encounteredClientContexts));
        }
        catch (ValidationCanceledException e) {
            result = e.getStatus();
        }
        catch (OperationCanceledException e) {
            result = new Status(8, EMFModelValidationPlugin.getPluginId(), 2, e.getMessage(), null);
        }
        ValidationEvent event = new ValidationEvent(this.getEvaluationMode(), this.clientData, objects, result, this.getClientContextIds(encounteredClientContexts));
        ModelValidationService.getInstance().broadcastValidationEvent(event);
        return result;
    }

    private Collection getClientContextIds(Collection clientContexts) {
        ArrayList<String> contextIds = new ArrayList<String>();
        if (clientContexts == null) {
            return contextIds;
        }
        Iterator i = clientContexts.iterator();
        while (i.hasNext()) {
            IClientContext context = (IClientContext)i.next();
            contextIds.add(context.getId());
        }
        return contextIds;
    }

    protected abstract Collection doValidate(Collection var1, Set var2);

    protected IStatus evaluateConstraints(AbstractValidationContext ctx, List results) {
        IStatus resultStatus = Status.OK_STATUS;
        Iterator iter = ctx.getConstraints().iterator();
        while (iter.hasNext()) {
            IModelConstraint next = (IModelConstraint)iter.next();
            if (!this.acceptConstraint(next.getDescriptor(), ctx.getTarget())) continue;
            try {
                IStatus status = next.validate(ctx);
                if (status == null || !this.isReportSuccesses() && status.isOK()) continue;
                if (status.getSeverity() > resultStatus.getSeverity() && (resultStatus = status).matches(8)) {
                    throw new ValidationCanceledException(resultStatus);
                }
                results.add(status);
            }
            catch (ValidationCanceledException e) {
                throw e;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                DisabledConstraintStatus status = new DisabledConstraintStatus(next, ctx.getTarget(), e);
                results.add(status);
                Log.warning(status.getCode(), EMFModelValidationPlugin.getMessage(EMFModelValidationStatusCodes.CONSTRAINT_DISABLED_MSG, new Object[]{next.getDescriptor().getId()}), status.getException());
                ctx.disableCurrentConstraint(e);
            }
        }
        return resultStatus;
    }

    protected final void execute(IProviderOperation operation) {
        this.getOperationExecutor().execute(operation);
    }

    private IProviderOperationExecutor getOperationExecutor() {
        return this.executor;
    }

    private IStatus createStatus(Collection results) {
        if (results.isEmpty()) {
            return new Status(0, EMFModelValidationPlugin.getPluginId(), 10, EMFModelValidationStatusCodes.NO_CONSTRAINTS_EVALUATED_MSG, null);
        }
        if (results.size() == 1) {
            return (IStatus)results.iterator().next();
        }
        return new AggregateStatus(results);
    }

    private boolean acceptConstraint(IConstraintDescriptor constraint, EObject target) {
        if (this.filters != null) {
            Iterator iter = this.filters.iterator();
            while (iter.hasNext()) {
                IConstraintFilter filter = (IConstraintFilter)iter.next();
                if (filter.accept(constraint, target)) continue;
                return false;
            }
        }
        return true;
    }

    public void addConstraintFilter(IConstraintFilter filter) {
        if (this.filters == null) {
            this.filters = new BasicEList(4);
        }
        this.filters.add(filter);
    }

    public void removeConstraintFilter(IConstraintFilter filter) {
        if (this.filters != null) {
            this.filters.remove(filter);
        }
    }

    public Collection getConstraintFilters() {
        if (this.filters == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.filters);
    }

    private static class AggregateStatus
    implements IStatus {
        private final Collection children;
        private final int severity;
        private final int code;
        private final String message;

        AggregateStatus(Collection statuses) {
            String msg;
            int newCode;
            int maxSeverity = this.getMaximalSeverity(statuses);
            switch (maxSeverity) {
                case 4: {
                    newCode = 14;
                    msg = EMFModelValidationStatusCodes.SOME_CONSTRAINTS_ERROR_MSG;
                    break;
                }
                case 2: {
                    newCode = 13;
                    msg = EMFModelValidationStatusCodes.SOME_CONSTRAINTS_WARNING_MSG;
                    break;
                }
                case 1: {
                    newCode = 12;
                    msg = EMFModelValidationStatusCodes.SOME_CONSTRAINTS_INFO_MSG;
                    break;
                }
                case 0: {
                    newCode = 0;
                    msg = EMFModelValidationStatusCodes.ALL_CONSTRAINTS_PASSED_MSG;
                    break;
                }
                default: {
                    newCode = 11;
                    msg = EMFModelValidationStatusCodes.SOME_CONSTRAINTS_FAILED_MSG;
                }
            }
            this.children = statuses;
            this.severity = maxSeverity;
            this.code = newCode;
            this.message = msg;
        }

        public IStatus[] getChildren() {
            return this.children.toArray(new IStatus[this.children.size()]);
        }

        public int getSeverity() {
            return this.severity;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getException() {
            return null;
        }

        public String getPlugin() {
            return EMFModelValidationPlugin.getPluginId();
        }

        public boolean isMultiStatus() {
            return true;
        }

        public boolean isOK() {
            return this.severity == 0;
        }

        public boolean matches(int severityMask) {
            return (this.getSeverity() & severityMask) != 0;
        }

        private int getMaximalSeverity(Collection statuses) {
            int result = 0;
            Iterator iter = statuses.iterator();
            while (result < 4 && iter.hasNext()) {
                IStatus next = (IStatus)iter.next();
                if (next.getSeverity() <= result) continue;
                result = next.getSeverity();
            }
            return result;
        }
    }
}

