/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.TermDefinition;

public class GlossaryList {
    private TreeMap itemMap = new TreeMap();
    private String pubDir;

    public GlossaryList(String string) {
        this.pubDir = string;
    }

    public void clear() {
        this.itemMap.clear();
    }

    public void add(TermDefinition termDefinition) {
        String string = TngUtil.getPresentationName((Object)termDefinition);
        String string2 = "" + string.charAt(0);
        this.getItemList(string2).add(termDefinition);
    }

    private List getItemList(String string) {
        ArrayList arrayList = (ArrayList)this.itemMap.get(string = string.toUpperCase());
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.itemMap.put(string, arrayList);
        }
        return arrayList;
    }

    public StringBuffer getXml() {
        XmlElement xmlElement = new XmlElement("Glossary");
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        xmlElement.setAttribute("lang", string);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            String string2 = (String)entry.getKey();
            List list = (List)entry.getValue();
            xmlElement.newChild("item").setAttribute("name", string2).setAttribute("presentationName", string2).setAttribute("navigation-mark", "true").setAttribute("content", "");
            for (TermDefinition termDefinition : list) {
                String string3 = termDefinition.getName();
                String string4 = TngUtil.getPresentationName((Object)termDefinition);
                String string5 = termDefinition.getPresentation().getMainDescription();
                this.scanContentForResources((MethodElement)termDefinition, string5, ResourceHelper.getElementPath((MethodElement)termDefinition));
                string5 = ResourceHelper.fixContentUrlPath((String)string5, (String)ResourceHelper.getElementPath((MethodElement)termDefinition), (String)"./../");
                xmlElement.newChild("item").setAttribute("name", string3).setAttribute("presentationName", string4).setAttribute("content", string5);
            }
        }
        return xmlElement.toXml();
    }

    private void scanContentForResources(MethodElement methodElement, String string, String string2) {
        ContentResourceScanner contentResourceScanner = this.getScanner(methodElement);
        if (contentResourceScanner != null) {
            contentResourceScanner.resolveResources(methodElement, string, string2);
        }
    }

    private ContentResourceScanner getScanner(MethodElement methodElement) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr((MethodElement)methodElement);
        if (iLibraryResourceManager == null) {
            return null;
        }
        String string = iLibraryResourceManager.getLogicalPluginPath(methodElement);
        File file = new File(iLibraryResourceManager.getPhysicalPluginPath(methodElement));
        File file2 = new File(this.pubDir, string);
        ContentResourceScanner contentResourceScanner = new ContentResourceScanner(file, file2, string, null);
        return contentResourceScanner;
    }
}

