/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IConfiguratorFactory;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;

public final class Providers {
    private static IConfiguratorFactory configuratorFactory;
    private static IConfigurationApplicator configurationApplicator;
    private static IPreferenceStore preferenceStore;
    private static AbstractPlugin authoringPlugin;
    private static Map commandTypeToListenersMap;

    static {
        block7: {
            commandTypeToListenersMap = new HashMap();
            try {
                String string = LibraryEditPlugin.getDefault().getId();
                String string2 = "commandListeners";
                IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
                IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string, string2);
                if (iExtensionPoint == null) break block7;
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IExtension iExtension = iExtensionArray[n];
                    String string3 = iExtension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)string3);
                    IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        try {
                            Object t;
                            String string4 = iConfigurationElement.getAttribute("class");
                            if (string4 != null && (t = bundle.loadClass(string4).newInstance()) instanceof ICommandListener) {
                                Providers.registerCommandListener((ICommandListener)t);
                            }
                        }
                        catch (Exception exception) {
                            LibraryEditPlugin.INSTANCE.log(exception);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
    }

    private Providers() {
    }

    public static IConfiguratorFactory getConfiguratorFactory() {
        return configuratorFactory;
    }

    public static void setConfiguratorFactory(IConfiguratorFactory iConfiguratorFactory) {
        configuratorFactory = iConfiguratorFactory;
    }

    public static IConfigurationApplicator getConfigurationApplicator() {
        return configurationApplicator;
    }

    public static void setConfigurationApplicator(IConfigurationApplicator iConfigurationApplicator) {
        configurationApplicator = iConfigurationApplicator;
    }

    public static IPreferenceStore getPreferenceStore() {
        return preferenceStore;
    }

    public static void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        preferenceStore = iPreferenceStore;
    }

    public static AbstractPlugin getAuthoringPlugin() {
        return authoringPlugin;
    }

    public static void setAuthoringPlugin(AbstractPlugin abstractPlugin) {
        authoringPlugin = abstractPlugin;
    }

    public static void registerCommandListener(ICommandListener iCommandListener) {
        ArrayList<ICommandListener> arrayList = (ArrayList<ICommandListener>)commandTypeToListenersMap.get(iCommandListener.getCommandType());
        if (arrayList == null) {
            arrayList = new ArrayList<ICommandListener>();
            commandTypeToListenersMap.put(iCommandListener.getCommandType(), arrayList);
        } else if (arrayList.contains(iCommandListener)) {
            return;
        }
        arrayList.add(iCommandListener);
    }

    public static void removeCommandListener(ICommandListener iCommandListener) {
        List list = (List)commandTypeToListenersMap.get(iCommandListener.getCommandType());
        if (list != null) {
            list.remove(iCommandListener);
            if (list.isEmpty()) {
                commandTypeToListenersMap.remove(iCommandListener.getCommandType());
            }
        }
    }

    public static List getCommandListeners(Class clazz) {
        return (List)commandTypeToListenersMap.get(clazz);
    }
}

