/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.ui.ReferenceSelection;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.AssociationHelper;

public class DeleteWorkProductDescriptor
extends RemoveUnusedDescriptorsCommand {
    private Activity activity;
    private WorkProductDescriptor wpDesc;
    private Collection modifiedResources;
    private List notUsedReferences = new ArrayList();
    private boolean forceRemoveUnusedReferences;

    public DeleteWorkProductDescriptor(WorkProductDescriptor workProductDescriptor) {
        this.wpDesc = workProductDescriptor;
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)workProductDescriptor, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)workProductDescriptor);
        if (object instanceof Activity) {
            this.activity = (Activity)object;
        }
        this.modifiedResources = new HashSet();
        if (this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        if (workProductDescriptor.eResource() != null) {
            this.modifiedResources.add(workProductDescriptor.eResource());
        }
    }

    public DeleteWorkProductDescriptor(WorkProductDescriptor workProductDescriptor, boolean bl) {
        this(workProductDescriptor);
        this.forceRemoveUnusedReferences = bl;
    }

    public void execute() {
        Object object;
        Object[] objectArray;
        HashSet<List> hashSet = new HashSet<List>();
        List list = AssociationHelper.getMandatoryInputTo((WorkProductDescriptor)this.wpDesc);
        List list2 = AssociationHelper.getExternalInputTo((WorkProductDescriptor)this.wpDesc);
        List list3 = AssociationHelper.getOptionalInputTo((WorkProductDescriptor)this.wpDesc);
        List list4 = AssociationHelper.getOutputFrom((WorkProductDescriptor)this.wpDesc);
        List list5 = AssociationHelper.getResponsibleRoleDescriptors((WorkProductDescriptor)this.wpDesc);
        hashSet.addAll(this.wpDesc.getImpactedBy());
        hashSet.addAll(this.wpDesc.getImpacts());
        hashSet.addAll(list);
        hashSet.addAll(list2);
        hashSet.addAll(list3);
        hashSet.addAll(list4);
        hashSet.add(list5);
        for (Object object22 : hashSet) {
            if (!(object22 instanceof Descriptor) || ProcessUtil.checkDescriptorReferences((Descriptor)this.wpDesc, (Descriptor)object22) || !this.activity.getBreakdownElements().contains(object22)) continue;
            this.notUsedReferences.add(object22);
        }
        if (!this.notUsedReferences.isEmpty()) {
            try {
                objectArray = this.forceRemoveUnusedReferences ? this.notUsedReferences.toArray() : ReferenceSelection.getReferences(this.notUsedReferences, (Descriptor)this.wpDesc);
                this.delete(objectArray);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.aborted = true;
            }
        }
        objectArray = new ArrayList();
        if (this.wpDesc.getWorkProduct() instanceof Artifact) {
            Artifact artifact = (Artifact)this.wpDesc.getWorkProduct();
            List list6 = artifact.getContainedArtifacts();
            int n = 0;
            while (n < list6.size()) {
                object = this.getDescriptor(this.wpDesc, (Artifact)list6.get(n));
                if (object != null) {
                    objectArray.add(object);
                }
                ++n;
            }
        }
        ArrayList<WorkProductDescriptor> arrayList = new ArrayList<WorkProductDescriptor>();
        arrayList.add(this.wpDesc);
        arrayList.addAll((Collection<WorkProductDescriptor>)objectArray);
        for (Object e : arrayList) {
            if (!(e instanceof WorkProductDescriptor)) continue;
            object = (WorkProductDescriptor)e;
            this.clear(object.getImpactedBy());
            this.clear(object.getImpacts());
            for (TaskDescriptor taskDescriptor : list2) {
                taskDescriptor.getExternalInput().remove(object);
            }
            for (TaskDescriptor taskDescriptor : list) {
                taskDescriptor.getMandatoryInput().remove(object);
            }
            for (TaskDescriptor taskDescriptor : list3) {
                taskDescriptor.getOptionalInput().remove(object);
            }
            for (TaskDescriptor taskDescriptor : list4) {
                taskDescriptor.getOutput().remove(object);
            }
            for (TaskDescriptor taskDescriptor : list5) {
                taskDescriptor.getResponsibleFor().remove(object);
            }
        }
        this.redo();
    }

    private void clear(List list) {
        try {
            if (list != null && list.size() > 0) {
                list.clear();
            }
        }
        catch (Exception exception) {
            LibraryEditPlugin.INSTANCE.log(exception);
        }
    }

    private Object getDescriptor(Object object, Artifact artifact) {
        if (this.activity == null) {
            return null;
        }
        List list = this.activity.getBreakdownElements();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            if (e instanceof WorkProductDescriptor && artifact == ((WorkProductDescriptor)e).getWorkProduct()) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public void redo() {
    }

    public void undo() {
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

