/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.validation.UniqueNamePNameHandler;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class WBSDropCommand
extends BSDropCommand {
    private ArrayList roleDescList;
    private ArrayList wpDescList;
    private HashMap wpDescToDeliverableParts;
    private HashMap wpdToDeliverableDescriptorMap;
    private HashMap roleDescTeamProfileMap;
    private BSDropCommand.IExecutor executor;

    public WBSDropCommand(Activity activity, List list) {
        super(activity, list);
        Iterator iterator = this.dropElements.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Task) continue;
            iterator.remove();
        }
    }

    public WBSDropCommand(Activity activity, List list, boolean bl) {
        super(activity, list, bl);
    }

    public WBSDropCommand(Activity activity, List list, MethodConfiguration methodConfiguration, Set set) {
        super(activity, list, methodConfiguration, set);
    }

    public BSDropCommand.IExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new Executor();
        }
        return this.executor;
    }

    protected boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        return this.getExecutor().preExecute();
    }

    protected void doExecute() {
        this.executor.doExcecute();
    }

    public Collection getAffectedObjects() {
        if (this.taskDescList != null) {
            return this.taskDescList;
        }
        return super.getAffectedObjects();
    }

    protected void doUndo() {
        this.executor.doUndo();
    }

    public void dispose() {
        if (this.roleDescList != null) {
            this.roleDescList.clear();
        }
        if (this.roleDescTeamProfileMap != null) {
            this.roleDescTeamProfileMap.clear();
        }
        if (this.wpDescList != null) {
            this.wpDescList.clear();
        }
        if (this.wpDescToDeliverableParts != null) {
            this.wpDescToDeliverableParts.clear();
        }
        if (this.wpdToDeliverableDescriptorMap != null) {
            this.wpdToDeliverableDescriptorMap.clear();
        }
        super.dispose();
    }

    private class Executor
    implements BSDropCommand.IExecutor {
        private Executor() {
        }

        public boolean preExecute() {
            Task task;
            WBSDropCommand.this.taskDescList = new ArrayList();
            WBSDropCommand.this.roleDescList = new ArrayList();
            WBSDropCommand.this.wpDescList = new ArrayList();
            WBSDropCommand.this.wpDescToDeliverableParts = new HashMap();
            WBSDropCommand.this.wpdToDeliverableDescriptorMap = new HashMap();
            Set set = WBSDropCommand.this.synchronize ? WBSDropCommand.this.batchCommand.getDescriptorsToRefresh() : null;
            List list = WBSDropCommand.this.activity.getBreakdownElements();
            UniqueNamePNameHandler uniqueNamePNameHandler = new UniqueNamePNameHandler(list, list);
            int n = 0;
            while (n < WBSDropCommand.this.dropElements.size()) {
                task = (Task)WBSDropCommand.this.dropElements.get(n);
                TaskDescriptor taskDescriptor = ProcessCommandUtil.createTaskDescriptor(task, WBSDropCommand.this.activity, WBSDropCommand.this.roleDescList, WBSDropCommand.this.wpDescList, WBSDropCommand.this.wpDescToDeliverableParts, WBSDropCommand.this.wpdToDeliverableDescriptorMap, set, WBSDropCommand.this.batchCommand.getObjectToNewFeatureValuesMap(), WBSDropCommand.this.getMethodConfiguration(), WBSDropCommand.this.synchronize, WBSDropCommand.this.synchFeatures);
                if (taskDescriptor != null) {
                    uniqueNamePNameHandler.ensureUnique((DescribableElement)taskDescriptor);
                    WBSDropCommand.this.taskDescList.add(taskDescriptor);
                }
                ++n;
            }
            n = 0;
            while (n < WBSDropCommand.this.roleDescList.size()) {
                task = (RoleDescriptor)WBSDropCommand.this.roleDescList.get(n);
                if (task != null) {
                    uniqueNamePNameHandler.ensureUnique((DescribableElement)task);
                }
                ++n;
            }
            n = 0;
            while (n < WBSDropCommand.this.wpDescList.size()) {
                task = (WorkProductDescriptor)WBSDropCommand.this.wpDescList.get(n);
                if (task != null) {
                    uniqueNamePNameHandler.ensureUnique((DescribableElement)task);
                }
                ++n;
            }
            return !WBSDropCommand.this.taskDescList.isEmpty() || !WBSDropCommand.this.roleDescList.isEmpty() || !WBSDropCommand.this.wpDescList.isEmpty() || !WBSDropCommand.this.wpDescToDeliverableParts.isEmpty() || !WBSDropCommand.this.wpdToDeliverableDescriptorMap.isEmpty() || WBSDropCommand.this.batchCommand.canExecute();
        }

        public void doExcecute() {
            WorkProductDescriptor workProductDescriptor;
            if (!WBSDropCommand.this.wpdToDeliverableDescriptorMap.isEmpty()) {
                for (Map.Entry roleDescriptor : WBSDropCommand.this.wpdToDeliverableDescriptorMap.entrySet()) {
                    workProductDescriptor = (WorkProductDescriptor)roleDescriptor.getValue();
                    if (workProductDescriptor.getDeliverableParts().contains(roleDescriptor.getKey())) continue;
                    try {
                        workProductDescriptor.getDeliverableParts().add(roleDescriptor.getKey());
                    }
                    catch (Exception exception) {
                        LibraryEditPlugin.INSTANCE.log("WBSDropCommand::doExecute - Adding deliverable part to deliverable" + exception);
                    }
                }
            }
            WBSDropCommand.this.activity.getBreakdownElements().addAll(WBSDropCommand.this.taskDescList);
            WBSDropCommand.this.activity.getBreakdownElements().addAll(WBSDropCommand.this.roleDescList);
            WBSDropCommand.this.activity.getBreakdownElements().addAll(WBSDropCommand.this.wpDescList);
            if (!WBSDropCommand.this.wpDescToDeliverableParts.isEmpty()) {
                for (Map.Entry entry : WBSDropCommand.this.wpDescToDeliverableParts.entrySet()) {
                    workProductDescriptor = (WorkProductDescriptor)entry.getKey();
                    workProductDescriptor.getDeliverableParts().addAll((Collection)entry.getValue());
                }
            }
            if (WBSDropCommand.this.roleDescTeamProfileMap == null) {
                WBSDropCommand.this.roleDescTeamProfileMap = new HashMap();
                for (RoleDescriptor roleDescriptor : WBSDropCommand.this.roleDescList) {
                    workProductDescriptor = UserInteractionHelper.getTeam(WBSDropCommand.this.activity, roleDescriptor.getRole());
                    if (workProductDescriptor == null) continue;
                    WBSDropCommand.this.roleDescTeamProfileMap.put(roleDescriptor, workProductDescriptor);
                }
            }
            for (Map.Entry entry : WBSDropCommand.this.roleDescTeamProfileMap.entrySet()) {
                workProductDescriptor = (TeamProfile)entry.getValue();
                workProductDescriptor.getTeamRoles().add(entry.getKey());
            }
            Iterator iterator = (ProcessPackage)WBSDropCommand.this.activity.eContainer();
            if (iterator != null) {
                iterator.getProcessElements().addAll(WBSDropCommand.this.taskDescList);
                iterator.getProcessElements().addAll(WBSDropCommand.this.roleDescList);
                iterator.getProcessElements().addAll(WBSDropCommand.this.wpDescList);
            }
        }

        public void doUndo() {
            WorkProductDescriptor workProductDescriptor;
            WBSDropCommand.this.activity.getBreakdownElements().removeAll(WBSDropCommand.this.wpDescList);
            WBSDropCommand.this.activity.getBreakdownElements().removeAll(WBSDropCommand.this.roleDescList);
            WBSDropCommand.this.activity.getBreakdownElements().removeAll(WBSDropCommand.this.taskDescList);
            if (!WBSDropCommand.this.wpDescToDeliverableParts.isEmpty()) {
                for (Map.Entry entry : WBSDropCommand.this.wpDescToDeliverableParts.entrySet()) {
                    workProductDescriptor = (WorkProductDescriptor)entry.getKey();
                    workProductDescriptor.getDeliverableParts().removeAll((Collection)entry.getValue());
                }
            }
            if (!WBSDropCommand.this.wpdToDeliverableDescriptorMap.isEmpty()) {
                for (Map.Entry entry : WBSDropCommand.this.wpdToDeliverableDescriptorMap.entrySet()) {
                    workProductDescriptor = (WorkProductDescriptor)entry.getValue();
                    workProductDescriptor.getDeliverableParts().remove(entry.getKey());
                }
            }
            for (Map.Entry entry : WBSDropCommand.this.roleDescTeamProfileMap.entrySet()) {
                workProductDescriptor = (TeamProfile)entry.getValue();
                workProductDescriptor.getTeamRoles().remove(entry.getKey());
            }
            ProcessPackage processPackage = (ProcessPackage)WBSDropCommand.this.activity.eContainer();
            if (processPackage != null) {
                processPackage.getProcessElements().removeAll(WBSDropCommand.this.taskDescList);
                processPackage.getProcessElements().removeAll(WBSDropCommand.this.roleDescList);
                processPackage.getProcessElements().removeAll(WBSDropCommand.this.wpDescList);
            }
        }
    }
}

