/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.ProcessPlanningTemplate;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewProcessComponentDialog
extends Dialog {
    private Composite area;
    private Text ctrl_name;
    private ComboViewer configComboViewer;
    private MethodConfiguration[] availableConfigurations;
    private ProcessComponent newProcComp;
    private Process[] availableBaseProcesses;
    private CheckboxTableViewer processTableViewer;
    private static final Collection ECLASS = new HashSet();
    private IValidator validator;

    static {
        ECLASS.add(UmaPackage.eINSTANCE.getProcessComponent());
    }

    public NewProcessComponentDialog(Shell shell, MethodConfiguration[] methodConfigurationArray, ProcessComponent processComponent, Process[] processArray, MethodPlugin methodPlugin, ProcessPackage processPackage) {
        super(shell);
        this.availableConfigurations = methodConfigurationArray;
        this.newProcComp = processComponent;
        this.availableBaseProcesses = processArray;
        this.validator = IValidatorFactory.INSTANCE.createNameValidator((Object)processPackage, (NamedElement)this.newProcComp);
    }

    protected Control createDialogArea(Composite composite) {
        this.area = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        this.area.setLayoutData((Object)gridData);
        Label label = new Label(this.area, 0);
        label.setText(LibraryEditResources.nameLabel_text);
        GridData gridData2 = new GridData(1);
        label.setLayoutData((Object)gridData2);
        this.ctrl_name = new Text(this.area, 2048);
        gridData2 = new GridData(769);
        gridData2.horizontalSpan = 2;
        gridData2.widthHint = 200;
        this.ctrl_name.setLayoutData((Object)gridData2);
        gridData2 = new Label(this.area, 0);
        gridData2.setText(LibraryEditResources.defaultConfigLabel_text);
        GridData gridData3 = new GridData(1);
        gridData2.setLayoutData((Object)gridData3);
        gridData3 = new Composite(this.area, 0);
        Object object = new GridData(769);
        object.horizontalSpan = 2;
        gridData3.setLayoutData(object);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridData3.setLayout((Layout)gridLayout2);
        this.configComboViewer = new ComboViewer((Composite)gridData3, 2056);
        object = new GridData(769);
        object.widthHint = 200;
        this.configComboViewer.getCombo().setLayoutData(object);
        object = new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof MethodElement) {
                    return ((MethodElement)object).getName();
                }
                return object.toString();
            }
        };
        this.configComboViewer.setLabelProvider((IBaseLabelProvider)object);
        this.configComboViewer.add((Object[])this.availableConfigurations);
        if (this.newProcComp.getProcess().getDefaultContext() != null) {
            this.configComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.newProcComp.getProcess().getDefaultContext()));
        }
        if (this.newProcComp.getProcess() instanceof ProcessPlanningTemplate) {
            gridLayout2 = new Label(this.area, 0);
            gridLayout2.setText(LibraryEditResources.basedOnProcessesLabel_text);
            GridData gridData4 = new GridData(1);
            gridLayout2.setLayoutData((Object)gridData4);
            gridData3 = new Composite(this.area, 0);
            gridData4 = new GridData(769);
            gridData4.horizontalSpan = 2;
            gridData3.setLayoutData((Object)gridData4);
            GridLayout gridLayout3 = new GridLayout();
            gridLayout3.marginWidth = 0;
            gridLayout3.marginHeight = 0;
            gridData3.setLayout((Layout)gridLayout3);
            this.processTableViewer = CheckboxTableViewer.newCheckList((Composite)gridData3, (int)2048);
            this.processTableViewer.getTable().setLayoutData((Object)new GridData(769));
            gridData4 = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
            this.processTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)gridData4));
            this.processTableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)gridData4));
            this.processTableViewer.add((Object[])this.availableBaseProcesses);
        }
        if (this.newProcComp.getName() != null) {
            this.ctrl_name.setText(this.newProcComp.getName());
        }
        super.getShell().setText(LibraryEditResources.newProcessComponentDialog_title);
        return this.area;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        super.getButton(0);
        super.getButton(1);
    }

    protected void okPressed() {
        String string = this.ctrl_name.getText().trim();
        String string2 = this.validator.isValid(string = StrUtil.makeValidFileName((String)string));
        if (string2 != null) {
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.createProcess_text, string2);
            this.ctrl_name.setFocus();
            this.ctrl_name.selectAll();
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.configComboViewer.getSelection();
        if (iStructuredSelection.isEmpty()) {
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.createProcess_text, LibraryEditResources.noDefaultConfigError_msg);
            return;
        }
        this.newProcComp.setName(string);
        this.newProcComp.getProcess().setName(string);
        this.newProcComp.getProcess().setPresentationName(string);
        this.newProcComp.getProcess().setDefaultContext((MethodConfiguration)((IStructuredSelection)this.configComboViewer.getSelection()).getFirstElement());
        if (this.newProcComp.getProcess() instanceof ProcessPlanningTemplate) {
            ProcessPlanningTemplate processPlanningTemplate = (ProcessPlanningTemplate)this.newProcComp.getProcess();
            processPlanningTemplate.getBasedOnProcesses().addAll((Collection)Arrays.asList(this.processTableViewer.getCheckedElements()));
        }
        super.okPressed();
    }
}

