/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.provider.AttributeValueWrapperItemProvider;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.IDefaultNameSetter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IGroupContainer;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.category.CustomCategoryItemProvider;
import org.eclipse.epf.library.edit.category.DisciplineItemProvider;
import org.eclipse.epf.library.edit.category.RoleSetItemProvider;
import org.eclipse.epf.library.edit.category.StandardCategoriesItemProvider;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.element.ContentPackageItemProvider;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPluginItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.MoveDownCommand;
import org.eclipse.epf.library.edit.process.command.MoveUpCommand;
import org.eclipse.epf.library.edit.util.ConfigurationUtil;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.ILibraryInspector;
import org.eclipse.epf.library.edit.util.LibraryEditConstants;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.model.OrderInfo;
import org.eclipse.epf.library.edit.util.model.OrderInfoCollection;
import org.eclipse.epf.library.edit.util.model.util.StringResource;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.library.edit.validation.UniqueNameHandler;
import org.eclipse.epf.services.IAccessController;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.ProcessPlanningTemplate;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.Whitepaper;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.provider.MethodElementItemProvider;
import org.eclipse.epf.uma.provider.UmaEditPlugin;
import org.eclipse.epf.uma.provider.UmaItemProviderAdapterFactory;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaResources;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TngUtil {
    public static final UmaItemProviderAdapterFactory umaItemProviderAdapterFactory = new UmaItemProviderAdapterFactory();
    public static final boolean DEBUG = LibraryEditPlugin.getPlugin().isDebugging();
    public static final String GUIDANCE_FILESTRING_SEPARATOR = "|";
    private static final String GUIDANCE_FILESTRING_SEPARATOR_SPLITTER = "\\|";
    public static final String PUBLISH_CATEGORY_PROPERTY = "PUBLISH_CATEGORY";

    public static void removeAdapters(EObject eObject, Class clazz) {
        Iterator iterator = eObject.eAdapters().iterator();
        while (iterator.hasNext()) {
            Adapter adapter = (Adapter)iterator.next();
            if (!clazz.isInstance(adapter)) continue;
            iterator.remove();
        }
    }

    public static Object getAdapter(EObject eObject, Class clazz) {
        for (Adapter adapter : eObject.eAdapters()) {
            if (!clazz.isInstance(adapter)) continue;
            return adapter;
        }
        return null;
    }

    public static Adapter adapt(AdapterFactory adapterFactory, Notifier notifier, Object object, Class clazz) {
        for (Adapter adapter : notifier.eAdapters()) {
            if (!adapter.isAdapterForType(object) || !clazz.isInstance(adapter)) continue;
            return adapter;
        }
        return adapterFactory.adaptNew(notifier, object);
    }

    public static boolean isValidFileName(String string) {
        if (StrUtil.isBlank((String)string)) {
            return false;
        }
        return string.indexOf(47) == -1 && string.indexOf(92) == -1 && string.indexOf(58) == -1 && string.indexOf(42) == -1 && string.indexOf(63) == -1 && string.indexOf(34) == -1 && string.indexOf(60) == -1 && string.indexOf(62) == -1 && string.indexOf(124) == -1 && string.indexOf(59) == -1;
    }

    public static boolean isValidPluginName(String string) {
        if (!TngUtil.isValidFileName(string)) {
            return false;
        }
        return string.indexOf(37) == -1 && string.indexOf(35) == -1 && string.indexOf(39) == -1;
    }

    public static String checkName(NamedElement namedElement, String string, Collection collection) {
        return TngUtil.checkName(namedElement.eContainer(), namedElement, string, TngUtil.getTypeText((EObject)namedElement), collection);
    }

    public static String checkName(EObject eObject, NamedElement namedElement, String string, String string2, Collection collection) {
        String string3 = TngUtil.checkElementName(string, string2);
        if (string3 != null) {
            return string3;
        }
        if (eObject == null) {
            return null;
        }
        EList eList = eObject.eContents();
        int n = 0;
        while (n < eList.size()) {
            NamedElement namedElement2 = (NamedElement)eList.get(n);
            if (namedElement2 != namedElement && TngUtil.isEClassInstanceOf(collection, namedElement2) && string.equalsIgnoreCase(namedElement2.getName())) {
                return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)string);
            }
            ++n;
        }
        return null;
    }

    public static String checkName(EObject eObject, NamedElement namedElement, String string, String string2, IFilter iFilter) {
        String string3 = TngUtil.checkElementName(string, string2);
        if (string3 != null) {
            return string3;
        }
        if (eObject == null) {
            return null;
        }
        EList eList = eObject.eContents();
        int n = 0;
        while (n < eList.size()) {
            NamedElement namedElement2 = (NamedElement)eList.get(n);
            if (namedElement2 != namedElement && iFilter.accept(namedElement2) && string.equalsIgnoreCase(namedElement2.getName())) {
                return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)string);
            }
            ++n;
        }
        return null;
    }

    public static String checkName(File file, Collection collection, NamedElement namedElement, String string, String string2, boolean bl) {
        boolean bl2;
        String string3 = TngUtil.checkElementName(string, string2);
        if (string3 != null) {
            return string3;
        }
        String string4 = string;
        if (!bl) {
            string4 = String.valueOf(string4) + ((IFileBasedLibraryPersister)Services.getDefaultLibraryPersister()).getFileExtension((Object)namedElement);
        }
        File file2 = new File(file, string4);
        File file3 = null;
        if (namedElement != null && namedElement.eResource() != null) {
            file3 = new File(namedElement.eResource().getURI().toFileString());
            if (bl) {
                file3 = file3.getParentFile();
            }
        }
        if ((bl2 = file2.exists()) && !file2.equals(file3)) {
            string3 = NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)string);
            return string3;
        }
        for (NamedElement namedElement2 : collection) {
            if (namedElement2 == namedElement || !string.equalsIgnoreCase(namedElement2.getName())) continue;
            return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)string);
        }
        return null;
    }

    public static String checkElementName(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return NLS.bind((String)LibraryEditResources.emptyElementNameError_msg, (Object)StrUtil.toLower((String)string2));
        }
        if (string.startsWith(" ")) {
            return NLS.bind((String)LibraryEditResources.invalidElementNameError1_msg, (Object)string);
        }
        if (string.endsWith(".")) {
            return NLS.bind((String)LibraryEditResources.invalidElementNameError2_msg, (Object)string);
        }
        if (!TngUtil.isValidFileName(string)) {
            return NLS.bind((String)LibraryEditResources.invalidElementNameError3_msg, (Object)string);
        }
        return null;
    }

    public static String checkPluginName(String string) {
        String string2 = TngUtil.checkElementName(string, TngUtil.getTypeText("MethodPlugin"));
        if (string2 != null) {
            return string2;
        }
        if (!TngUtil.isValidPluginName(string)) {
            return NLS.bind((String)LibraryEditResources.invalidPluginNameError_msg, (Object)string);
        }
        return null;
    }

    public static String checkActivityName(AdapterFactory adapterFactory, Object object, String string, Suppression suppression) {
        if (!(object instanceof Activity)) {
            return null;
        }
        return NameChecker.checkName(adapterFactory, (BreakdownElement)object, Activity.class, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), string, suppression);
    }

    public static String checkWBSActivityPresentationName(Object object, String string, Suppression suppression) {
        if (!(object instanceof Activity)) {
            return null;
        }
        return NameChecker.checkName((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (BreakdownElement)object, Activity.class, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), string, suppression);
    }

    public static String checkWorkBreakdownElementPresentationName(Object object, String string, Suppression suppression) {
        if (!(object instanceof WorkBreakdownElement)) {
            return null;
        }
        return NameChecker.checkName((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (BreakdownElement)object, WorkBreakdownElement.class, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), string, suppression);
    }

    public static String checkWorkProductDescriptorPresentationName(Object object, String string, Suppression suppression) {
        if (!(object instanceof WorkProductDescriptor)) {
            return null;
        }
        return NameChecker.checkName((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (BreakdownElement)object, WorkProductDescriptor.class, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), string, suppression);
    }

    public static String checkRoleDescriptorPresentationName(Object object, String string, Suppression suppression) {
        if (!(object instanceof RoleDescriptor)) {
            return null;
        }
        return NameChecker.checkName((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), (BreakdownElement)object, RoleDescriptor.class, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), string, suppression);
    }

    public static boolean isEClassInstanceOf(Collection collection, Object object) {
        for (EClass eClass : collection) {
            if (!eClass.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceOf(Collection collection, Object object) {
        for (Class clazz : collection) {
            if (!clazz.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static AdapterFactory getBestAdapterFactory(AdapterFactory adapterFactory) {
        if (adapterFactory instanceof ComposeableAdapterFactory) {
            return ((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory();
        }
        return adapterFactory;
    }

    public static String getLabel(Object object) {
        return TngUtil.getLabel(object, "");
    }

    public static String getLabel(Object object, String string) {
        Object object2;
        if (object instanceof ContentDescription) {
            return TngUtil.getLabel(((ContentDescription)object).eContainer(), string);
        }
        if (object instanceof EObject && (object2 = (EObject)object).eIsProxy()) {
            String string2 = null;
            try {
                URI uRI = object2.eResource().getResourceSet().getURIConverter().normalize(((InternalEObject)object2).eProxyURI());
                string2 = uRI.isFile() ? uRI.toFileString() : uRI.toString();
            }
            catch (Exception exception) {}
            string2 = string2 != null ? MessageFormat.format(" ''{0}''", string2) : "";
            return NLS.bind((String)LibraryEditResources.unresolved_text, (Object)string2);
        }
        object2 = null;
        boolean bl = PresentationContext.INSTANCE.isShowPresentationNames();
        if (bl && object instanceof DescribableElement) {
            object2 = ((DescribableElement)object).getPresentationName();
        } else if (bl && object instanceof ProcessComponent) {
            object2 = ((ProcessComponent)object).getProcess().getPresentationName();
        }
        if (object2 == null || ((String)object2).trim().length() == 0) {
            object2 = ((NamedElement)object).getName();
        }
        return object2 == null || ((String)object2).trim().length() == 0 ? string : object2;
    }

    public static String getLabel(VariabilityElement variabilityElement, String string, boolean bl) {
        String string2 = TngUtil.getLabel(variabilityElement, string);
        if (bl && variabilityElement.getVariabilityBasedOnElement() != null) {
            VariabilityType variabilityType = variabilityElement.getVariabilityType();
            String string3 = null;
            if (variabilityType == VariabilityType.CONTRIBUTES_LITERAL) {
                string3 = LibraryEditResources.contributesTo_text;
            } else if (variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
                string3 = LibraryEditResources.localContributesTo_text;
            } else if (variabilityType == VariabilityType.EXTENDS_LITERAL) {
                string3 = LibraryEditResources.extends_text;
            } else if (variabilityType == VariabilityType.REPLACES_LITERAL) {
                string3 = LibraryEditResources.replaces_text;
            } else if (variabilityType == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
                string3 = LibraryEditResources.localReplaces_text;
            } else if (variabilityType == VariabilityType.EXTENDS_REPLACES_LITERAL) {
                string3 = LibraryEditResources.extends_replaces_text;
            }
            if (string3 != null) {
                MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)variabilityElement.getVariabilityBasedOnElement());
                string2 = methodPlugin != null ? NLS.bind((String)LibraryEditResources.Util_labelpath_variabilitywithplugin_info, (Object[])new String[]{string2, string3, TngUtil.getLabel(variabilityElement.getVariabilityBasedOnElement(), string), methodPlugin.getName()}) : NLS.bind((String)LibraryEditResources.Util_labelpath_variability_info, (Object[])new String[]{string2, string3, TngUtil.getLabel(variabilityElement.getVariabilityBasedOnElement(), string)});
            }
        }
        return string2;
    }

    public static void initializeProcessComponent(ProcessComponent processComponent, EClass eClass) {
        Process process = processComponent.getProcess();
        if (process == null) {
            process = (Process)UmaFactory.eINSTANCE.create(eClass);
            processComponent.setProcess(process);
        }
    }

    public static BreakdownElement getParent(BreakdownElement breakdownElement) {
        return null;
    }

    public static String checkNull(String string) {
        return string == null ? "" : string;
    }

    public static boolean descriptorExists(Role role, List list) {
        int n = list.size() - 1;
        while (n > -1) {
            RoleDescriptor roleDescriptor = (RoleDescriptor)list.get(n);
            if (roleDescriptor.getRole() == role) {
                return true;
            }
            --n;
        }
        return false;
    }

    public static MethodElement copy(MethodElement methodElement) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){
            private static final long serialVersionUID = 3257846576033904691L;

            protected void copyReference(EReference eReference, EObject eObject, EObject eObject2) {
                if (eObject.eIsSet((EStructuralFeature)eReference)) {
                    boolean bl;
                    OppositeFeature oppositeFeature = OppositeFeature.getOppositeFeature((EStructuralFeature)eReference);
                    boolean bl2 = bl = eReference.getEOpposite() != null || oppositeFeature != null && !oppositeFeature.isMany();
                    if (eReference.isMany()) {
                        List list = (List)eObject.eGet((EStructuralFeature)eReference);
                        InternalEList internalEList = (InternalEList)eObject2.eGet(this.getTarget((EStructuralFeature)eReference));
                        if (list.isEmpty()) {
                            internalEList.clear();
                        } else {
                            int n = 0;
                            for (Object e : list) {
                                Object object = this.get(e);
                                if (object == null) {
                                    if (bl) continue;
                                    internalEList.addUnique(n, e);
                                    ++n;
                                    continue;
                                }
                                if (bl) {
                                    int n2 = internalEList.indexOf(object);
                                    if (n2 == -1) {
                                        internalEList.addUnique(n, object);
                                    } else if (n != n2) {
                                        internalEList.move(n, object);
                                    }
                                } else {
                                    internalEList.addUnique(n, object);
                                }
                                ++n;
                            }
                        }
                    } else {
                        Object object = eObject.eGet((EStructuralFeature)eReference);
                        if (object == null) {
                            eObject2.eSet(this.getTarget((EStructuralFeature)eReference), null);
                        } else {
                            Object object2 = this.get(object);
                            if (object2 == null) {
                                if (!bl) {
                                    eObject2.eSet(this.getTarget((EStructuralFeature)eReference), object);
                                }
                            } else {
                                eObject2.eSet(this.getTarget((EStructuralFeature)eReference), object2);
                            }
                        }
                    }
                }
            }
        };
        MethodElement methodElement2 = (MethodElement)copier.copy((EObject)methodElement);
        copier.copyReferences();
        methodElement2.setGuid(null);
        TreeIterator treeIterator = methodElement2.eAllContents();
        while (treeIterator.hasNext()) {
            Object e = treeIterator.next();
            if (!(e instanceof MethodElement)) continue;
            ((MethodElement)e).setGuid(null);
        }
        return methodElement2;
    }

    public static VariabilityElement getBase(VariabilityElement variabilityElement) {
        while (variabilityElement.getVariabilityBasedOnElement() != null) {
            variabilityElement = variabilityElement.getVariabilityBasedOnElement();
        }
        return variabilityElement;
    }

    public static ContentCategory findInherited(Collection collection, ContentCategory contentCategory) {
        for (ContentCategory contentCategory2 : collection) {
            if (contentCategory2.getVariabilityBasedOnElement() == null || contentCategory2.getVariabilityBasedOnElement() != contentCategory && contentCategory2.getVariabilityBasedOnElement() != contentCategory.getVariabilityBasedOnElement()) continue;
            return contentCategory2;
        }
        return null;
    }

    public static ContentCategory removeInherited(List list, ContentCategory contentCategory) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ContentCategory contentCategory2 = (ContentCategory)iterator.next();
            if (contentCategory2.getVariabilityBasedOnElement() != contentCategory) continue;
            iterator.remove();
            return contentCategory2;
        }
        return null;
    }

    public static ContentItemProvider getContentItemProvider(MethodPlugin methodPlugin) {
        MethodPluginItemProvider methodPluginItemProvider = (MethodPluginItemProvider)TngUtil.getAdapter((EObject)methodPlugin, MethodPluginItemProvider.class);
        methodPluginItemProvider.getChildren(methodPlugin);
        IGroupContainer iGroupContainer = (IGroupContainer)TngUtil.getAdapter((EObject)methodPlugin, IGroupContainer.class);
        if (iGroupContainer != null) {
            return (ContentItemProvider)iGroupContainer.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Content_group"));
        }
        return null;
    }

    public static StandardCategoriesItemProvider getStandardCategoriesItemProvider(MethodPlugin methodPlugin) {
        ContentItemProvider contentItemProvider = TngUtil.getContentItemProvider(methodPlugin);
        contentItemProvider.getChildren(contentItemProvider);
        if (contentItemProvider != null) {
            return (StandardCategoriesItemProvider)contentItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Standard_Categories_group"));
        }
        return null;
    }

    public static Object getDisciplineCategoriesItemProvider(MethodPlugin methodPlugin) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(methodPlugin);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Disciplines_group"));
        }
        return null;
    }

    public static Object getDomainsItemProvider(MethodPlugin methodPlugin) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(methodPlugin);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Domains_group"));
        }
        return null;
    }

    public static Object getWorkProductTypesItemProvider(MethodPlugin methodPlugin) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(methodPlugin);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_WorkProductTypes_group"));
        }
        return null;
    }

    public static Object getRoleSetsItemProvider(MethodPlugin methodPlugin) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(methodPlugin);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Role_Sets_group"));
        }
        return null;
    }

    public static Object getToolsItemProvider(MethodPlugin methodPlugin) {
        StandardCategoriesItemProvider standardCategoriesItemProvider = TngUtil.getStandardCategoriesItemProvider(methodPlugin);
        standardCategoriesItemProvider.getChildren(standardCategoriesItemProvider);
        if (standardCategoriesItemProvider != null) {
            return standardCategoriesItemProvider.getGroupItemProvider(LibraryEditPlugin.INSTANCE.getString("_UI_Tools_group"));
        }
        return null;
    }

    public static String getNextAvailableName(List<MethodElement> list, String string) {
        if (TngUtil.isNameTaken(list, null, string)) {
            int n = 2;
            while (true) {
                String string2;
                if (!TngUtil.isNameTaken(list, null, string2 = String.valueOf(string) + '_' + n)) {
                    return string2;
                }
                ++n;
            }
        }
        return string;
    }

    public static void setDefaultName(List<MethodElement> list, MethodElement methodElement, String string) {
        if (methodElement.getName() != null && methodElement.getName().trim().length() > 0) {
            return;
        }
        if (!TngUtil.isNameTaken(list, methodElement, string)) {
            methodElement.setName(string);
            TngUtil.setPresentationName(methodElement, string);
            return;
        }
        int n = 2;
        while (true) {
            String string2;
            if (!TngUtil.isNameTaken(list, methodElement, string2 = String.valueOf(string) + '_' + n)) {
                methodElement.setName(string2);
                TngUtil.setPresentationName(methodElement, string2);
                return;
            }
            ++n;
        }
    }

    public static void setDefaultName(CustomCategory customCategory, CustomCategory customCategory2, String string) {
        ContentPackage contentPackage;
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)customCategory);
        ContentPackage contentPackage2 = contentPackage = methodPlugin == null ? null : UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (contentPackage == null) {
            TngUtil.setDefaultName(customCategory.getCategorizedElements(), (MethodElement)customCategory2, string);
            return;
        }
        UniqueNameHandler uniqueNameHandler = new UniqueNameHandler();
        uniqueNameHandler.registerNames(contentPackage.getContentElements());
        String string2 = uniqueNameHandler.getUniqueName(string);
        customCategory2.setName(string2);
        customCategory2.setPresentationName(string2);
    }

    private static void setPresentationName(MethodElement methodElement, String string) {
        if (methodElement instanceof DescribableElement) {
            DescribableElement describableElement = (DescribableElement)methodElement;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                stringBuffer.append(String.valueOf(string2.substring(0, 1).toUpperCase()) + string2.substring(1) + " ");
            }
            describableElement.setPresentationName(stringBuffer.toString().trim());
        }
    }

    private static boolean isNameTaken(List<MethodElement> list, MethodElement methodElement, String string) {
        int n = list.size() - 1;
        while (n > -1) {
            MethodElement methodElement2 = list.get(n);
            if (methodElement2 != methodElement && string.equalsIgnoreCase(methodElement2.getName())) {
                return true;
            }
            --n;
        }
        return false;
    }

    public static List extract(Collection collection, Class clazz) {
        ArrayList arrayList = new ArrayList();
        for (Object e : collection) {
            if (!clazz.isInstance(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static void setDefaultName(IDefaultNameSetter iDefaultNameSetter, Notification notification) {
        int n;
        if (iDefaultNameSetter.getInterestedFeatureOwnerClass() != null && (n = notification.getFeatureID(iDefaultNameSetter.getInterestedFeatureOwnerClass())) == iDefaultNameSetter.getInterestedFeatureID()) {
            switch (notification.getEventType()) {
                case 3: {
                    iDefaultNameSetter.setDefaultName(notification.getNewValue());
                    break;
                }
                case 5: {
                    Iterator iterator = ((Collection)notification.getNewValue()).iterator();
                    while (iterator.hasNext()) {
                        iDefaultNameSetter.setDefaultName(iterator.next());
                    }
                    break;
                }
            }
        }
    }

    public static void addExtendedChildren(ContentCategory contentCategory, MethodConfiguration methodConfiguration, Collection collection, String[] stringArray) {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)contentCategory);
        for (MethodPlugin methodPlugin2 : methodConfiguration.getMethodPluginSelection()) {
            ContentCategory contentCategory2;
            ContentPackage contentPackage;
            if (!Misc.isBaseOf(methodPlugin, methodPlugin2) || (contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin2, (String[])stringArray)) == null || !methodConfiguration.getMethodPackageSelection().contains(contentPackage) || (contentCategory2 = TngUtil.findInherited(contentPackage.getContentElements(), contentCategory)) == null) continue;
            ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory().adapt((Notifier)contentCategory2, ITreeItemContentProvider.class);
            if (itemProviderAdapter == null) {
                System.err.println("DisciplineGroupingItemProvider.addExtendedChildren(): could not find adapter for " + contentCategory2);
            }
            for (Object e : itemProviderAdapter.getChildren((Object)contentCategory2)) {
                ContentElement contentElement = null;
                if (e instanceof ContentElement) {
                    contentElement = (ContentElement)e;
                }
                if (contentElement == null || contentElement.getVariabilityBasedOnElement() != null) continue;
                collection.add(e);
            }
            TngUtil.addExtendedChildren(contentCategory2, methodConfiguration, collection, stringArray);
        }
    }

    public static void addAllTo(List list, List list2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!list2.isEmpty()) {
            int n;
            BreakdownElement breakdownElement = (BreakdownElement)list2.remove(0);
            arrayList.clear();
            arrayList.add(breakdownElement);
            BreakdownElement breakdownElement2 = null;
            BreakdownElement breakdownElement3 = breakdownElement.getPresentedAfter();
            while (breakdownElement3 != null) {
                breakdownElement2 = breakdownElement3;
                n = TngUtil.indexOfNextElement(list2, breakdownElement3);
                if (n == -1) break;
                arrayList.add(list2.remove(n));
                breakdownElement3 = breakdownElement3.getPresentedAfter();
            }
            if (breakdownElement2 != null) {
                n = TngUtil.indexOfNextElement(list, breakdownElement2);
                if (n == -1) {
                    list.addAll(arrayList);
                    continue;
                }
                list.addAll(n, arrayList);
                continue;
            }
            list.add(breakdownElement);
        }
    }

    public static void addTo(List list, BreakdownElement breakdownElement, Object object, AdapterFactory adapterFactory) {
        BreakdownElement breakdownElement2 = breakdownElement.getPresentedAfter();
        int n = breakdownElement2 == null ? -1 : TngUtil.indexOfNextElement(list, breakdownElement2);
        if (n == -1) {
            list.add(breakdownElement);
        } else {
            list.add(n, breakdownElement);
        }
    }

    private static int indexOfNextElement(List list, BreakdownElement breakdownElement) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object object = TngUtil.unwrap(list.get(n2));
            if (object == breakdownElement || object instanceof VariabilityElement && ((VariabilityElement)object).getVariabilityBasedOnElement() == breakdownElement) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static List getAvailableBaseProcesses(MethodPlugin methodPlugin, List list) {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        List list2 = Misc.getAllBase(methodPlugin);
        list2.add(0, methodPlugin);
        for (MethodPlugin methodPlugin2 : list2) {
            Collection collection = TngUtil.getRootProcessPackages(methodPlugin2, list);
            for (ProcessPackage processPackage : collection) {
                for (Object e : processPackage.getChildPackages()) {
                    Process process;
                    if (!(e instanceof ProcessComponent) || !TngUtil.isInstanceOf(list, process = ((ProcessComponent)e).getProcess())) continue;
                    arrayList.add(process);
                }
            }
        }
        return arrayList;
    }

    private static String[] getRootProcessPackagePath(Class clazz) {
        if (clazz == DeliveryProcess.class) {
            return ModelStructure.DEFAULT.deliveryProcessPath;
        }
        if (clazz == CapabilityPattern.class) {
            return ModelStructure.DEFAULT.capabilityPatternPath;
        }
        if (clazz == ProcessPlanningTemplate.class) {
            return ModelStructure.DEFAULT.processPlanningTemplatePath;
        }
        return null;
    }

    private static Collection getRootProcessPackages(MethodPlugin methodPlugin, Collection collection) {
        ArrayList<MethodPackage> arrayList = new ArrayList<MethodPackage>();
        for (Class clazz : collection) {
            MethodPackage methodPackage;
            String[] stringArray = TngUtil.getRootProcessPackagePath(clazz);
            if (stringArray == null || !((methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])stringArray)) instanceof ProcessPackage)) continue;
            arrayList.add(methodPackage);
        }
        return arrayList;
    }

    public static boolean hasCategories(MethodPlugin methodPlugin) {
        List<ContentPackage> list = TngUtil.getContentCategoryPackages(methodPlugin);
        for (ContentPackage contentPackage : list) {
            for (Object e : contentPackage.getContentElements()) {
                if (!(e instanceof ContentCategory)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Process> getAllProcesses(MethodPlugin methodPlugin) {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        for (MethodPackage methodPackage : methodPlugin.getMethodPackages()) {
            TngUtil._iteratePackageForProcesses(methodPackage, arrayList);
        }
        return arrayList;
    }

    public static List<Process> getAllProcesses(MethodPackage methodPackage) {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        TngUtil._iteratePackageForProcesses(methodPackage, arrayList);
        return arrayList;
    }

    private static void _iteratePackageForProcesses(MethodPackage methodPackage, List list) {
        Object object;
        if (methodPackage instanceof ProcessComponent && (object = ((ProcessComponent)methodPackage).getProcess()) != null && !list.contains(object)) {
            list.add(object);
        }
        object = methodPackage.getChildPackages().iterator();
        while (object.hasNext()) {
            TngUtil._iteratePackageForProcesses((MethodPackage)object.next(), list);
        }
    }

    public static boolean isSubelementOf(Object object, Object object2, AdapterFactory adapterFactory) {
        if (object == object2) {
            return false;
        }
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
        for (Object e : iTreeItemContentProvider.getChildren(object)) {
            if (e == object2) {
                return true;
            }
            if (!TngUtil.isSubelementOf(e, object2, adapterFactory)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuperElementOf(Object object, Object object2, AdapterFactory adapterFactory) {
        if (object == object2) {
            return false;
        }
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object2, ITreeItemContentProvider.class);
        for (Object e : iTreeItemContentProvider.getChildren(object2)) {
            if (e == object) {
                return true;
            }
            if (!TngUtil.isSuperElementOf(object, e, adapterFactory)) continue;
            return true;
        }
        return false;
    }

    public static Object unwrap(Object object) {
        if (object instanceof IWrapperItemProvider) {
            while ((object = ((IWrapperItemProvider)object).getValue()) instanceof IWrapperItemProvider) {
            }
        } else if (object instanceof CommandWrapper) {
            while ((object = ((CommandWrapper)object).getCommand()) instanceof CommandWrapper) {
            }
        }
        return object;
    }

    public static boolean isWrapped(Object object) {
        return object instanceof IWrapperItemProvider || object instanceof CommandWrapper;
    }

    public static Command unwrap(Command command) {
        while (command instanceof CommandWrapper) {
            command = ((CommandWrapper)command).getCommand();
        }
        return command;
    }

    public static boolean isBase(List list, Object object) {
        for (Object e : list) {
            if (!(e instanceof VariabilityElement) || object != ((VariabilityElement)e).getVariabilityBasedOnElement()) continue;
            return true;
        }
        return false;
    }

    public static String getPresentationName(Object object) {
        if (object instanceof ContentDescription) {
            object = ((ContentDescription)object).eContainer();
        }
        if (object == null) {
            return "";
        }
        String string = null;
        if (object instanceof DescribableElement) {
            string = ((DescribableElement)object).getPresentationName();
        }
        if (object instanceof MethodElement && StrUtil.isBlank((String)string)) {
            string = ((MethodElement)object).getName();
        }
        return string;
    }

    public static Process getOwningProcess(BreakdownElement breakdownElement) {
        EObject eObject = breakdownElement.eContainer();
        while (eObject != null && !(eObject instanceof ProcessComponent)) {
            eObject = eObject.eContainer();
        }
        if (eObject != null) {
            return ((ProcessComponent)eObject).getProcess();
        }
        return null;
    }

    public static Process getOwningProcess(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        Process process;
        Object object = breakdownElementWrapperItemProvider.getTopItem();
        if (object instanceof Process && (process = (Process)object).eContainer() instanceof ProcessComponent) {
            return process;
        }
        return null;
    }

    public static Process getOwningProcess(Object object) {
        if (object instanceof BreakdownElement) {
            return TngUtil.getOwningProcess((BreakdownElement)object);
        }
        if (object instanceof BreakdownElementWrapperItemProvider) {
            return TngUtil.getOwningProcess((BreakdownElementWrapperItemProvider)object);
        }
        return null;
    }

    public static boolean canReference(MethodElement methodElement, MethodElement methodElement2) {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement2);
        MethodPlugin methodPlugin2 = UmaUtil.getMethodPlugin((EObject)methodElement);
        if (methodPlugin2 == methodPlugin) {
            return true;
        }
        return Misc.isBaseOf(methodPlugin, methodPlugin2);
    }

    public static OrderInfo getOrderInfo(MethodElement methodElement, String string) {
        StringResource stringResource;
        block5: {
            String string2 = methodElement.getOrderingGuide();
            if (string2 == null || string2.length() == 0) {
                return null;
            }
            stringResource = new StringResource(string2);
            stringResource.load(null);
            if (!stringResource.getContents().isEmpty()) break block5;
            return null;
        }
        try {
            OrderInfoCollection orderInfoCollection = (OrderInfoCollection)stringResource.getContents().get(0);
            for (OrderInfo orderInfo : orderInfoCollection.getOrderInfos()) {
                if (!string.equalsIgnoreCase(orderInfo.getName())) continue;
                return orderInfo;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static void refreshContributors(IChangeNotifier iChangeNotifier, Notification notification, boolean bl, boolean bl2) {
        Iterator iterator = TngUtil.getContributors((VariabilityElement)notification.getNotifier());
        while (iterator.hasNext()) {
            Object e = iterator.next();
            iChangeNotifier.fireNotifyChanged((Notification)new ViewerNotification(notification, e, bl, bl2));
        }
    }

    public static void refreshPluginExtenders(IChangeNotifier iChangeNotifier, Notification notification, boolean bl, boolean bl2) {
        Object object = notification.getNotifier();
        if (object instanceof MethodPlugin) {
            for (Object e : AssociationHelper.getPluginDirectExtensions((MethodPlugin)((MethodPlugin)object))) {
                iChangeNotifier.fireNotifyChanged((Notification)new ViewerNotification(notification, e, bl, bl2));
            }
        }
    }

    public static boolean hasContributor(VariabilityElement variabilityElement) {
        return TngUtil.hasGeneralizer(variabilityElement, Collections.singleton(VariabilityType.CONTRIBUTES_LITERAL));
    }

    public static boolean hasGeneralizer(VariabilityElement variabilityElement, Collection collection) {
        for (VariabilityElement variabilityElement2 : AssociationHelper.getImmediateVarieties((VariabilityElement)variabilityElement)) {
            if (!collection.contains(variabilityElement2.getVariabilityType())) continue;
            return true;
        }
        return false;
    }

    public static Iterator getImmediateVarieties(VariabilityElement variabilityElement, VariabilityType variabilityType) {
        ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
        List list = AssociationHelper.getImmediateVarieties((VariabilityElement)variabilityElement);
        int n = 0;
        while (n < list.size()) {
            VariabilityElement variabilityElement2 = (VariabilityElement)list.get(n);
            if (variabilityType == variabilityElement2.getVariabilityType()) {
                arrayList.add(variabilityElement2);
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public static Iterator getGeneralizers(VariabilityElement variabilityElement, final VariabilityType variabilityType) {
        return new AbstractTreeIterator(variabilityElement, false){
            private static final long serialVersionUID = 3978145439449298483L;

            protected Iterator getChildren(Object object) {
                ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
                for (VariabilityElement variabilityElement : AssociationHelper.getImmediateVarieties((VariabilityElement)((VariabilityElement)object))) {
                    if (variabilityType != null && variabilityElement.getVariabilityType() != variabilityType) continue;
                    arrayList.add(variabilityElement);
                }
                return arrayList.iterator();
            }
        };
    }

    public static Iterator getGeneralizers(VariabilityElement variabilityElement) {
        return TngUtil.getGeneralizers(variabilityElement, null);
    }

    public static Iterator getContributors(VariabilityElement variabilityElement) {
        return TngUtil.getGeneralizers(variabilityElement, VariabilityType.CONTRIBUTES_LITERAL);
    }

    public static ItemProviderAdapter getAdapter(MethodPlugin methodPlugin, String[] stringArray) {
        IGroupContainer iGroupContainer = (IGroupContainer)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory().adapt((Notifier)methodPlugin, ITreeItemContentProvider.class);
        int n = 0;
        while (n < stringArray.length - 1) {
            if ((iGroupContainer = (IGroupContainer)iGroupContainer.getGroupItemProvider(stringArray[n])) == null) {
                return null;
            }
            ++n;
        }
        return (ItemProviderAdapter)iGroupContainer.getGroupItemProvider(stringArray[n]);
    }

    private static void refreshAdapter(MethodPlugin methodPlugin, String[] stringArray, Notification notification) {
        if (methodPlugin == null) {
            return;
        }
        ItemProviderAdapter itemProviderAdapter = TngUtil.getAdapter(methodPlugin, stringArray);
        if (itemProviderAdapter != null) {
            itemProviderAdapter.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)itemProviderAdapter, true, false));
        }
    }

    public static void refreshAdapter(String[] stringArray, Notification notification) {
        EObject eObject = null;
        switch (notification.getEventType()) {
            case 3: {
                eObject = (EObject)notification.getNewValue();
                break;
            }
            case 5: {
                eObject = (EObject)new ArrayList((Collection)notification.getNewValue()).get(0);
                break;
            }
            case 4: {
                eObject = (EObject)notification.getOldValue();
                break;
            }
            case 6: {
                eObject = (EObject)new ArrayList((Collection)notification.getOldValue()).get(0);
            }
        }
        if (eObject != null) {
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)eObject);
            TngUtil.refreshAdapter(methodPlugin, stringArray, notification);
        }
    }

    public static void refreshUncategorizedTasksItemProvider(MethodPlugin methodPlugin, Notification notification) {
        TngUtil.refreshAdapter(methodPlugin, LibraryEditConstants.UNCATEGORIZED_TASKS_PATH, notification);
    }

    public static void refreshDomainUncategorizedWorkProductsItemProvider(MethodPlugin methodPlugin, Notification notification) {
        TngUtil.refreshAdapter(methodPlugin, LibraryEditConstants.UNCATEGORIZED_DOMAIN_WORKPRODUCTS_PATH, notification);
    }

    public static void refreshWorkProductTypeUncategorized(MethodPlugin methodPlugin, Notification notification) {
        TngUtil.refreshAdapter(methodPlugin, LibraryEditConstants.UNCATEGORIZED_WORKPRODUCTTYPE_WORKPRODUCTS_PATH, notification);
    }

    public static void refreshUncategorizedWorkProductsItemProviders(MethodPlugin methodPlugin, Notification notification) {
        TngUtil.refreshDomainUncategorizedWorkProductsItemProvider(methodPlugin, notification);
        TngUtil.refreshWorkProductTypeUncategorized(methodPlugin, notification);
    }

    public static void refreshUncategorizedRolesItemProvider(MethodPlugin methodPlugin, Notification notification) {
        TngUtil.refreshAdapter(methodPlugin, LibraryEditConstants.UNCATEGORIZED_ROLES_PATH, notification);
    }

    public static void refreshUncategorizedToolMentorsItemProvider(MethodPlugin methodPlugin, Notification notification) {
        TngUtil.refreshAdapter(methodPlugin, LibraryEditConstants.UNCATEGORIZED_TOOLMENTORS_PATH, notification);
    }

    public static Object createWrapper(AdapterFactory adapterFactory, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
            object = new FeatureMapEntryWrapperItemProvider((FeatureMap.Entry)object, eObject, (EAttribute)eStructuralFeature, n, adapterFactory, null);
        } else if (eStructuralFeature instanceof EAttribute) {
            object = new AttributeValueWrapperItemProvider(object, eObject, (EAttribute)eStructuralFeature, n, adapterFactory, null);
        } else if (!((EReference)eStructuralFeature).isContainment()) {
            object = new FeatureValueWrapperItemProvider(eStructuralFeature, object, eObject, adapterFactory);
        }
        return object;
    }

    public static Object getNavigatorParentItemProvider(Guidance guidance) {
        EObject eObject = guidance.eContainer();
        if (!(eObject instanceof ContentPackage)) {
            return null;
        }
        ContentPackageItemProvider contentPackageItemProvider = (ContentPackageItemProvider)TngUtil.getAdapter(eObject, ContentPackageItemProvider.class);
        return contentPackageItemProvider != null ? contentPackageItemProvider.getGuidances() : null;
    }

    public static Object getNavigatorParentItemProvider(WorkProduct workProduct) {
        EObject eObject = workProduct.eContainer();
        if (eObject == null) {
            return null;
        }
        ContentPackageItemProvider contentPackageItemProvider = (ContentPackageItemProvider)TngUtil.getAdapter(eObject, ContentPackageItemProvider.class);
        return contentPackageItemProvider != null ? contentPackageItemProvider.getWorkProducts() : null;
    }

    public static Object getImage(Object object) {
        Object object2 = null;
        try {
            object2 = umaItemProviderAdapterFactory.adapt(object, ITreeItemContentProvider.class);
            if (object2 instanceof IItemLabelProvider) {
                Object object3 = ((IItemLabelProvider)object2).getImage(object);
                return object3;
            }
        }
        finally {
            if (object2 != object && object2 instanceof IDisposable) {
                ((IDisposable)object2).dispose();
            }
        }
        return null;
    }

    public static Object getColumnImage(Object object, String string) {
        if (string == "presentation_name") {
            return TngUtil.getImage(object);
        }
        return null;
    }

    public static void moveUp(Activity activity, Object object, Collection collection, IActionManager iActionManager) {
        MoveUpCommand moveUpCommand = new MoveUpCommand(activity, object, collection);
        iActionManager.execute(moveUpCommand);
    }

    public static void moveDown(Activity activity, Object object, Collection collection, IActionManager iActionManager) {
        MoveDownCommand moveDownCommand = new MoveDownCommand(activity, object, collection);
        iActionManager.execute(moveDownCommand);
    }

    public static CustomCategory createRootCustomCategory(ContentPackage contentPackage) {
        CustomCategory customCategory = UmaFactory.eINSTANCE.createCustomCategory();
        customCategory.setName(LibraryEditPlugin.INSTANCE.getString("_UI_Custom_Categories_group"));
        ContentPackage contentPackage2 = UmaUtil.findContentPackage((List)contentPackage.getChildPackages(), (String)"Hidden");
        if (contentPackage2 == null) {
            contentPackage2 = UmaFactory.eINSTANCE.createContentPackage();
            contentPackage2.setName("Hidden");
            contentPackage.getChildPackages().add(contentPackage2);
        }
        contentPackage2.getContentElements().add(customCategory);
        return customCategory;
    }

    public static CustomCategory getRootCustomCategory(MethodPlugin methodPlugin) {
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (contentPackage == null) {
            return null;
        }
        ContentPackage contentPackage2 = UmaUtil.findContentPackage((List)contentPackage.getChildPackages(), (String)"Hidden");
        if (contentPackage2 != null && !contentPackage2.getContentElements().isEmpty()) {
            return (CustomCategory)contentPackage2.getContentElements().get(0);
        }
        CustomCategory customCategory = TngUtil.createRootCustomCategory(contentPackage);
        for (Object e : contentPackage.getContentElements()) {
            if (!(e instanceof CustomCategory)) continue;
            customCategory.getCategorizedElements().add(e);
        }
        return customCategory;
    }

    public static boolean isRootCustomCategory(CustomCategory customCategory) {
        EObject eObject = customCategory.eContainer();
        return eObject instanceof ContentPackage && "Hidden".equals(((ContentPackage)eObject).getName());
    }

    public static boolean isRootCutomCategoryPackage(MethodPackage methodPackage) {
        return methodPackage instanceof ContentPackage && "Hidden".equals(methodPackage.getName());
    }

    public static void saveContainerResource(EObject eObject, IFileBasedLibraryPersister iFileBasedLibraryPersister) {
        Resource resource;
        if (eObject.eContainer() != null && (resource = eObject.eContainer().eResource()) != null && resource.isModified()) {
            try {
                iFileBasedLibraryPersister.save(resource);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static ContentCategory findContributor(ContentPackage contentPackage, ContentCategory contentCategory) {
        for (ContentCategory contentCategory2 : contentPackage.getContentElements()) {
            if (contentCategory2.getVariabilityBasedOnElement() != contentCategory) continue;
            return contentCategory2;
        }
        return null;
    }

    public static boolean isEmpty(ContentCategory contentCategory) {
        if (!contentCategory.getConceptsAndPapers().isEmpty() || !contentCategory.getSupportingMaterials().isEmpty()) {
            return false;
        }
        if (contentCategory instanceof Discipline) {
            return ((Discipline)contentCategory).getTasks().isEmpty();
        }
        if (contentCategory instanceof Domain) {
            return ((Domain)contentCategory).getWorkProducts().isEmpty();
        }
        if (contentCategory instanceof RoleSet) {
            return ((RoleSet)contentCategory).getRoles().isEmpty();
        }
        if (contentCategory instanceof Tool) {
            return ((Tool)contentCategory).getToolMentors().isEmpty();
        }
        if (contentCategory instanceof WorkProductType) {
            return ((WorkProductType)contentCategory).getWorkProducts().isEmpty();
        }
        if (contentCategory instanceof CustomCategory) {
            CustomCategory customCategory = (CustomCategory)contentCategory;
            return customCategory.getCategorizedElements().isEmpty();
        }
        throw new IllegalArgumentException("Unknown category: " + contentCategory);
    }

    private static void addToPackage(WorkOrder workOrder, BreakdownElement breakdownElement) {
        EObject eObject = breakdownElement.eContainer();
        if (eObject != null) {
            ((ProcessPackage)eObject).getProcessElements().add(workOrder);
        }
    }

    private static void removeFromPackage(WorkOrder workOrder, BreakdownElement breakdownElement) {
        EObject eObject = breakdownElement.eContainer();
        if (eObject instanceof ProcessPackage) {
            ((ProcessPackage)eObject).getProcessElements().remove(workOrder);
        }
    }

    public static boolean handlePredecessorListChange(ItemProviderAdapter itemProviderAdapter, Notification notification) {
        if (notification.getNotifier() instanceof WorkBreakdownElement) {
            switch (notification.getFeatureID(WorkBreakdownElement.class)) {
                case 22: {
                    switch (notification.getEventType()) {
                        case 3: {
                            TngUtil.addToPackage((WorkOrder)notification.getNewValue(), (BreakdownElement)notification.getNotifier());
                            break;
                        }
                        case 5: {
                            Iterator iterator = ((Collection)notification.getNewValue()).iterator();
                            while (iterator.hasNext()) {
                                TngUtil.addToPackage((WorkOrder)iterator.next(), (BreakdownElement)notification.getNotifier());
                            }
                            break;
                        }
                        case 4: {
                            TngUtil.removeFromPackage((WorkOrder)notification.getOldValue(), (BreakdownElement)notification.getNotifier());
                            break;
                        }
                        case 6: {
                            Iterator iterator = ((Collection)notification.getOldValue()).iterator();
                            while (iterator.hasNext()) {
                                TngUtil.removeFromPackage((WorkOrder)iterator.next(), (BreakdownElement)notification.getNotifier());
                            }
                            break;
                        }
                    }
                    itemProviderAdapter.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                    return true;
                }
            }
        }
        return false;
    }

    public static List<ContentPackage> getGlobalPackages(MethodPlugin methodPlugin) {
        ArrayList<ContentPackage> arrayList = new ArrayList<ContentPackage>();
        String[][] stringArray = ModelStructure.DEFAULT.getCategoryPaths();
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])stringArray2);
            if (contentPackage != null) {
                arrayList.add(contentPackage);
            }
            ++n;
        }
        return arrayList;
    }

    public static List<ContentPackage> getContentCategoryPackages(MethodPlugin methodPlugin) {
        return TngUtil.getGlobalPackages(methodPlugin);
    }

    public static List getAllSystemPackages(MethodPlugin methodPlugin) {
        ContentPackage contentPackage;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[][] stringArray = ModelStructure.DEFAULT.getAllSystemPaths();
        int n = 0;
        while (n < stringArray.length) {
            contentPackage = stringArray[n];
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])contentPackage);
            if (methodPackage != null && !arrayList.contains(methodPackage)) {
                arrayList.add(methodPackage);
                EObject eObject = methodPackage.eContainer();
                while (eObject instanceof MethodPackage && !arrayList.contains(eObject)) {
                    arrayList.add(eObject);
                    eObject = eObject.eContainer();
                }
            }
            ++n;
        }
        ContentPackage contentPackage2 = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        if (contentPackage2 != null && (contentPackage = UmaUtil.findContentPackage((List)contentPackage2.getChildPackages(), (String)"Hidden")) != null) {
            arrayList.add(contentPackage);
        }
        return arrayList;
    }

    public static boolean isPredefined(MethodElement methodElement) {
        if (methodElement instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)methodElement)) {
            return true;
        }
        String string = ModelStructure.toFilePath(Misc.getPathRelativeToPlugin((NamedElement)methodElement));
        for (String string2 : ModelStructure.ALL_PREDEFINED_PATHS) {
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static MethodPackage getMethodPackage(EObject eObject) {
        while (!(eObject instanceof MethodPackage) && eObject != null) {
            eObject = eObject.eContainer();
        }
        return (MethodPackage)eObject;
    }

    public static MethodPackage getParentMethodPackage(EObject eObject) {
        EObject eObject2 = eObject;
        while (eObject2 != null) {
            if ((eObject2 = eObject2.eContainer()) == null) {
                return null;
            }
            if (!(eObject2 instanceof MethodPackage)) continue;
            return (MethodPackage)eObject2;
        }
        return null;
    }

    public static void validateMethodConfiguration(IActionManager iActionManager, MethodConfiguration methodConfiguration) {
        List list;
        ArrayList<EObject> arrayList = new ArrayList<EObject>(methodConfiguration.getMethodPluginSelection());
        ArrayList<Object> arrayList2 = new ArrayList<Object>(methodConfiguration.getMethodPackageSelection());
        ArrayList<MethodPlugin> arrayList3 = new ArrayList<MethodPlugin>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        for (Object object : new ArrayList(arrayList2)) {
            EObject eObject = object.eContainer();
            while ((eObject instanceof MethodPackage || eObject instanceof MethodPlugin) && !arrayList2.contains(eObject) && !arrayList.contains(eObject)) {
                if (eObject instanceof MethodPlugin) {
                    arrayList.add(eObject);
                    arrayList3.add((MethodPlugin)eObject);
                } else {
                    arrayList2.add(eObject);
                    arrayList4.add((MethodPackage)eObject);
                }
                eObject = eObject.eContainer();
            }
            if (!(object instanceof ProcessComponent)) continue;
            list = new ArrayList(arrayList2);
            TngUtil.getAllChildPackages((MethodPackage)object, arrayList2);
            arrayList2.removeAll(list);
            arrayList4.addAll(arrayList2);
        }
        ConfigurationUtil.addCollToMethodPluginList(iActionManager, methodConfiguration, arrayList3);
        ConfigurationUtil.addCollToMethodPackageList(iActionManager, methodConfiguration, arrayList4);
        arrayList2 = new ArrayList(methodConfiguration.getMethodPackageSelection());
        ArrayList arrayList5 = new ArrayList();
        for (EObject eObject : arrayList) {
            list = TngUtil.getAllSystemPackages((MethodPlugin)eObject);
            for (Object e : list) {
                if (arrayList2.contains(e) || !(e instanceof MethodPackage)) continue;
                arrayList2.add(e);
                arrayList5.add((MethodPackage)e);
            }
        }
        ConfigurationUtil.addCollToMethodPackageList(iActionManager, methodConfiguration, arrayList5);
    }

    private static void getAllChildPackages(MethodPackage methodPackage, List list) {
        List list2 = methodPackage.getChildPackages();
        for (Object e : list2) {
            if (list.contains(e)) continue;
            list.add(e);
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            TngUtil.getAllChildPackages((MethodPackage)iterator.next(), list);
        }
    }

    public static boolean addTo(MethodConfiguration methodConfiguration, EObject eObject, Set set) {
        MethodPackage methodPackage = TngUtil.getMethodPackage(eObject);
        if (methodPackage != null && !methodConfiguration.getMethodPackageSelection().contains(methodPackage)) {
            methodConfiguration.getMethodPackageSelection().add(methodPackage);
            set.add(methodPackage);
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodPackage);
            if (!methodConfiguration.getMethodPluginSelection().contains(methodPlugin)) {
                methodConfiguration.getMethodPluginSelection().add(methodPlugin);
                set.add(methodPlugin);
                TngUtil.validateMethodConfiguration(null, methodConfiguration);
            }
            return true;
        }
        return false;
    }

    public static boolean addToConfiguration(MethodConfiguration methodConfiguration, EObject eObject, Set set) {
        int n = set.size();
        TngUtil.addTo(methodConfiguration, eObject, set);
        if (eObject instanceof VariabilityElement) {
            VariabilityElement variabilityElement = ((VariabilityElement)eObject).getVariabilityBasedOnElement();
            while (variabilityElement != null) {
                TngUtil.addTo(methodConfiguration, (EObject)variabilityElement, set);
                variabilityElement = variabilityElement.getVariabilityBasedOnElement();
            }
        }
        return set.size() > n;
    }

    public static IStatus checkEdit(EObject eObject, Object object) {
        if (((InternalEObject)eObject).eProxyURI() != null) {
            String string;
            URI uRI;
            EObject eObject2 = eObject;
            String string2 = ((InternalEObject)eObject2).eProxyURI().toString();
            URI uRI2 = uRI = eObject2.eContainer() != null ? eObject2.eContainer().eResource().getURI() : null;
            if (uRI != null) {
                String string3 = string = uRI != null && uRI.isFile() ? uRI.toFileString() : "";
                if (string.length() != 0) {
                    string = MessageFormat.format(" in ''{0}''", string);
                }
            } else {
                string = "";
            }
            String string4 = MessageFormat.format(LibraryEditResources.unresolvedObjectError_reason, eObject2.eClass().getName(), string2, string);
            return new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, string4, null);
        }
        IAccessController iAccessController = Services.getAccessController();
        if (iAccessController == null) {
            return Status.OK_STATUS;
        }
        return iAccessController.checkModify((Collection)Collections.singletonList(eObject), object);
    }

    public static void checkModify(EObject eObject) {
        IStatus iStatus;
        IAccessController iAccessController = Services.getAccessController();
        if (iAccessController != null && !(iStatus = iAccessController.checkModify((Collection)Collections.singletonList(eObject), null)).isOK()) {
            String string = UmaUtil.getMessage((IStatus)iStatus);
            if (string == null) {
                Object object = eObject.eResource().getURI().isFile() ? eObject.eResource().getURI().toFileString() : eObject;
                string = MessageFormat.format(UmaResources.err_cannotModify0, object);
            }
            throw new MessageException(string);
        }
    }

    public static String getMessage(IStatus iStatus) {
        String string = iStatus.getMessage();
        if (iStatus.isMultiStatus()) {
            StringBuffer stringBuffer = new StringBuffer(string);
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                stringBuffer.append('\n').append(iStatusArray[n].getMessage());
                ++n;
            }
            string = stringBuffer.toString();
        }
        if (string == null || string.length() == 0) {
            string = LibraryEditResources.util_tngutil_cannot_edit_resource;
        }
        return string;
    }

    public static boolean isContributor(VariabilityElement variabilityElement) {
        return variabilityElement.getVariabilityBasedOnElement() != null && variabilityElement.getVariabilityType() == VariabilityType.CONTRIBUTES_LITERAL;
    }

    public static boolean isReplacer(VariabilityElement variabilityElement) {
        return variabilityElement.getVariabilityBasedOnElement() != null && variabilityElement.getVariabilityType() == VariabilityType.REPLACES_LITERAL;
    }

    public static boolean isContributorOrReplacer(VariabilityElement variabilityElement) {
        VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
        VariabilityType variabilityType = variabilityElement.getVariabilityType();
        return variabilityElement2 != null && (variabilityType == VariabilityType.CONTRIBUTES_LITERAL || variabilityType == VariabilityType.REPLACES_LITERAL);
    }

    public static boolean isGeneralizer(Object object, Collection collection) {
        if (!(object instanceof VariabilityElement)) {
            return false;
        }
        VariabilityElement variabilityElement = (VariabilityElement)object;
        if (variabilityElement.getVariabilityBasedOnElement() == null) {
            return false;
        }
        if (collection == null) {
            return true;
        }
        return collection.contains(variabilityElement.getVariabilityType());
    }

    public static String getTypeText(String string) {
        try {
            return UmaEditPlugin.INSTANCE.getString("_UI_" + string + "_type");
        }
        catch (MissingResourceException missingResourceException) {
            return UmaEditPlugin.INSTANCE.getString("_UI_Unknown_type");
        }
    }

    public static String getTypeText(EObject eObject) {
        return TngUtil.getTypeText(eObject.eClass());
    }

    public static String getTypeText(EClass eClass) {
        return TngUtil.getTypeText(eClass.getName());
    }

    public static String getFeatureText(Object object) {
        if (object instanceof EStructuralFeature) {
            return TngUtil.getFeatureText((EStructuralFeature)object);
        }
        return "Unknown";
    }

    public static boolean isLocked(EObject eObject) {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)eObject);
        if (methodPlugin == null) {
            return false;
        }
        return methodPlugin.getUserChangeable() == false;
    }

    public static boolean checkExist(Collection collection, Object object) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object2 = TngUtil.unwrap(iterator.next());
            if (object2 != object) continue;
            return true;
        }
        return false;
    }

    public static int getIndexOf(List list, Object object) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object object2 = TngUtil.unwrap(list.get(n2));
            if (object2 == object) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static EStructuralFeature getContainingFeature(Object object, AdapterFactory adapterFactory) {
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider == null) {
            return null;
        }
        Object object2 = iTreeItemContentProvider.getParent(object);
        if (!(object2 instanceof EObject)) {
            return null;
        }
        iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object2, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider instanceof MethodElementItemProvider) {
            EObject eObject = (EObject)object2;
            for (EStructuralFeature eStructuralFeature : ((MethodElementItemProvider)iTreeItemContentProvider).getChildrenFeatures(object2)) {
                if (!(eStructuralFeature.isMany() ? ((Collection)eObject.eGet(eStructuralFeature)).contains(object) : eObject.eGet(eStructuralFeature) == object)) continue;
                return eStructuralFeature;
            }
        }
        return null;
    }

    public static String getFeatureText(EStructuralFeature eStructuralFeature) {
        String string;
        switch (eStructuralFeature.getFeatureID()) {
            case 26: {
                return LibraryEditResources.assists_text;
            }
        }
        if (eStructuralFeature instanceof EStructuralFeature) {
            EStructuralFeature eStructuralFeature2 = eStructuralFeature;
            string = String.valueOf(eStructuralFeature2.getEContainingClass().getName()) + "_" + eStructuralFeature2.getName();
        } else {
            string = LibraryEditResources.unknown_text;
        }
        return UmaEditPlugin.INSTANCE.getString("_UI_" + string + "_feature");
    }

    public static File getLibraryRootPath(EObject eObject) {
        EObject eObject2 = eObject;
        while (eObject2 != null && !(eObject2 instanceof MethodLibrary)) {
            eObject2 = eObject2.eContainer();
        }
        if (eObject2 != null && eObject2.eResource() != null) {
            URI uRI = eObject2.eResource().getURI();
            String string = uRI.toFileString();
            File file = new File(string);
            return file.getParentFile();
        }
        return null;
    }

    public static java.net.URI getFullPathURI(EObject eObject, java.net.URI uRI) {
        Serializable serializable;
        if (uRI == null) {
            return uRI;
        }
        try {
            serializable = uRI.toURL();
            if (serializable != null) {
                return uRI;
            }
        }
        catch (Exception exception) {}
        serializable = TngUtil.getLibraryRootPath(eObject);
        if (serializable != null) {
            return new File((File)serializable, NetUtil.decodedFileUrl((String)uRI.toString())).toURI();
        }
        return uRI;
    }

    public static java.net.URI getFullPathofNodeorShapeIconURI(EObject eObject, java.net.URI uRI) {
        Serializable serializable;
        if (uRI == null) {
            return uRI;
        }
        try {
            serializable = uRI.toURL();
            if (serializable != null) {
                return uRI;
            }
        }
        catch (Exception exception) {}
        serializable = TngUtil.getLibraryRootPath(eObject);
        String string = uRI.getPath();
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)eObject);
        if (methodPlugin != null && UmaUtil.hasDirectResource((EObject)methodPlugin)) {
            File file = new File(methodPlugin.eResource().getURI().toFileString()).getParentFile();
            if (string.indexOf(methodPlugin.getName()) > -1) {
                return new File((File)serializable, NetUtil.decodedFileUrl((String)uRI.toString())).toURI();
            }
            return new File(file, NetUtil.decodedFileUrl((String)uRI.toString())).toURI();
        }
        return null;
    }

    public static String toStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String getLabelWithPath(Object object) {
        if (object instanceof BreakdownElement) {
            return ProcessUtil.getLabelWithPath((BreakdownElement)object);
        }
        if (object instanceof ContentDescription) {
            return TngUtil.getLabelWithPath(((ContentDescription)object).eContainer());
        }
        if (object instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)object;
            Collection<NamedElement> collection = Misc.getObjectTreeRelativeToPlugin((NamedElement)methodElement);
            StringBuffer stringBuffer = new StringBuffer(TngUtil.getLabel(object, methodElement.getGuid()));
            if (MethodElementUtil.getMethodModel(object) != null) {
                stringBuffer.append(", ").append(MethodElementUtil.getMethodModel(object).getName());
                for (NamedElement namedElement : collection) {
                    String string = String.valueOf(namedElement.getName());
                    if ("CoreContent".equals(string) || "Content".equalsIgnoreCase(string) || ((NamedElement)object).equals(namedElement)) continue;
                    stringBuffer.append('/').append(string);
                }
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static EObject getOwner(Command command) {
        Object object;
        command = TngUtil.unwrap(command);
        EObject eObject = null;
        if (command instanceof AddCommand) {
            eObject = ((AddCommand)command).getOwner();
        } else if (command instanceof RemoveCommand) {
            eObject = ((RemoveCommand)command).getOwner();
        } else if (command instanceof SetCommand) {
            eObject = ((SetCommand)command).getOwner();
        } else if (command instanceof MoveCommand) {
            eObject = ((MoveCommand)command).getOwner();
        } else if (command instanceof PasteFromClipboardCommand && (object = ((PasteFromClipboardCommand)command).getOwner()) instanceof EObject) {
            eObject = (EObject)object;
        }
        return eObject;
    }

    public static Set<Resource> getModifiedResources(Command command) {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        TngUtil.collectModifiedResources(command, hashSet);
        return hashSet;
    }

    public static void collectModifiedResources(Command command, Set<Resource> set) {
        if (command instanceof IResourceAwareCommand) {
            set.addAll(((IResourceAwareCommand)command).getModifiedResources());
        } else if (command instanceof CompoundCommand) {
            List list = ((CompoundCommand)command).getCommandList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TngUtil.collectModifiedResources((Command)iterator.next(), set);
            }
        } else {
            Resource resource;
            EObject eObject = TngUtil.getOwner(command);
            if (eObject != null && (resource = eObject.eResource()) != null) {
                set.add(resource);
            }
        }
    }

    public static List convertGuidanceAttachmentsToList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            string = "";
        }
        String[] stringArray = string.split(GUIDANCE_FILESTRING_SEPARATOR_SPLITTER);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].trim().length() > 0) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    public static String convertGuidanceAttachmentsToString(List list) {
        String string = "";
        int n = 0;
        for (String string2 : list) {
            if (n++ > 0) {
                string = string.concat(GUIDANCE_FILESTRING_SEPARATOR);
            }
            string = string.concat(string2);
        }
        return string;
    }

    public static boolean isAllowedAttachments(MethodElement methodElement) {
        if (methodElement == null) {
            return false;
        }
        if (methodElement instanceof Example) {
            return true;
        }
        if (methodElement instanceof ReusableAsset) {
            return true;
        }
        if (methodElement instanceof Template) {
            return true;
        }
        return methodElement instanceof Whitepaper;
    }

    public static boolean contains(Collection collection, Object object) {
        for (Object e : collection) {
            if (e != object && object != TngUtil.unwrap(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncessorOf(CustomCategory customCategory, DescribableElement describableElement) {
        return DependencyChecker.isAncessorOf(customCategory, describableElement);
    }

    public static void refreshParentIfNameChanged(Notification notification, ItemProviderAdapter itemProviderAdapter) {
        block8: {
            block7: {
                if (!(notification.getNotifier() instanceof ContentElement)) break block7;
                switch (notification.getFeatureID(DescribableElement.class)) {
                    case 0: {
                        if (PresentationContext.INSTANCE.isShowPresentationNames()) {
                            return;
                        }
                        break block8;
                    }
                    case 7: {
                        if (!PresentationContext.INSTANCE.isShowPresentationNames()) {
                            return;
                        }
                        break block8;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (notification.getFeatureID(NamedElement.class) != 0) {
                return;
            }
        }
        itemProviderAdapter.fireNotifyChanged((Notification)new ViewerNotification(notification, itemProviderAdapter.getParent(notification.getNotifier()), true, false));
    }

    public static boolean isContributorOf(Object object, VariabilityElement variabilityElement) {
        VariabilityElement variabilityElement2 = variabilityElement;
        while (variabilityElement2 != null && variabilityElement2.getVariabilityType() == VariabilityType.CONTRIBUTES_LITERAL && variabilityElement2.getVariabilityBasedOnElement() != null) {
            if (variabilityElement2.getVariabilityBasedOnElement() == object) {
                return true;
            }
            variabilityElement2 = variabilityElement2.getVariabilityBasedOnElement();
        }
        return false;
    }

    public static void getConfigurationsToUpdate(MethodPackage methodPackage, MethodPackage methodPackage2, Collection collection) {
        Object object = ((MultiResourceEObject)methodPackage).getOppositeFeatureValue(AssociationHelper.MethodPackage_MethodConfigurations);
        if (object instanceof List) {
            for (MethodConfiguration methodConfiguration : (List)object) {
                List list = methodConfiguration.getMethodPackageSelection();
                if (list.contains(methodPackage2)) continue;
                collection.add(methodConfiguration);
            }
        }
    }

    public static boolean canEstimate(Object object) {
        return object instanceof Task || object instanceof WorkBreakdownElement;
    }

    public static void debugShowAll() {
        ILibraryInspector iLibraryInspector = TngUtil.getLibraryInspector();
        if (iLibraryInspector != null) {
            iLibraryInspector.showAllContents();
        }
    }

    public static void debugShowAll(MethodLibrary methodLibrary) {
        ILibraryInspector iLibraryInspector = TngUtil.getLibraryInspector();
        if (iLibraryInspector != null) {
            iLibraryInspector.showAllContents(methodLibrary);
        }
    }

    public static ILibraryInspector getLibraryInspector() {
        return (ILibraryInspector)ExtensionManager.getExtension("org.eclipse.epf.library.edit", "libraryInspector");
    }

    public static boolean isInPluginWithLessThanOneSuperCustomCategory(CustomCategory customCategory, MethodPlugin methodPlugin) {
        if (UmaUtil.getMethodPlugin((EObject)customCategory) != methodPlugin) {
            return false;
        }
        List list = AssociationHelper.getCustomCategories((DescribableElement)customCategory);
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && n < 2) {
            CustomCategory customCategory2 = (CustomCategory)iterator.next();
            if (UmaUtil.getMethodPlugin((EObject)customCategory2) != methodPlugin) continue;
            ++n;
        }
        return n < 2;
    }

    public static boolean isUnderCustomCategoryTree(IWrapperItemProvider iWrapperItemProvider) {
        Object object;
        do {
            if (!(TngUtil.unwrap(object = iWrapperItemProvider.getOwner()) instanceof CustomCategory)) continue;
            return true;
        } while ((iWrapperItemProvider = object instanceof IWrapperItemProvider ? (IWrapperItemProvider)object : null) != null);
        return false;
    }

    public static Collection getExclusiveSubCustomCategories(CustomCategory customCategory) {
        ArrayList arrayList = new ArrayList();
        TngUtil.collectExclusiveSubCustomCategories(arrayList, customCategory, UmaUtil.getMethodPlugin((EObject)customCategory));
        return arrayList;
    }

    private static void collectExclusiveSubCustomCategories(Collection collection, CustomCategory customCategory, MethodPlugin methodPlugin) {
        for (Object e : customCategory.getCategorizedElements()) {
            CustomCategory customCategory2;
            if (!(e instanceof CustomCategory) || !TngUtil.isInPluginWithLessThanOneSuperCustomCategory(customCategory2 = (CustomCategory)e, methodPlugin)) continue;
            collection.add(e);
            TngUtil.collectExclusiveSubCustomCategories(collection, customCategory2, methodPlugin);
        }
    }

    public static Object getAdapterByType(Notifier notifier, Object object) {
        for (Adapter adapter : notifier.eAdapters()) {
            if (!adapter.isAdapterForType(object)) continue;
            return adapter;
        }
        return null;
    }

    public static Map removeReferences(MethodElement methodElement) {
        return TngUtil.removeReferences(methodElement, false);
    }

    public static Map removeReferences(MethodElement methodElement, boolean bl) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        MultiResourceEObject multiResourceEObject = (MultiResourceEObject)methodElement;
        if (multiResourceEObject.basicGetOppositeFeatureMap() == null) {
            return hashMap;
        }
        for (Map.Entry entry : multiResourceEObject.getOppositeFeatureMap().entrySet()) {
            Object object;
            ArrayList<EStructuralFeature> arrayList;
            Object object22;
            OppositeFeature oppositeFeature = (OppositeFeature)entry.getKey();
            EStructuralFeature eStructuralFeature = oppositeFeature.getTargetFeature();
            if (eStructuralFeature.isMany()) {
                if (oppositeFeature.isMany()) {
                    for (Object object22 : new ArrayList((Collection)multiResourceEObject.getOppositeFeatureValue(oppositeFeature))) {
                        if (bl) {
                            TngUtil.checkModify((EObject)object22);
                        }
                        ((List)object22.eGet(eStructuralFeature)).remove(methodElement);
                        arrayList = (List)hashMap.get(object22);
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            hashMap.put(object22, arrayList);
                        }
                        arrayList.add(eStructuralFeature);
                    }
                    continue;
                }
                object = (EObject)multiResourceEObject.getOppositeFeatureValue(oppositeFeature);
                if (object == null) continue;
                if (bl) {
                    TngUtil.checkModify((EObject)object);
                }
                ((List)object.eGet(eStructuralFeature)).remove(methodElement);
                object22 = (List)hashMap.get(object);
                if (object22 == null) {
                    object22 = new ArrayList();
                    hashMap.put(object, object22);
                }
                object22.add(eStructuralFeature);
                continue;
            }
            if (oppositeFeature.isMany()) {
                for (Object object22 : new ArrayList((Collection)multiResourceEObject.getOppositeFeatureValue(oppositeFeature))) {
                    if (bl) {
                        TngUtil.checkModify((EObject)object22);
                    }
                    object22.eSet(eStructuralFeature, null);
                    arrayList = (ArrayList<EStructuralFeature>)hashMap.get(object22);
                    if (arrayList == null) {
                        arrayList = new ArrayList<EStructuralFeature>();
                        hashMap.put(object22, arrayList);
                    }
                    arrayList.add(eStructuralFeature);
                }
                continue;
            }
            object = (EObject)multiResourceEObject.getOppositeFeatureValue(oppositeFeature);
            if (object == null) continue;
            if (bl) {
                TngUtil.checkModify((EObject)object);
            }
            object.eSet(eStructuralFeature, null);
            object22 = (List)hashMap.get(object);
            if (object22 == null) {
                object22 = new ArrayList();
                hashMap.put(object, object22);
            }
            object22.add(eStructuralFeature);
        }
        return hashMap;
    }

    public static MethodElementProperty getPublishCategoryProperty(MethodElement methodElement) {
        List list = methodElement.getMethodElementProperty();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (MethodElementProperty methodElementProperty : list) {
            if (!PUBLISH_CATEGORY_PROPERTY.equals(methodElementProperty.getName())) continue;
            return methodElementProperty;
        }
        return null;
    }

    public static List getNotifyChangedListeners(AdapterFactory adapterFactory, Object object) {
        if (object instanceof CustomCategory) {
            CustomCategoryItemProvider customCategoryItemProvider = (CustomCategoryItemProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
            return customCategoryItemProvider.getNotifyChangedListeners();
        }
        if (object instanceof RoleSet) {
            RoleSetItemProvider roleSetItemProvider = (RoleSetItemProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
            return roleSetItemProvider.getNotifyChangedListeners();
        }
        if (object instanceof Discipline) {
            DisciplineItemProvider disciplineItemProvider = (DisciplineItemProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
            return disciplineItemProvider.getNotifyChangedListeners();
        }
        return Collections.EMPTY_LIST;
    }

    public static FeatureValueWrapperItemProvider getWrapper(Collection collection, Object object) {
        if (collection == null) {
            return null;
        }
        for (Object e : collection) {
            if (!(e instanceof FeatureValueWrapperItemProvider) || TngUtil.unwrap(e) != object) continue;
            return (FeatureValueWrapperItemProvider)e;
        }
        return null;
    }
}

