/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.utils.ProfilingUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.PluginDepInfo;
import org.eclipse.epf.library.edit.validation.Tracer;
import org.eclipse.epf.library.edit.validation.ValidationStatus;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;

public class PluginDependencyInfoMgr {
    private static boolean profiling = false;
    private static boolean debug = false;
    private MethodLibrary lib;
    private Map processed;
    private List circularList;

    public PluginDependencyInfoMgr(MethodLibrary methodLibrary) {
        this.lib = methodLibrary;
    }

    public void logCircularDependency(Stack stack) {
        if (this.circularList == null) {
            this.circularList = new ArrayList();
        }
        this.circularList.addAll(stack);
    }

    private List getAndClearCircularList() {
        List list = this.circularList;
        this.circularList = null;
        return list;
    }

    private void log(String string) {
        LibraryEditPlugin.INSTANCE.log(string);
    }

    private PluginDepInfo registerPlugin(MethodPlugin methodPlugin, boolean bl) {
        PluginDepInfo pluginDepInfo = this.getProcessedInfo(methodPlugin);
        if (pluginDepInfo == null) {
            pluginDepInfo = new PluginDepInfo(this, methodPlugin);
        }
        if (!pluginDepInfo.isComplete()) {
            pluginDepInfo.build(bl);
        }
        return pluginDepInfo;
    }

    public IStatus checkCircularDependnecy(MethodPlugin methodPlugin) {
        boolean bl;
        if (debug) {
            System.out.println("LD> plugin: " + TngUtil.getLabelWithPath(methodPlugin));
        }
        this.registerPlugin(methodPlugin, true);
        List list = this.getAndClearCircularList();
        boolean bl2 = bl = list != null && !list.isEmpty();
        if (bl) {
            this.log("Error> Circular dependency detected: ");
            int n = 0;
            while (n < list.size()) {
                PluginDepInfo pluginDepInfo = (PluginDepInfo)list.get(n);
                MethodPlugin methodPlugin2 = pluginDepInfo.getPlugin();
                this.log("Error> " + n + ": " + TngUtil.getLabelWithPath(methodPlugin2));
                ++n;
            }
            this.log("");
            return new ValidationStatus(4, 0, this.genErrorMsg(list), methodPlugin, null);
        }
        return Status.OK_STATUS;
    }

    private String genErrorMsg(List list) {
        String string = LibraryEditResources.variability_element_circular_loop_error_msg;
        int n = 0;
        while (n < list.size()) {
            PluginDepInfo pluginDepInfo = (PluginDepInfo)list.get(n);
            MethodPlugin methodPlugin = pluginDepInfo.getPlugin();
            if (n > 0) {
                string = String.valueOf(string) + ": ";
            }
            string = String.valueOf(string) + TngUtil.getLabelWithPath(methodPlugin);
            ++n;
        }
        return string;
    }

    protected boolean processed(MethodPlugin methodPlugin) {
        return this.processed != null && this.processed.containsKey(methodPlugin.getGuid());
    }

    protected PluginDepInfo getProcessedInfo(MethodPlugin methodPlugin) {
        return this.processed == null ? null : (PluginDepInfo)this.processed.get(methodPlugin.getGuid());
    }

    protected void addToProcessed(PluginDepInfo pluginDepInfo) {
        if (this.processed == null) {
            this.processed = new HashMap();
        }
        this.processed.put(pluginDepInfo.getPlugin().getGuid(), pluginDepInfo);
    }

    public CheckResult checkCircularDependnecy(Tracer tracer, boolean bl) {
        Object object;
        if (tracer == null) {
            tracer = new Tracer(){

                public void trace(String string) {
                }
            };
        }
        long l = 0L;
        Runtime runtime = Runtime.getRuntime();
        if (profiling) {
            object = this.lib.eAllContents();
            while (object.hasNext()) {
                object.next();
            }
            ProfilingUtil.fullGC();
            l = runtime.totalMemory() - runtime.freeMemory();
        }
        object = this.checkCircularDependnecy_(tracer, bl);
        if (profiling) {
            ProfilingUtil.fullGC();
            System.out.println("LD> usedMem0: " + l / 1000L + " k bytes");
            long l2 = runtime.totalMemory() - runtime.freeMemory();
            System.out.println("LD> usedMem1: " + l2 / 1000L + " k bytes");
            System.out.println("LD> diffMem: " + (l2 - l) / 1000L + " k bytes");
        }
        return object;
    }

    private CheckResult checkCircularDependnecy_(Tracer tracer, boolean bl) {
        CheckResult checkResult = new CheckResult();
        List list = this.lib.getMethodPlugins();
        for (MethodPlugin methodPlugin : list) {
            boolean bl2;
            this.registerPlugin(methodPlugin, true);
            List list2 = this.getAndClearCircularList();
            boolean bl3 = bl2 = list2 != null && !list2.isEmpty();
            if (!bl2) continue;
            tracer.trace("Error> Circular dependency detected: ");
            int n = 0;
            while (n < list2.size()) {
                PluginDepInfo pluginDepInfo = (PluginDepInfo)list2.get(n);
                MethodPlugin methodPlugin2 = pluginDepInfo.getPlugin();
                tracer.trace("Error> " + n + ": " + TngUtil.getLabelWithPath(methodPlugin2));
                ++n;
            }
            checkResult.circularList.add(list2);
            if (bl) continue;
            return checkResult;
        }
        return checkResult;
    }

    public static class CheckResult {
        public List circularList = new ArrayList();

        public int getErrorCount() {
            return this.circularList.size();
        }
    }
}

