/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.osgi.util.NLS;

public class UniquenessValidator
implements IValidator {
    protected EObject object;
    private EStructuralFeature feature;
    private String featureName;
    private EStructuralFeature containingFeature;
    private IFilter childFilter;
    protected EObject container;

    public UniquenessValidator(EObject eObject, EStructuralFeature eStructuralFeature, IFilter iFilter, EObject eObject2, EStructuralFeature eStructuralFeature2) {
        this(eObject, eStructuralFeature, iFilter, eObject2, eStructuralFeature2, StrUtil.toLower((String)TngUtil.getFeatureText(eStructuralFeature2)));
    }

    public UniquenessValidator(EObject eObject, EStructuralFeature eStructuralFeature, IFilter iFilter, EObject eObject2, EStructuralFeature eStructuralFeature2, String string) {
        this.container = eObject;
        this.object = eObject2;
        this.containingFeature = eStructuralFeature;
        this.childFilter = iFilter;
        this.feature = eStructuralFeature2;
        this.featureName = string;
    }

    void setChildFilter(IFilter iFilter) {
        this.childFilter = iFilter;
    }

    public String isValid(String string) {
        if (this.container == null) {
            return null;
        }
        if (StrUtil.isBlank((String)(string = string.trim()))) {
            return NLS.bind((String)LibraryEditResources.emptyElementNameError_msg, (Object)this.featureName);
        }
        Object object = this.containingFeature == null ? this.container.eContents() : (Collection)this.container.eGet(this.containingFeature);
        for (Object e : object) {
            String string2;
            if (e == this.object || !this.childFilter.accept(e) || !(string2 = (String)((EObject)e).eGet(this.feature)).equalsIgnoreCase(string)) continue;
            return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)string);
        }
        return null;
    }

    public IStatus isValid(Object object) {
        if (this.container == null) {
            return Status.OK_STATUS;
        }
        Object object2 = this.containingFeature == null ? this.container.eContents() : (Collection)this.container.eGet(this.containingFeature);
        for (Object e : object2) {
            String string;
            if (e == this.object || !this.childFilter.accept(e) || !(string = (String)((EObject)e).eGet(this.feature)).equals(object)) continue;
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, NLS.bind((String)LibraryEditResources.duplicateFeatureValue, (Object[])new Object[]{TngUtil.getLabel(this.container), this.featureName}), null);
        }
        return Status.OK_STATUS;
    }

    public EObject getEObject() {
        return this.object;
    }
}

