/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.AbstractStringValidator;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.DoNothingValidator;
import org.eclipse.epf.library.edit.validation.internal.MethodConfigurationNameValidator;
import org.eclipse.epf.library.edit.validation.internal.MethodPluginNameValidator;
import org.eclipse.epf.library.edit.validation.internal.ProcessComponentNameValidator;
import org.eclipse.epf.library.edit.validation.internal.UniquenessValidator;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.osgi.framework.Bundle;

public class ValidatorFactory
implements IValidatorFactory {
    private static List contributedValidatorFactories;
    private static IValidatorFactory instance;
    public static final IFilter nonFilter;

    static {
        nonFilter = new IFilter(){

            public boolean accept(Object object) {
                return true;
            }
        };
    }

    public IValidator createNameValidator(Object object, ContentElement contentElement) {
        if (object instanceof CustomCategory && contentElement instanceof CustomCategory) {
            return new ContentElementNameValidator((EObject)object, (EStructuralFeature)UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements(), contentElement, new TypeFilter((EObject)contentElement));
        }
        EObject eObject = null;
        if (object instanceof EObject) {
            eObject = (EObject)object;
        }
        return new ContentElementNameValidator(eObject, contentElement, new TypeFilter((EObject)contentElement));
    }

    public IValidator createPresentationNameValidator(Object object, DescribableElement describableElement) {
        if (object instanceof EObject) {
            Object[] objectArray = ValidatorFactory.getChildReferenceAndFilter(object, describableElement);
            EReference eReference = (EReference)objectArray[0];
            IFilter iFilter = (IFilter)objectArray[1];
            if (eReference != null) {
                if (iFilter == null) {
                    iFilter = new TypeFilter((EObject)describableElement);
                }
                return new UniquenessValidator((EObject)object, (EStructuralFeature)eReference, iFilter, (EObject)describableElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName()){

                    public String isValid(String string) {
                        if (StrUtil.isBlank((String)string) && NameChecker.canHaveEmptyPresentationName((DescribableElement)this.object)) {
                            return null;
                        }
                        return super.isValid(string);
                    }
                };
            }
        }
        return DoNothingValidator.INSTANCE;
    }

    private static Object[] getChildReferenceAndFilter(Object object, Object object2) {
        EReference eReference = null;
        IFilter iFilter = null;
        if (object2 instanceof ContentElement) {
            if (object instanceof CustomCategory && object2 instanceof CustomCategory) {
                eReference = UmaPackage.Literals.CUSTOM_CATEGORY__CATEGORIZED_ELEMENTS;
                iFilter = new TypeFilter(UmaPackage.Literals.CUSTOM_CATEGORY);
            } else if (object instanceof ContentPackage) {
                eReference = UmaPackage.Literals.CONTENT_PACKAGE__CONTENT_ELEMENTS;
            }
        } else if (object2 instanceof MethodPackage && object instanceof MethodPackage) {
            eReference = UmaPackage.Literals.METHOD_PACKAGE__CHILD_PACKAGES;
        } else if (object instanceof MethodLibrary) {
            if (object2 instanceof MethodPlugin) {
                eReference = UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS;
                iFilter = nonFilter;
            } else if (object2 instanceof MethodConfiguration) {
                eReference = UmaPackage.Literals.METHOD_LIBRARY__PREDEFINED_CONFIGURATIONS;
                iFilter = nonFilter;
            }
        }
        return new Object[]{eReference, iFilter};
    }

    public IValidator createNameValidator(Object object, NamedElement namedElement) {
        EAttribute eAttribute = UmaPackage.Literals.NAMED_ELEMENT__NAME;
        Object[] objectArray = ValidatorFactory.getChildReferenceAndFilter(object, namedElement);
        EReference eReference = (EReference)objectArray[0];
        IFilter iFilter = (IFilter)objectArray[1];
        if (eReference != null) {
            return this.createValidator((EObject)object, eReference, iFilter, (EObject)namedElement, (EStructuralFeature)eAttribute);
        }
        if (namedElement instanceof MethodConfiguration && object instanceof MethodLibrary) {
            return new MethodConfigurationNameValidator((MethodLibrary)object, (MethodConfiguration)namedElement);
        }
        return DoNothingValidator.INSTANCE;
    }

    public IValidator createNameValidator(Object object, NamedElement namedElement, EClass eClass) {
        EAttribute eAttribute = UmaPackage.Literals.NAMED_ELEMENT__NAME;
        Object[] objectArray = ValidatorFactory.getChildReferenceAndFilter(object, namedElement);
        EReference eReference = (EReference)objectArray[0];
        TypeFilter typeFilter = new TypeFilter(eClass);
        if (eReference != null) {
            return this.createValidator((EObject)object, eReference, typeFilter, (EObject)namedElement, (EStructuralFeature)eAttribute);
        }
        return DoNothingValidator.INSTANCE;
    }

    public IValidator createNameValidator(NamedElement namedElement, AdapterFactory adapterFactory) {
        EStructuralFeature eStructuralFeature = TngUtil.getContainingFeature(namedElement, adapterFactory);
        if (eStructuralFeature != null) {
            EObject eObject = (EObject)((ITreeItemContentProvider)adapterFactory.adapt((Notifier)namedElement, ITreeItemContentProvider.class)).getParent((Object)namedElement);
            if (namedElement instanceof ContentElement) {
                return new ContentElementNameValidator(eObject, eStructuralFeature, (ContentElement)namedElement, new TypeFilter((EObject)namedElement));
            }
            if (namedElement instanceof ProcessComponent && eObject instanceof ProcessPackage) {
                return new ProcessComponentNameValidator((ProcessPackage)eObject, (ProcessComponent)namedElement);
            }
            if (namedElement instanceof MethodPlugin && eObject instanceof MethodLibrary) {
                return new MethodPluginNameValidator((MethodLibrary)eObject, (MethodPlugin)namedElement);
            }
            if (namedElement instanceof MethodConfiguration && eObject instanceof MethodLibrary) {
                return new MethodConfigurationNameValidator((MethodLibrary)eObject, (MethodConfiguration)namedElement);
            }
            return new UniquenessValidator(eObject, eStructuralFeature, new TypeFilter((EObject)namedElement), (EObject)namedElement, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
        }
        return this.createNameValidator((Object)namedElement.eContainer(), namedElement);
    }

    public IValidator createValidator(EObject eObject, EReference eReference, EClass eClass, EObject eObject2, EStructuralFeature eStructuralFeature) {
        TypeFilter typeFilter = eClass != null ? new TypeFilter(eClass) : null;
        return this.createValidator(eObject, eReference, typeFilter, eObject2, eStructuralFeature);
    }

    public static IValidatorFactory createValidatorFactory() {
        if (contributedValidatorFactories != null) {
            contributedValidatorFactories = new ArrayList();
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(LibraryEditPlugin.getDefault().getId(), "validationSupport");
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IExtension iExtension = iExtensionArray[n];
                    String string = iExtension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)string);
                    IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        try {
                            String string2 = iConfigurationElement.getAttribute("class");
                            if (string2 != null) {
                                Object t = bundle.loadClass(string2).newInstance();
                                boolean bl = new Boolean(iConfigurationElement.getAttribute("replace"));
                                if (bl) {
                                    contributedValidatorFactories.clear();
                                    instance = (IValidatorFactory)t;
                                } else if (instance == null) {
                                    contributedValidatorFactories.add(t);
                                }
                            }
                        }
                        catch (Exception exception) {
                            LibraryEditPlugin.INSTANCE.log(exception);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        if (instance == null) {
            instance = new ValidatorFactory();
        }
        return instance;
    }

    public IValidator createValidator(final Object object, EClass eClass, EObject eObject, final EStructuralFeature eStructuralFeature, final AdapterFactory adapterFactory) {
        if (eObject instanceof BreakdownElement && (eStructuralFeature == UmaPackage.Literals.NAMED_ELEMENT__NAME || eStructuralFeature == UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION_NAME)) {
            final BreakdownElement breakdownElement = (BreakdownElement)eObject;
            Process process = TngUtil.getOwningProcess(object);
            if (process != null) {
                final Suppression suppression = Suppression.getSuppression(process);
                return new AbstractStringValidator(){

                    public String isValid(String string) {
                        return NameChecker.checkName(adapterFactory, object, breakdownElement, null, eStructuralFeature, string, suppression, true);
                    }
                };
            }
        }
        return DoNothingValidator.INSTANCE;
    }

    private static IFilter getFilter(IFilter iFilter, EObject eObject) {
        return iFilter != null ? iFilter : (eObject != null ? new TypeFilter(eObject) : nonFilter);
    }

    public IValidator createValidator(EObject eObject, EReference eReference, IFilter iFilter, EObject eObject2, EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature == UmaPackage.Literals.NAMED_ELEMENT__NAME) {
            UniquenessValidator uniquenessValidator = null;
            if (eObject2 instanceof ContentElement) {
                if (eReference == UmaPackage.eINSTANCE.getContentPackage_ContentElements() || eReference == UmaPackage.Literals.CUSTOM_CATEGORY__CATEGORIZED_ELEMENTS && eObject2 instanceof CustomCategory) {
                    uniquenessValidator = new ContentElementNameValidator(eObject, (EStructuralFeature)eReference, (ContentElement)eObject2, ValidatorFactory.getFilter(iFilter, eObject2));
                } else if (eReference == UmaPackage.Literals.DISCIPLINE_GROUPING__DISCIPLINES || eReference == UmaPackage.Literals.ROLE_SET_GROUPING__ROLE_SETS) {
                    uniquenessValidator = new UniquenessValidator(eObject.eContainer(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentPackage_ContentElements(), ValidatorFactory.getFilter(iFilter, eObject2), eObject2, eStructuralFeature);
                } else if (eReference == UmaPackage.Literals.ARTIFACT__CONTAINED_ARTIFACTS || eReference == UmaPackage.Literals.DISCIPLINE__SUBDISCIPLINE || eReference == UmaPackage.Literals.PRACTICE__SUB_PRACTICES || eReference == UmaPackage.Literals.DOMAIN__SUBDOMAINS) {
                    uniquenessValidator = new ContentElementNameValidator(eObject, (EStructuralFeature)eReference, (ContentElement)eObject2, ValidatorFactory.getFilter(iFilter, eObject2));
                }
            } else {
                if (eObject2 instanceof ProcessComponent && eObject instanceof ProcessPackage && eReference == UmaPackage.eINSTANCE.getMethodPackage_ChildPackages()) {
                    ProcessPackage processPackage = (ProcessPackage)eObject;
                    if (processPackage.eResource().getURI().isFile()) {
                        return new ProcessComponentNameValidator((ProcessPackage)eObject, (ProcessComponent)eObject2);
                    }
                    return new UniquenessValidator(eObject, (EStructuralFeature)eReference, ValidatorFactory.getFilter(iFilter, eObject2), eObject2, eStructuralFeature);
                }
                if (eObject instanceof MethodLibrary) {
                    MethodLibrary methodLibrary = (MethodLibrary)eObject;
                    if (eReference == UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS) {
                        if (methodLibrary.eResource().getURI().isFile()) {
                            return new MethodPluginNameValidator(methodLibrary, (MethodPlugin)eObject2);
                        }
                        return new UniquenessValidator((EObject)methodLibrary, (EStructuralFeature)UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS, nonFilter, eObject2, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
                    }
                    if (eReference == UmaPackage.Literals.METHOD_LIBRARY__PREDEFINED_CONFIGURATIONS) {
                        if (methodLibrary.eResource().getURI().isFile()) {
                            return new MethodConfigurationNameValidator(methodLibrary, (MethodConfiguration)eObject2);
                        }
                        return new UniquenessValidator((EObject)methodLibrary, (EStructuralFeature)UmaPackage.Literals.METHOD_LIBRARY__PREDEFINED_CONFIGURATIONS, nonFilter, eObject2, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
                    }
                } else {
                    uniquenessValidator = new UniquenessValidator(eObject, (EStructuralFeature)eReference, ValidatorFactory.getFilter(iFilter, eObject2), eObject2, eStructuralFeature);
                }
            }
            return uniquenessValidator;
        }
        if (eStructuralFeature == UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION_NAME) {
            return this.createPresentationNameValidator(eObject, (DescribableElement)eObject2);
        }
        return DoNothingValidator.INSTANCE;
    }

    public static class TypeFilter
    implements IFilter {
        private int classID;
        private EClass eClass;

        public TypeFilter(EObject eObject) {
            this.classID = eObject.eClass().getClassifierID();
        }

        public TypeFilter(EClass eClass) {
            this.eClass = eClass;
        }

        public boolean accept(Object object) {
            if (this.eClass != null) {
                return this.eClass.isInstance(object);
            }
            return object instanceof EObject && this.classID == ((EObject)object).eClass().getClassifierID();
        }
    }
}

