/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.export.services.PluginExportService;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigSpecsImportManager;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.importing.services.LibraryDiffManager;
import org.eclipse.epf.importing.services.LibraryImportManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizard;
import org.eclipse.epf.library.util.ConvertGuidanceType;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.util.TypeConverter;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ConfigurationImportService {
    private boolean localDebug = false;
    private UpgradeCallerInfo upGradeInfo;
    private ConfigurationImportData data;
    LibraryDocument importingLibDoc = null;
    LibraryDiffManager diffMgr = null;
    ConfigSpecsImportManager specsMgr = null;

    public ConfigurationImportService(ConfigurationImportData configurationImportData) {
        this.data = configurationImportData;
    }

    public void analyze(IProgressMonitor iProgressMonitor) {
        block18: {
            try {
                String string;
                if (iProgressMonitor != null) {
                    iProgressMonitor.setTaskName(ImportResources.ConfigurationImportService_MSG0);
                }
                this.data.getErrorInfo().clear();
                String string2 = this.data.llData.getParentFolder();
                if (string2.indexOf(String.valueOf(File.separator) + "library.xmi") < 0) {
                    string2 = String.valueOf(string2) + File.separator + "library.xmi";
                }
                File file = new File(string2);
                boolean bl = true;
                if (!file.exists()) {
                    file = new File(file.getParentFile(), "export.xmi");
                    bl = false;
                }
                if (!file.exists()) {
                    this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.ConfigurationImportService_MSG1, (Object)file.getParent()));
                    return;
                }
                boolean bl2 = bl;
                if (bl2) {
                    this.upGradeInfo = new UpgradeInfo(UpgradeCallerInfo.upgradeImportConfig, file);
                    if (!ConfigurationImportService.handleToolVersion(file, this.upGradeInfo)) {
                        this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.ImportConfigurationWizard_ERR_Import_configuration, (Object)file.getParent()));
                        return;
                    }
                    if (this.upGradeInfo.getCopiedLibFile() != null) {
                        file = this.upGradeInfo.getCopiedLibFile();
                    }
                }
                this.importingLibDoc = new LibraryDocument(file);
                if (!bl2 && (string = ConfigurationImportService.versionCheck(file.getAbsolutePath(), ImportResources.importConfigWizard_title)) != null) {
                    this.data.getErrorInfo().addError(string);
                    return;
                }
                boolean bl3 = this.importingLibDoc.isConfigSpecsOnly();
                if (bl3) {
                    this.specsMgr = new ConfigSpecsImportManager();
                    this.data.specs = this.specsMgr.getConfigSpecs(this.importingLibDoc);
                    break block18;
                }
                if (!bl) {
                    this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.ConfigurationImportService_MSG1, (Object)file.getParent()));
                    return;
                }
                this.data.specs = null;
                String string3 = file.getParentFile().getAbsolutePath();
                String string4 = "Configuration Import Project (" + Integer.toHexString(string3.hashCode()) + ")";
                MethodLibraryProject.openProject((String)string3, (String)string4, (IProgressMonitor)iProgressMonitor);
                try {
                    MethodLibrary methodLibrary = LibraryUtil.loadLibrary((String)file.getAbsolutePath());
                    MethodLibrary methodLibrary2 = LibraryService.getInstance().getCurrentMethodLibrary();
                    this.handleTypeChanges(methodLibrary2, methodLibrary);
                    String string5 = null;
                    try {
                        File file2 = new File(methodLibrary2.eResource().getURI().toFileString()).getParentFile();
                        string5 = file2.getAbsolutePath();
                    }
                    catch (Throwable throwable) {}
                    if (string3.equalsIgnoreCase(string5)) {
                        this.data.getErrorInfo().addError(NLS.bind((String)ImportResources.ConfigurationImportService_MSG2, (Object)file.getParent()));
                        return;
                    }
                    ConfigurationImportService.fixImportLibrarySystemPackageGUIDs(methodLibrary2, methodLibrary);
                    this.diffMgr = new LibraryDiffManager(methodLibrary2, methodLibrary);
                    this.diffMgr.buildDiffTree();
                    if (this.localDebug) {
                        this.diffMgr.rootDiffTree.debugDump();
                    }
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
                MethodLibraryProject.closeProject((String)string3, (IProgressMonitor)iProgressMonitor);
                MethodLibraryProject.deleteProject((String)string3, (IProgressMonitor)iProgressMonitor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public ConfigurationImportData getImportData() {
        return this.data;
    }

    public boolean isSpecsOnly() {
        return this.data.specs != null;
    }

    public ElementDiffTree getDiffTree() {
        return this.diffMgr.getDiffTree();
    }

    public MethodLibrary getImportingLibrary() {
        return this.diffMgr.getImportingLibrary();
    }

    public void performImport(IProgressMonitor iProgressMonitor) {
        block17: {
            boolean bl = RefreshJob.getInstance().isEnabled();
            if (bl) {
                RefreshJob.getInstance().setEnabled(false);
            }
            try {
                try {
                    LibraryImportManager libraryImportManager;
                    if (iProgressMonitor != null) {
                        iProgressMonitor.setTaskName(ImportResources.ConfigurationImportService_MSG3);
                    }
                    if (this.isSpecsOnly()) {
                        this.specsMgr.doImport(this.data.specs);
                    } else {
                        libraryImportManager = new LibraryImportManager(this.diffMgr, this.data.importList);
                        libraryImportManager.doMerge(this.data.replaceExisting, iProgressMonitor);
                    }
                    libraryImportManager = LibraryService.getInstance().getCurrentMethodLibrary();
                    ResourceUtil.refreshResources((MethodLibrary)libraryImportManager, (IProgressMonitor)iProgressMonitor);
                }
                catch (Exception exception) {
                    ImportPlugin.getDefault().getLogger().logError((Throwable)exception);
                    if (bl) {
                        RefreshJob.getInstance().setEnabled(true);
                    }
                    if (this.upGradeInfo != null) {
                        this.upGradeInfo.removeCopiedLibrary();
                        this.upGradeInfo = null;
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    RefreshJob.getInstance().setEnabled(true);
                }
                if (this.upGradeInfo != null) {
                    this.upGradeInfo.removeCopiedLibrary();
                    this.upGradeInfo = null;
                }
                throw throwable;
            }
            if (bl) {
                RefreshJob.getInstance().setEnabled(true);
            }
            if (this.upGradeInfo != null) {
                this.upGradeInfo.removeCopiedLibrary();
                this.upGradeInfo = null;
            }
        }
        try {
            LibraryService.getInstance().reopenCurrentMethodLibrary();
        }
        catch (Exception exception) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    public static String versionCheck(final String string, final String string2) {
        final String[] stringArray = new String[]{null};
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                VersionUtil.VersionCheckInfo versionCheckInfo = VersionUtil.checkLibraryVersion((File)new File(string));
                if (versionCheckInfo == null) {
                    stringArray[0] = NLS.bind((String)ImportResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                } else if (versionCheckInfo.result < 0) {
                    stringArray[0] = versionCheckInfo.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportResources.versionMismatch_oldData, (Object[])new Object[]{versionCheckInfo.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportResources.versionMismatch_oldData_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                } else if (versionCheckInfo.result > 0) {
                    stringArray[0] = versionCheckInfo.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)ImportResources.versionMismatch_oldTool, (Object[])new Object[]{versionCheckInfo.toolVersion, Platform.getProduct().getName()}) : NLS.bind((String)ImportResources.versionMismatch_oldTool_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
                }
                if (stringArray[0] != null) {
                    ImportPlugin.getDefault().getMsgDialog().displayError(string2, stringArray[0]);
                }
            }
        });
        return stringArray[0];
    }

    public static void fixImportLibrarySystemPackageGUIDs(MethodLibrary methodLibrary, MethodLibrary methodLibrary2) {
        MethodPlugin methodPlugin;
        Object object;
        HashMap<String, MethodPlugin> hashMap = new HashMap<String, MethodPlugin>();
        List list = methodLibrary.getMethodPlugins();
        int n = 0;
        while (n < list.size()) {
            object = (MethodPlugin)list.get(n);
            hashMap.put(object.getGuid(), (MethodPlugin)object);
            ++n;
        }
        if (hashMap.isEmpty()) {
            return;
        }
        ArrayList<MethodPlugin> arrayList = new ArrayList<MethodPlugin>();
        object = methodLibrary2.getMethodPlugins();
        int n2 = 0;
        while (n2 < object.size()) {
            methodPlugin = (MethodPlugin)object.get(n2);
            if (hashMap.containsKey(methodPlugin.getGuid())) {
                arrayList.add(methodPlugin);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList.size()) {
            methodPlugin = (MethodPlugin)arrayList.get(n2);
            MethodPlugin methodPlugin2 = (MethodPlugin)hashMap.get(methodPlugin.getGuid());
            if (methodPlugin2 != null) {
                List list2 = TngUtil.getAllSystemPackages((MethodPlugin)methodPlugin);
                HashMap<String, MethodElement> hashMap2 = new HashMap<String, MethodElement>();
                int n3 = 0;
                while (n3 < list2.size()) {
                    MethodElement methodElement = (MethodElement)list2.get(n3);
                    hashMap2.put(methodElement.getName(), methodElement);
                    ++n3;
                }
                List list3 = TngUtil.getAllSystemPackages((MethodPlugin)methodPlugin2);
                int n4 = 0;
                while (n4 < list3.size()) {
                    MethodElement methodElement = (MethodElement)list3.get(n4);
                    MethodElement methodElement2 = (MethodElement)hashMap2.get(methodElement.getName());
                    if (methodElement2 != null) {
                        String string = methodElement.getGuid();
                        if (!methodElement2.getGuid().equals(string)) {
                            methodElement2.setGuid(string);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void handleTypeChanges(MethodLibrary methodLibrary, MethodLibrary methodLibrary2) {
        HashMap hashMap = new HashMap();
        ConfigurationImportService.collectPotentialTypeChanged(methodLibrary, hashMap);
        HashMap hashMap2 = new HashMap();
        ConfigurationImportService.collectPotentialTypeChanged(methodLibrary2, hashMap2);
        ConfigurationImportService.handleTypeChanges(hashMap, hashMap2);
    }

    public static void handleTypeChanges(HashMap hashMap, HashMap hashMap2) {
        MethodElement methodElement;
        Object object;
        ArrayList<MethodElement[]> arrayList = new ArrayList<MethodElement[]>();
        for (Map.Entry methodElementArray : hashMap2.entrySet()) {
            MethodElement methodElement2;
            object = methodElementArray.getKey();
            methodElement = (MethodElement)hashMap.get(object);
            if (methodElement == null || (methodElement2 = (MethodElement)methodElementArray.getValue()).eClass().equals(methodElement.eClass())) continue;
            MethodElement[] methodElementArray2 = new MethodElement[]{methodElement, methodElement2};
            arrayList.add(methodElementArray2);
        }
        int n = 0;
        while (n < arrayList.size()) {
            MethodElement[] methodElementArray = (MethodElement[])arrayList.get(n);
            object = methodElementArray[0];
            methodElement = methodElementArray[1];
            if (object instanceof Guidance) {
                Display.getDefault().syncExec(new Runnable((MethodElement)object, methodElement){
                    private final /* synthetic */ MethodElement val$baseElem;
                    private final /* synthetic */ MethodElement val$importElem;
                    {
                        this.val$baseElem = methodElement;
                        this.val$importElem = methodElement2;
                    }

                    public void run() {
                        ConvertGuidanceType.convertGuidance((Guidance)((Guidance)this.val$baseElem), (Shell)MsgBox.getDefaultShell(), null, (EClass)this.val$importElem.eClass());
                    }
                });
            } else if (object instanceof Activity) {
                TypeConverter.convertActivity((Activity)((Activity)object), (EClass)methodElement.eClass());
            }
            ++n;
        }
    }

    public static void collectPotentialTypeChanged(MethodLibrary methodLibrary, HashMap hashMap) {
        TreeIterator treeIterator = methodLibrary.eAllContents();
        while (treeIterator.hasNext()) {
            Object e = treeIterator.next();
            if (!(e instanceof Guidance) && !(e instanceof Activity)) continue;
            MethodElement methodElement = (MethodElement)e;
            hashMap.put(methodElement.getGuid(), methodElement);
        }
    }

    public static boolean handleToolVersion(File file, final UpgradeCallerInfo upgradeCallerInfo) {
        final String string = file.getParentFile().getAbsolutePath();
        final boolean[] blArray = new boolean[1];
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                blArray[0] = OpenLibraryWizard.handleToolVersion((String)string, (UpgradeCallerInfo)upgradeCallerInfo);
            }
        });
        return blArray[0];
    }

    public static class UpgradeInfo
    extends UpgradeCallerInfo {
        public UpgradeInfo(int n, File file) {
            super(n, file);
        }

        public void copyLibrary() {
            String string = System.getProperty("user.home");
            String string2 = String.valueOf(string) + File.separator + "EPF" + File.separator + "Export" + File.separator + Long.toHexString(Calendar.getInstance().getTimeInMillis()) + File.separator;
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            } else {
                FileUtil.deleteAllFiles((String)file.getAbsolutePath());
            }
            PluginExportService.copyDir((File)this.getLibFile().getParentFile(), (File)file);
            this.setCopiedLibFile(new File(String.valueOf(string2) + this.getLibFile().getName()));
        }

        public void removeCopiedLibrary() {
            if (this.getCopiedLibFile() == null) {
                return;
            }
            FileUtil.deleteAllFiles((String)this.getCopiedLibFile().getParentFile().getAbsolutePath());
            this.getCopiedLibFile().getParentFile().delete();
            this.setCopiedLibFile(null);
        }
    }
}

