/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;

public class NamedNodeImpl
extends NodeImpl
implements NamedNode {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    private AdapterImpl baseListener;
    protected BreakdownElementWrapperItemProvider itemProvider;

    protected NamedNodeImpl() {
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.NAMED_NODE;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)string2, (Object)this.name));
        }
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 7: {
                return this.getName();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 7: {
                this.setName((String)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 7: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 7: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (name: ");
        stringBuffer.append(this.name);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected Link addIncomingConnection(MethodElement methodElement) {
        Node node = this.findNode(methodElement);
        if (node == null) {
            return null;
        }
        Link link = ModelFactory.eINSTANCE.createLink();
        link.setTarget(this);
        NodeImpl nodeImpl = (NodeImpl)node;
        boolean bl = nodeImpl.notificationEnabled;
        try {
            nodeImpl.notificationEnabled = false;
            link.setSource(node);
        }
        finally {
            nodeImpl.notificationEnabled = bl;
        }
        if (this.isGraphicalDataRequired()) {
            GraphicalDataHelper.addGraphicalData(link);
        }
        return link;
    }

    protected Node findNode(MethodElement methodElement) {
        return GraphicalDataHelper.findNode(this.getDiagram(), (Object)methodElement);
    }

    protected Link addOutgoingConnection(MethodElement methodElement) {
        Node node = this.findNode(methodElement);
        if (node == null) {
            return null;
        }
        Link link = ModelFactory.eINSTANCE.createLink();
        NodeImpl nodeImpl = (NodeImpl)node;
        boolean bl = nodeImpl.notificationEnabled;
        try {
            nodeImpl.notificationEnabled = false;
            link.setTarget(node);
        }
        finally {
            nodeImpl.notificationEnabled = bl;
        }
        link.setSource(this);
        if (this.isGraphicalDataRequired()) {
            GraphicalDataHelper.addGraphicalData(link);
        }
        return link;
    }

    protected boolean removeIncomingConnection(MethodElement methodElement) {
        for (Link link : this.getIncomingConnections()) {
            if (link.getSource() == null || link.getSource().getObject() != methodElement) continue;
            GraphicalDataHelper.removeGraphicalData(link);
            NodeImpl nodeImpl = (NodeImpl)link.getSource();
            boolean bl = nodeImpl.notificationEnabled;
            try {
                nodeImpl.notificationEnabled = false;
                link.setSource(null);
            }
            finally {
                nodeImpl.notificationEnabled = bl;
            }
            link.setTarget(null);
            link.setObject(null);
            return true;
        }
        return false;
    }

    protected boolean removeOutgoingConnection(MethodElement methodElement) {
        for (Link link : this.getOutgoingConnections()) {
            if (link.getTarget() == null || link.getTarget().getObject() != methodElement) continue;
            GraphicalDataHelper.removeGraphicalData(link);
            NodeImpl nodeImpl = (NodeImpl)link.getTarget();
            boolean bl = nodeImpl.notificationEnabled;
            try {
                nodeImpl.notificationEnabled = false;
                link.setTarget(null);
            }
            finally {
                nodeImpl.notificationEnabled = bl;
            }
            link.setSource(null);
            link.setObject(null);
            return true;
        }
        return false;
    }

    public void setObject(Object object) {
        DescribableElement describableElement;
        super.setObject(object);
        if (object == null) {
            return;
        }
        String string = null;
        if (object instanceof DescribableElement) {
            describableElement = (DescribableElement)object;
            string = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)describableElement));
        }
        if (StrUtil.isBlank(string)) {
            describableElement = (MethodElement)object;
            string = describableElement.getName();
        }
        this.name = string;
    }

    protected void basicSetObject(Object object) {
        VariabilityElement variabilityElement;
        super.basicSetObject(object);
        if (object instanceof VariabilityElement && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)object)) && (variabilityElement = ((VariabilityElement)object).getVariabilityBasedOnElement()) != null) {
            if (this.baseListener == null) {
                this.baseListener = new AdapterImpl(){

                    public void notifyChanged(Notification notification) {
                        switch (notification.getFeatureID(DescribableElement.class)) {
                            case 7: {
                                DescribableElement describableElement = (DescribableElement)NamedNodeImpl.this.getObject();
                                if (!StrUtil.isBlank((String)describableElement.getPresentationName())) break;
                                String string = NamedNodeImpl.this.name;
                                NamedNodeImpl.this.name = notification.getNewStringValue();
                                if (NamedNodeImpl.this.name.equals(string)) break;
                                NamedNodeImpl.this.eNotify((Notification)new ENotificationImpl((InternalEObject)NamedNodeImpl.this, -1, 7, (Object)string, (Object)NamedNodeImpl.this.name));
                            }
                        }
                    }
                };
            }
            variabilityElement.eAdapters().add((Object)this.baseListener);
        }
    }

    protected void dispose() {
        EObject eObject = (EObject)this.getObject();
        if (eObject != null && this.baseListener != null) {
            eObject.eAdapters().remove((Object)this.baseListener);
        }
        super.dispose();
    }

    protected Adapter createNodeAdapter() {
        return new NodeImpl.NodeAdapter(this){

            public void notifyChanged(Notification notification) {
                if (!NamedNodeImpl.this.notificationEnabled) {
                    return;
                }
                NamedNodeImpl.this.notificationEnabled = false;
                try {
                    switch (notification.getFeatureID(NamedNode.class)) {
                        case 7: {
                            if (notification.getEventType() == 1 && NamedNodeImpl.this.getObject() instanceof BreakdownElement) {
                                String string = notification.getNewStringValue();
                                BreakdownElement breakdownElement = (BreakdownElement)NamedNodeImpl.this.getObject();
                                breakdownElement.setPresentationName(string);
                                if (StrUtil.isBlank((String)breakdownElement.getName())) {
                                    breakdownElement.setName(string);
                                }
                            }
                            return;
                        }
                    }
                    super.notifyChanged(notification);
                }
                finally {
                    NamedNodeImpl.this.notificationEnabled = true;
                }
            }
        };
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public void setNotificationEnabled(boolean bl) {
        this.notificationEnabled = bl;
    }

    public boolean isSuppressed() {
        Suppression suppression = this.getDiagram().getSuppression();
        if (suppression != null) {
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = this.itemProvider != null ? this.itemProvider : this.getLinkedElement();
            return this.getDiagram().getSuppression().isSuppressed((Object)breakdownElementWrapperItemProvider);
        }
        return false;
    }

    public Object getWrapper() {
        return this.itemProvider;
    }

    void setItemProvider(Collection collection) {
        BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider;
        Object object = GraphicalDataHelper.findElement(collection, this.getObject());
        if (object instanceof BreakdownElementWrapperItemProvider && (breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)object).isReadOnly()) {
            this.itemProvider = breakdownElementWrapperItemProvider;
            this.readOnly = true;
        }
    }

    protected class MethodElementAdapter
    extends NodeImpl.TransactionalNodeLink {
        protected MethodElementAdapter() {
            super(NamedNodeImpl.this);
        }

        protected void handleNotification(Notification notification) {
            switch (notification.getFeatureID(DescribableElement.class)) {
                case 7: {
                    NamedNodeImpl.this.setName(notification.getNewStringValue());
                    return;
                }
            }
        }

        public void notifyChanged(final Notification notification) {
            if (!NamedNodeImpl.this.notificationEnabled) {
                return;
            }
            NamedNodeImpl.this.notificationEnabled = false;
            try {
                try {
                    TxUtil.runInTransaction(this.getNode(), new Runnable(){

                        public void run() {
                            MethodElementAdapter.this.handleNotification(notification);
                        }
                    });
                }
                catch (Exception exception) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)exception);
                    NamedNodeImpl.this.notificationEnabled = true;
                }
            }
            finally {
                NamedNodeImpl.this.notificationEnabled = true;
            }
        }

        public Node getNode() {
            return NamedNodeImpl.this;
        }
    }
}

