/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.preferences;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.ui.preferences.BasePreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class PublishingPreferencePage
extends BasePreferencePage {
    private Composite composite;
    private Text destinationPathText;
    private Text feedbackURLText;
    private Button browseButton;
    private Button extraDescriptorInfoCheckbox;

    protected Control createContents(Composite composite) {
        this.composite = PublishingPreferencePage.createGridLayoutComposite((Composite)composite, (int)1);
        Group group = PublishingPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)PublishingUIResources.publishWebSiteGroup_text, (int)3);
        PublishingPreferencePage.createLabel((Composite)group, (String)PublishingUIResources.preferencePage_defaultPath_text);
        this.destinationPathText = PublishingPreferencePage.createEditableText((Composite)group);
        this.browseButton = PublishingPreferencePage.createButton((Composite)group, (String)AuthoringUIText.BROWSE_BUTTON_TEXT);
        PublishingPreferencePage.createLabel((Composite)group, (String)PublishingUIResources.feedbackURLLabel_text);
        this.feedbackURLText = PublishingPreferencePage.createEditableText((Composite)group, (int)2);
        Group group2 = PublishingPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)PublishingUIResources.browsingLayoutGroup_text, (int)1);
        this.extraDescriptorInfoCheckbox = PublishingPreferencePage.createCheckbox((Composite)group2, (String)PublishingUIResources.publishExtraDescriptorInfoLabel_text, (int)1);
        this.initControls();
        this.addListeners();
        return this.composite;
    }

    protected void initControls() {
        this.destinationPathText.setText(PublishingUIPreferences.getPublishPath());
        this.feedbackURLText.setText(PublishingUIPreferences.getFeedbackURL());
        this.extraDescriptorInfoCheckbox.setSelection(PublishingUIPreferences.getExtraDescriptorInfo());
    }

    protected void addListeners() {
        this.destinationPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!PublishingPreferencePage.this.isPathValid(PublishingPreferencePage.this.destinationPathText.getText())) {
                    PublishingPreferencePage.this.setValid(false);
                } else {
                    PublishingPreferencePage.this.setValid(true);
                }
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PublishingPreferencePage.this.openDirectoryDialog();
            }
        });
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        PublishingUIPreferences.saveAllPreferences();
        PublishingUIPlugin.getDefault().updateLayoutSettings();
        return true;
    }

    private void storeValues() {
        PublishingUIPreferences.setPublishPath(this.destinationPathText.getText().trim());
        PublishingUIPreferences.setFeedbackURL(this.feedbackURLText.getText().trim());
        PublishingUIPreferences.setExtraDescriptorInfo(this.extraDescriptorInfoCheckbox.getSelection());
    }

    private void initializeDefaults() {
        this.destinationPathText.setText(PublishingUIPreferences.getDefaultPublishPath());
        this.feedbackURLText.setText(PublishingUIPreferences.getDefaultFeedbackURL());
        this.extraDescriptorInfoCheckbox.setSelection(PublishingUIPreferences.getDefaultExtraDescriptorInfo());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PublishingPlugin.getDefault().getPreferenceStore();
    }

    private boolean isPathValid(String string) {
        if (string == null || string.length() <= 0) {
            this.setErrorMessage(PublishingUIResources.invalidPathError_msg);
            return false;
        }
        IPath iPath = Path.fromOSString((String)string);
        boolean bl = iPath.isValidPath(string);
        if (!bl) {
            this.setErrorMessage(PublishingUIResources.invalidPathError_msg);
            return false;
        }
        if (!StrUtil.isValidPublishPath((String)string)) {
            this.setErrorMessage(PublishingUIResources.invalidPathCharsError_msg);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.composite.getShell(), 0);
            String string = directoryDialog.open();
            if (string != null) {
                this.destinationPathText.setText(string);
            }
        }
        catch (Exception exception) {
            PublishingUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }
}

