/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.views.ProcessTreeContentProvider;
import org.eclipse.epf.library.ui.views.ProcessTreeLabelProvider;
import org.eclipse.epf.library.ui.views.ProcessTreeUIFolder;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectContentPage
extends BaseWizardPage
implements Listener {
    public static final String PAGE_NAME = SelectContentPage.class.getName();
    protected Button publishConfigRadioButton;
    protected Button publishProcessesRadioButton;
    protected CheckboxTreeViewer processViewer;
    protected Button includeBaseProcessesCheckbox;
    protected MethodConfiguration config;

    public SelectContentPage() {
        super(PAGE_NAME);
        this.setTitle(PublishingUIResources.selectContentWizardPage_title);
        this.setDescription(PublishingUIResources.selectContentWizardPage_text);
        this.setImageDescriptor(PublishingUIPlugin.getDefault().getImageDescriptor("full/wizban/PublishConfiguration.gif"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = SelectContentPage.createGridLayoutComposite((Composite)composite, (int)1);
        this.publishConfigRadioButton = SelectContentPage.createRadioButton((Composite)composite2, (String)PublishingUIResources.publishConfigRadioButton_text, (int)1, (boolean)true);
        this.publishProcessesRadioButton = SelectContentPage.createRadioButton((Composite)composite2, (String)PublishingUIResources.publishProcessesRadioButton_text, (int)1, (boolean)false);
        Composite composite3 = SelectContentPage.createChildGridLayoutComposite((Composite)composite2, (int)1);
        this.processViewer = new CheckboxTreeViewer(composite3);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        this.processViewer.getTree().setLayoutData((Object)gridData);
        this.includeBaseProcessesCheckbox = SelectContentPage.createCheckbox((Composite)composite3, (String)PublishingUIResources.includeBaseProcessesCheckboxLabel_text);
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite2);
    }

    protected void initControls() {
        this.processViewer.setContentProvider((IContentProvider)new ProcessViewerContentProvider());
        this.processViewer.setLabelProvider((IBaseLabelProvider)new ProcessTreeLabelProvider());
        String string = this.config != null ? this.config.getGuid() : "";
        boolean bl = PublishingUIPreferences.getPublishEntireConfig(string);
        this.publishConfigRadioButton.setSelection(bl);
        this.publishProcessesRadioButton.setSelection(!bl);
        this.processViewer.getControl().setEnabled(!bl);
    }

    protected void addListeners() {
        this.publishConfigRadioButton.addListener(13, (Listener)this);
        this.publishProcessesRadioButton.addListener(13, (Listener)this);
        this.includeBaseProcessesCheckbox.addListener(13, (Listener)this);
        this.processViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getElement();
                boolean bl = checkStateChangedEvent.getChecked();
                SelectContentPage.this.processViewer.setChecked(object, bl);
                SelectContentPage.this.processViewer.setSubtreeChecked(object, bl);
                if (SelectContentPage.this.includeBaseProcessesCheckbox.getSelection()) {
                    SelectContentPage.this.selectBaseProcesses();
                }
                SelectContentPage.this.updateCheckedStates();
                SelectContentPage.this.setPageComplete(SelectContentPage.this.isPageComplete());
            }
        });
    }

    private void updateCheckedStates() {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.processViewer.getContentProvider();
        if (this.config != null) {
            Object[] objectArray = iTreeContentProvider.getChildren((Object)this.config);
            int n = 0;
            while (n < objectArray.length) {
                Object[] objectArray2 = iTreeContentProvider.getChildren(objectArray[n]);
                int n2 = objectArray2.length;
                int n3 = 0;
                int n4 = 0;
                while (n4 < objectArray2.length) {
                    Object[] objectArray3 = iTreeContentProvider.getChildren(objectArray2[n4]);
                    int n5 = objectArray3.length;
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < objectArray3.length) {
                        if (this.processViewer.getChecked(objectArray3[n7])) {
                            ++n6;
                        }
                        ++n7;
                    }
                    if (n6 == 0) {
                        this.processViewer.setGrayChecked(objectArray2[n4], false);
                    } else if (n6 == n5) {
                        this.processViewer.setGrayed(objectArray2[n4], false);
                        this.processViewer.setChecked(objectArray2[n4], true);
                    } else {
                        this.processViewer.setGrayChecked(objectArray2[n4], true);
                    }
                    if (this.processViewer.getChecked(objectArray2[n4])) {
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 == n2) {
                    this.processViewer.setGrayed(objectArray[n], false);
                    this.processViewer.setChecked(objectArray[n], true);
                } else if (n3 == 0) {
                    this.processViewer.setGrayChecked(objectArray[n], false);
                } else {
                    this.processViewer.setGrayChecked(objectArray[n], true);
                }
                ++n;
            }
        }
    }

    private void selectBaseProcesses() {
        List<Process> list = this.getSelectedProcesses();
        ArrayList arrayList = new ArrayList();
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            ConfigurationHelper.getBaseProcesses((Activity)((Activity)iterator.next()), (MethodConfiguration)this.config, arrayList);
        }
        for (Object object : arrayList) {
            this.processViewer.setChecked(object, true);
        }
    }

    public void handleEvent(Event event) {
        this.processViewer.getControl().setEnabled(this.publishProcessesRadioButton.getSelection());
        if (event.widget == this.includeBaseProcessesCheckbox) {
            this.selectBaseProcesses();
            this.updateCheckedStates();
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void onEnterPage(Object object) {
        if (object != null && object instanceof String) {
            String string = (String)object;
            this.config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)string);
            if (this.config != null) {
                this.processViewer.setInput((Object)this.config);
                this.processViewer.expandAll();
            }
        }
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (this.publishConfigRadioButton.getSelection()) {
            return true;
        }
        return this.getSelectedProcesses().size() > 0;
    }

    public Object getNextPageData() {
        return this.config;
    }

    public boolean getPublishConfigSelection() {
        return this.publishConfigRadioButton.getSelection();
    }

    public List<Process> getSelectedProcesses() {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        Object[] objectArray = this.processViewer.getCheckedElements();
        if (objectArray != null && objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof Process) {
                    arrayList.add((Process)objectArray[n]);
                }
                ++n;
            }
        }
        return arrayList;
    }

    protected class ProcessViewerContentProvider
    extends ProcessTreeContentProvider {
        private List<MethodPackage> packages = new ArrayList<MethodPackage>();

        protected ProcessViewerContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            super.inputChanged(viewer, object, object2);
        }

        public Object[] getChildren(Object object) {
            if (object instanceof MethodConfiguration) {
                MethodConfiguration methodConfiguration = (MethodConfiguration)object;
                ArrayList<MethodPlugin> arrayList = new ArrayList<MethodPlugin>();
                this.packages = methodConfiguration.getMethodPackageSelection();
                List list = methodConfiguration.getMethodPluginSelection();
                for (MethodPlugin methodPlugin : list) {
                    List list2 = TngUtil.getAllProcesses((MethodPlugin)methodPlugin);
                    if (list2.size() <= 0) continue;
                    arrayList.add(methodPlugin);
                }
                return arrayList.toArray();
            }
            if (object instanceof ProcessTreeUIFolder) {
                ProcessTreeUIFolder processTreeUIFolder = (ProcessTreeUIFolder)object;
                MethodPlugin methodPlugin = (MethodPlugin)processTreeUIFolder.getParent();
                if (processTreeUIFolder.getName() == CAPABILITY_PATTERNS) {
                    ArrayList<CapabilityPattern> arrayList = new ArrayList<CapabilityPattern>();
                    List list = LibraryServiceUtil.getCapabilityPatterns((MethodPlugin)methodPlugin);
                    for (CapabilityPattern capabilityPattern : list) {
                        ProcessPackage processPackage = UmaUtil.getProcessPackage((EObject)capabilityPattern);
                        if (!this.packages.contains(processPackage)) continue;
                        arrayList.add(capabilityPattern);
                    }
                    return arrayList.toArray();
                }
                ArrayList<DeliveryProcess> arrayList = new ArrayList<DeliveryProcess>();
                List list = LibraryServiceUtil.getDeliveryProcesses((MethodPlugin)methodPlugin);
                for (DeliveryProcess deliveryProcess : list) {
                    ProcessPackage processPackage = UmaUtil.getProcessPackage((EObject)deliveryProcess);
                    if (!this.packages.contains(processPackage)) continue;
                    arrayList.add(deliveryProcess);
                }
                return arrayList.toArray();
            }
            return super.getChildren(object);
        }
    }
}

