/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.epf.common.utils.StrUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    public static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String XML_AMP = "&amp;";
    public static final String XML_BACKSLASH = "&#92;";
    public static final String XML_APOS = "&apos;";
    public static final String XML_CR = "&#13;";
    public static final String XML_GT = "&gt;";
    public static final String XML_LT = "&lt;";
    public static final String XML_LF = "&#10;";
    public static final String XML_QUOT = "&quot;";
    public static final String XML_TAB = "&#9;";
    private static final String CRLF = "\r\n";
    private static final byte[] CRLF_BYTES = "\r\n".getBytes();

    private XMLUtil() {
    }

    public static Node cloneNode(Node node, Document document) {
        Node node2 = null;
        switch (node.getNodeType()) {
            case 1: {
                Node node3;
                node2 = document.createElement(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node4 = namedNodeMap.item(n);
                    node3 = document.createAttribute(node4.getNodeName());
                    node3.setNodeValue(node4.getNodeValue());
                    ((Element)node2).setAttributeNode((Attr)node3);
                    ++n;
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    node3 = nodeList.item(n2);
                    Node node5 = XMLUtil.cloneNode(node3, document);
                    node2.appendChild(node5);
                    ++n2;
                }
                break;
            }
            case 3: 
            case 4: {
                node2 = document.createTextNode(node.getNodeName());
                node2.setNodeValue(node.getNodeValue());
            }
        }
        return node2;
    }

    public static String escapeAttr(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append(XML_LT);
                    break;
                }
                case '&': {
                    stringBuffer.append(XML_AMP);
                    break;
                }
                case '\"': {
                    stringBuffer.append(XML_QUOT);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append(XML_LT);
                    break;
                }
                case '>': {
                    stringBuffer.append(XML_GT);
                    break;
                }
                case '&': {
                    stringBuffer.append(XML_AMP);
                    break;
                }
                case '\"': {
                    stringBuffer.append(XML_QUOT);
                    break;
                }
                case '\'': {
                    stringBuffer.append(XML_APOS);
                    break;
                }
                case '\r': {
                    stringBuffer.append(XML_CR);
                    break;
                }
                case '\n': {
                    stringBuffer.append(XML_LF);
                    break;
                }
                case '\\': {
                    stringBuffer.append(XML_BACKSLASH);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String escape(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append(XML_LT);
                    break;
                }
                case '>': {
                    stringBuffer.append(XML_GT);
                    break;
                }
                case '&': {
                    if (!(string.startsWith("&lt;p/", n2) || string.startsWith(XML_APOS, n2) || string.startsWith(XML_AMP, n2))) {
                        stringBuffer.append(XML_AMP);
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case '\"': {
                    stringBuffer.append(XML_QUOT);
                    break;
                }
                case '\'': {
                    stringBuffer.append(XML_APOS);
                    break;
                }
                case '\r': {
                    if (bl) {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append(XML_CR);
                    break;
                }
                case '\n': {
                    if (bl) {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append(XML_LF);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    if (string.startsWith(XML_LT, n2)) {
                        stringBuffer.append('<');
                        n2 += 3;
                        break;
                    }
                    if (string.startsWith(XML_GT, n2)) {
                        stringBuffer.append('>');
                        n2 += 3;
                        break;
                    }
                    if (string.startsWith(XML_AMP, n2)) {
                        stringBuffer.append('&');
                        n2 += 4;
                        break;
                    }
                    if (string.startsWith(XML_QUOT, n2)) {
                        stringBuffer.append('\"');
                        n2 += 5;
                        break;
                    }
                    if (string.startsWith(XML_APOS, n2)) {
                        stringBuffer.append("'");
                        n2 += 5;
                        break;
                    }
                    if (string.startsWith(XML_CR, n2)) {
                        stringBuffer.append('\r');
                        n2 += 4;
                        break;
                    }
                    if (string.startsWith(XML_LF, n2)) {
                        stringBuffer.append('\n');
                        n2 += 4;
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void writeDocument(Document document, OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        XMLUtil.writeNode(document, "", dataOutputStream);
        dataOutputStream.flush();
    }

    public static void writeDocument(Document document, PrintWriter printWriter) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        XMLUtil.writeNode(document, "", dataOutputStream);
        dataOutputStream.flush();
        String string = byteArrayOutputStream.toString();
        printWriter.write(string);
        printWriter.flush();
    }

    public static void saveDocument(Document document, String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
        XMLUtil.writeNode(document, "", dataOutputStream);
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    public static void saveDocument(String string, String string2) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
        dataOutputStream.write(string.getBytes());
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    private static void writeNode(Node node, String string, DataOutputStream dataOutputStream) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                dataOutputStream.write(StrUtil.getUTF8Bytes(XML_DECLARATION));
                dataOutputStream.write(CRLF_BYTES);
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = 0;
                while (n < nodeList.getLength()) {
                    XMLUtil.writeNode(nodeList.item(n), "", dataOutputStream);
                    ++n;
                }
                break;
            }
            case 1: {
                String string2 = node.getNodeName();
                dataOutputStream.write(StrUtil.getUTF8Bytes(String.valueOf(string) + "<" + string2));
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    dataOutputStream.write(StrUtil.getUTF8Bytes(" " + node2.getNodeName() + "=\"" + XMLUtil.escape(node2.getNodeValue()) + "\""));
                    ++n;
                }
                dataOutputStream.write(StrUtil.getUTF8Bytes(">"));
                dataOutputStream.write(CRLF_BYTES);
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        XMLUtil.writeNode(nodeList.item(n2), string, dataOutputStream);
                        ++n2;
                    }
                }
                dataOutputStream.write(StrUtil.getUTF8Bytes(String.valueOf(string) + "</" + string2 + ">"));
                dataOutputStream.write(CRLF_BYTES);
                break;
            }
            case 3: {
                String string3 = StrUtil.removeWhiteSpaceChars(node.getNodeValue());
                if (string3.length() <= 0) break;
                dataOutputStream.write(StrUtil.getUTF8Bytes(XMLUtil.escape(string3)));
                break;
            }
            case 4: {
                String string4 = StrUtil.removeWhiteSpaceChars(node.getNodeValue());
                if (string4.length() <= 0) break;
                dataOutputStream.write(StrUtil.getUTF8Bytes("<![CDATA["));
                dataOutputStream.write(StrUtil.getUTF8Bytes(string4));
                dataOutputStream.write(StrUtil.getUTF8Bytes("]]>"));
                dataOutputStream.write(CRLF_BYTES);
                break;
            }
            case 7: {
                dataOutputStream.write(StrUtil.getUTF8Bytes("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>"));
                dataOutputStream.write(CRLF_BYTES);
                break;
            }
            case 5: {
                dataOutputStream.write(StrUtil.getUTF8Bytes("&" + node.getNodeName() + ";"));
            }
        }
    }

    public static String getLocationOfException(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("row ");
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(", col ");
        stringBuffer.append(sAXParseException.getColumnNumber());
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(" of XML document ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static Document loadXml(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    public static Document createDocument() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }

    public static String getNodeText(Element element) {
        String string = element.toString();
        int n = string.indexOf(">");
        int n2 = string.lastIndexOf("</");
        if (n < 0 || n2 < 0 || n2 < n) {
            return "";
        }
        return string.substring(n + 1, n2);
    }

    public static String getChildText(Element element, String string) {
        Element element2 = XMLUtil.getFirstChild(element, string);
        if (element2 != null) {
            return XMLUtil.getNodeText(element2);
        }
        return "";
    }

    public static Element getFirstChild(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public static Iterator childIterator(Element element) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (nodeList != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node instanceof Element) {
                    arrayList.add(node);
                }
                ++n2;
            }
        }
        return arrayList.iterator();
    }

    public static Iterator childIterator(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        return new NodeIterator(nodeList);
    }

    private static class NodeIterator
    implements Iterator {
        int currentIndex = -1;
        int size = 0;
        NodeList nodes = null;

        public NodeIterator(NodeList nodeList) {
            this.nodes = nodeList;
            if (nodeList != null) {
                this.size = nodeList.getLength();
            }
        }

        public void remove() {
        }

        public boolean hasNext() {
            return this.currentIndex + 1 < this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.nodes.item(++this.currentIndex);
            }
            return null;
        }
    }
}

