/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavadocConsoleLineTracker
implements IConsoleLineTracker {
    private IConsole fConsole;

    public void init(IConsole console) {
        this.fConsole = console;
    }

    public void lineAppended(IRegion line) {
        try {
            int offset = line.getOffset();
            int length = line.getLength();
            String text = this.fConsole.getDocument().get(offset, length);
            int index1 = text.indexOf(58);
            if (index1 == -1) {
                return;
            }
            int lineNumber = -1;
            IPath path = null;
            int index2 = text.indexOf(58, index1 + 1);
            while (index2 != -1 && path == null) {
                if (index1 < index2) {
                    try {
                        String substr = text.substring(index1 + 1, index2);
                        lineNumber = Integer.parseInt(substr);
                        path = Path.fromOSString((String)text.substring(0, index1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                index1 = index2;
                index2 = text.indexOf(58, index1 + 1);
            }
            if (lineNumber != -1) {
                JavadocConsoleHyperLink link = new JavadocConsoleHyperLink(path, lineNumber);
                this.fConsole.addLink((IHyperlink)link, line.getOffset(), index1);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void dispose() {
        this.fConsole = null;
    }

    private static class JavadocConsoleHyperLink
    implements IHyperlink {
        private IPath fExternalPath;
        private int fLineNumber;

        public JavadocConsoleHyperLink(IPath externalPath, int lineNumber) {
            this.fExternalPath = externalPath;
            this.fLineNumber = lineNumber;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            try {
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(this.fExternalPath);
                if (files.length > 0) {
                    int i = 0;
                    while (i < files.length) {
                        IFile curr = files[0];
                        IJavaElement element = JavaCore.create((IFile)curr);
                        if (element != null && element.exists()) {
                            IEditorPart part = JavaUI.openInEditor(element, true, false);
                            if (part instanceof ITextEditor) {
                                this.revealLine((ITextEditor)part, this.fLineNumber);
                            }
                            return;
                        }
                        ++i;
                    }
                }
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }

        private void revealLine(ITextEditor editor, int lineNumber) throws BadLocationException {
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            IRegion region = document.getLineInformation(lineNumber - 1);
            editor.selectAndReveal(region.getOffset(), 0);
        }
    }
}

