/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.IDiagramMigration;
import org.eclipse.epf.migration.diagram.DiagramMigrationPlugin;
import org.eclipse.epf.migration.diagram.ad.services.WorkflowExportService;
import org.eclipse.epf.migration.diagram.util.MigrationUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramMigration
implements IDiagramMigration {
    protected boolean debug;

    public void migrate(Collection<Process> collection) throws Exception {
        this.debug = DiagramMigrationPlugin.getDefault().isDebugging();
        WorkflowExportService workflowExportService = new WorkflowExportService();
        int n = 0;
        MethodLibrary methodLibrary = null;
        for (Process process : collection) {
            String string;
            if (methodLibrary == null) {
                methodLibrary = UmaUtil.getMethodLibrary((EObject)process);
            }
            if (this.debug) {
                System.out.println("LD> proc: " + process);
                System.out.println("LD>  proc.eResource(): " + process.eResource());
                if (process.eResource() != null) {
                    System.out.println("LD>  proc.eResource().getURI(): " + process.eResource());
                }
            }
            String string2 = string = process.eResource() == null ? null : process.eResource().getURI().toFileString();
            if (string == null) continue;
            File file = new File(string).getParentFile();
            String string3 = String.valueOf(file.getAbsolutePath()) + File.separator + "diagram.xmi";
            File file2 = new File(string3);
            if (file2.exists()) {
                file2.delete();
                System.out.println("LD> Deleted diagramFile: " + file2);
                ResourceUtil.refreshResources((MethodLibrary)methodLibrary, null);
            }
            if (this.debug) {
                System.out.println("LD> diagramFile: " + file2);
            }
            try {
                workflowExportService.export(process, (Activity)process, "diagram.xmi", file);
            }
            catch (Exception exception) {
                ++n;
                if (!this.debug) continue;
                System.out.println("LD> failed: " + file2);
            }
        }
        if (this.debug) {
            System.out.println("LD> processes.size(): " + collection.size());
            System.out.println("LD> errorCount: " + n);
            System.out.println("");
        }
        this.removeOldDiagrams(collection, methodLibrary);
    }

    private void removeOldDiagrams(Collection<Process> collection, MethodLibrary methodLibrary) {
        block9: {
            if (methodLibrary == null) {
                return;
            }
            boolean bl = false;
            if (this.debug) {
                System.out.println("LD> removeOldDiagrams ...");
            }
            for (Process process : collection) {
                boolean bl2 = false;
                try {
                    Map map = MigrationUtil.getActivities(process, true);
                    for (Activity activity : map.values()) {
                        ProcessPackage processPackage;
                        EObject eObject = activity.eContainer();
                        if (!(eObject instanceof ProcessPackage) || (processPackage = (ProcessPackage)eObject).getDiagrams().isEmpty()) continue;
                        ArrayList arrayList = new ArrayList(processPackage.getDiagrams());
                        processPackage.getDiagrams().removeAll(arrayList);
                        bl2 = true;
                        if (!this.debug) continue;
                        System.out.println("LD> proc: " + process);
                        System.out.println("LD>  pkg: ");
                    }
                    if (!bl2) continue;
                    process.eResource().setModified(true);
                    bl = true;
                }
                catch (Exception exception) {
                    if (!this.debug) continue;
                    exception.printStackTrace();
                }
            }
            if (bl) {
                Process process;
                Resource resource = methodLibrary.eResource();
                process = (MultiFileResourceSetImpl)resource.getResourceSet();
                Map map = process.getDefaultSaveOptions();
                try {
                    process.save(map, true);
                }
                catch (Exception exception) {
                    if (!this.debug) break block9;
                    exception.printStackTrace();
                }
            }
        }
    }
}

