/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.addwpd.map;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.migration.diagram.ad.map.MapUtil;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public class ConnectionFactory {
    private HashMap map = null;
    private Diagram diagram = null;
    private String kind;
    private static final int IMAGE_HEIGHT = 32;

    public ConnectionFactory(Diagram diagram, HashMap hashMap, String string) {
        this.map = hashMap;
        this.diagram = diagram;
        this.kind = string;
    }

    public void outgoingConnections(org.eclipse.epf.diagram.model.Node node) {
        EList eList = node.getOutgoingConnections();
        if (eList != null && eList.size() > 0) {
            for (Link link : eList) {
                Edge edge = this.createConnection(link);
                Node node2 = (Node)this.map.get(node);
                node2.getSourceEdges().add((Object)edge);
                node2.getDiagram().insertEdge(edge);
            }
        }
    }

    public void incomingConnections(org.eclipse.epf.diagram.model.Node node) {
        EList eList = node.getIncomingConnections();
        if (eList != null && eList.size() > 0) {
            for (Link link : eList) {
                Edge edge = this.createConnection(link);
                Node node2 = (Node)this.map.get(node);
                node2.getTargetEdges().add((Object)edge);
                node2.getDiagram().insertEdge(edge);
            }
        }
    }

    private Edge createConnection(Link link) {
        Node node;
        org.eclipse.epf.diagram.model.Node node2 = link.getSource();
        org.eclipse.epf.diagram.model.Node node3 = link.getTarget();
        Node node4 = (Node)this.map.get(node2);
        Edge edge = this.findEdge(node4, node = (Node)this.map.get(node3));
        if (edge == null && node != null) {
            if (this.kind == "ADD") {
                edge = MapUtil.createEdge_WPD(node4, node, (EObject)link);
            } else if (this.kind == "WPDD") {
                edge = MapUtil.createEdge_WPD(node4, node, (EObject)link);
            }
            if (edge == null) {
                return null;
            }
            edge.setElement((EObject)link);
            this.loadSourceAndTargetEndPoint(edge, link);
            this.loadBendPoints(edge, link);
        }
        return edge;
    }

    private void loadSourceAndTargetEndPoint(Edge edge, Link link) {
        IdentityAnchor identityAnchor;
        Bounds bounds;
        Point point = link.getSourceEndPoint();
        Point point2 = link.getTargetEndPoint();
        View view = edge.getSource();
        View view2 = edge.getTarget();
        if (point != null && view instanceof Node) {
            bounds = (Bounds)((Node)view).getLayoutConstraint();
            if (bounds.getHeight() == -1) {
                bounds.setHeight(40);
            }
            if ((identityAnchor = this.createIdentityAnchor(point, bounds)) != null) {
                edge.setSourceAnchor((Anchor)identityAnchor);
            }
        }
        if (point2 != null && view2 instanceof Node) {
            bounds = (Bounds)((Node)view2).getLayoutConstraint();
            if (bounds.getHeight() == -1) {
                bounds.setHeight(40);
            }
            if ((identityAnchor = this.createIdentityAnchor(point2, bounds)) != null) {
                edge.setTargetAnchor((Anchor)identityAnchor);
            }
        }
    }

    private IdentityAnchor createIdentityAnchor(Point point, Bounds bounds) {
        PrecisionPoint precisionPoint = MapUtil.getAnchorRelativeLocation(point, bounds);
        String string = MapUtil.composeTerminalString(precisionPoint);
        IdentityAnchor identityAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        identityAnchor.setId(string);
        return identityAnchor;
    }

    private void loadBendPoints(Edge edge, Link link) {
        EList eList = link.getBendpoints();
        ArrayList<RelativeBendpoint> arrayList = new ArrayList<RelativeBendpoint>();
        RelativeBendpoint relativeBendpoint = new RelativeBendpoint(0, 0, 0, 0);
        arrayList.add(relativeBendpoint);
        if (eList != null && eList.size() > 0) {
            for (AbsoluteBendpoint absoluteBendpoint : eList) {
                Node node = (Node)edge.getSource();
                Node node2 = (Node)edge.getTarget();
                Bounds bounds = (Bounds)node.getLayoutConstraint();
                Bounds bounds2 = (Bounds)node2.getLayoutConstraint();
                int n = MapUtil.getNoOfLines(node);
                int n2 = MapUtil.getNoOfLines(node2);
                int n3 = MapUtil.getTextHeight(node);
                int n4 = MapUtil.getTextHeight(node2);
                int n5 = bounds.getX() + bounds.getWidth() / 2;
                int n6 = bounds.getY() + (32 + n * n3) / 2;
                int n7 = bounds2.getX() + bounds2.getWidth() / 2;
                int n8 = bounds2.getY() + (32 + n2 * n4) / 2;
                int n9 = absoluteBendpoint.x - n5;
                int n10 = absoluteBendpoint.y - n6;
                int n11 = absoluteBendpoint.x - n7;
                int n12 = absoluteBendpoint.y - n8;
                RelativeBendpoint relativeBendpoint2 = new RelativeBendpoint(n9, n10, n11, n12);
                arrayList.add(relativeBendpoint2);
            }
        }
        arrayList.add(relativeBendpoint);
        if (arrayList.size() > 0) {
            RelativeBendpoints relativeBendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
            relativeBendpoints.setPoints(arrayList);
            edge.setBendpoints((Bendpoints)relativeBendpoints);
        }
    }

    private Edge findEdge(Node node, Node node2) {
        EList eList = this.diagram.getEdges();
        if (eList != null && eList.size() > 0) {
            for (Edge edge : eList) {
                if (edge.getTarget() == null || !node2.equals(edge.getTarget()) || edge.getSource() == null || !node.equals(edge.getSource())) continue;
                return edge;
            }
        }
        return null;
    }
}

