/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.OpenLibraryMainPage;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class OpenLibraryWizard
extends BaseWizard
implements INewWizard {
    public static final String WIZARD_ID = OpenLibraryWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.library.ui.openLibraryWizard";
    protected OpenLibraryMainPage mainPage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.setWindowTitle(LibraryUIResources.openLibraryWizard_title);
    }

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.mainPage = this.createMainPage();
            super.addPage((IWizardPage)this.mainPage);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            IWizardPage iWizardPage = this.wizardExtender.getReplaceWizardPage(OpenLibraryMainPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.mainPage = this.createMainPage();
                arrayList.add((Object)this.mainPage);
            }
            super.getNewWizardPages(arrayList);
            for (IWizardPage iWizardPage2 : arrayList) {
                super.addPage(iWizardPage2);
            }
            this.wizardExtender.initWizardPages(arrayList);
        }
    }

    protected OpenLibraryMainPage createMainPage() {
        return new OpenLibraryMainPage();
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(LibraryUIPlugin.getDefault().getSharedImage("full/obj16/MethodLibrary.gif"));
    }

    public boolean performFinish() {
        if (this.wizardExtender != null) {
            return this.wizardExtender.doFinish();
        }
        return this.openMethodLibrary(this.mainPage.getLibraryPath(), "xmi");
    }

    public boolean openMethodLibrary(String string, String string2) {
        block12: {
            Object object;
            block13: {
                block10: {
                    block11: {
                        try {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            object = new File(string);
                            hashMap.put("library.path", ((File)object).getAbsolutePath());
                            if (XMILibraryUtil.isValidLibrary((String)string, (boolean)true) != Status.OK_STATUS) break block10;
                            if (OpenLibraryWizard.handleToolVersion(string, null)) break block11;
                            return false;
                        }
                        catch (Exception exception) {
                            object = exception.getMessage();
                            if (object == null) {
                                object = LibraryUIResources.openLibraryInternlError_reason;
                            }
                            object = String.valueOf(object) + "\n\n" + LibraryUIResources.openLibraryError_advice;
                            if (exception.getMessage() != null) {
                                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.openLibraryError_msg, (String)object);
                            } else {
                                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.openLibraryError_msg, (String)object, (Throwable)exception);
                            }
                            return false;
                        }
                    }
                    if (LibraryUIManager.getInstance().openLibrary(string)) {
                        LibraryUIPreferences.addOpenLibraryPath(((File)object).getAbsolutePath());
                        return true;
                    }
                    break block12;
                }
                if (XMILibraryUtil.containsPluginOrConfigSpecExportFile((String)string)) {
                    throw new Exception(LibraryUIResources.openLibraryError_reason4);
                }
                MsgDialog msgDialog = LibraryUIPlugin.getDefault().getMsgDialog();
                boolean bl = msgDialog.displayConfirmation(LibraryUIResources.openLibraryWizard_title, NLS.bind((String)LibraryUIResources.openLibraryDialog_newLibrary_text, (Object[])new Object[]{string}));
                if (bl) break block13;
                return false;
            }
            if (!LibraryUIManager.getInstance().createLibrary(string)) break block12;
            LibraryUIPreferences.addOpenLibraryPath(((File)object).getAbsolutePath());
            return true;
        }
        return true;
    }

    public static boolean handleToolVersion(String string, UpgradeCallerInfo upgradeCallerInfo) {
        VersionUtil.VersionCheckInfo versionCheckInfo;
        String string2 = "library.xmi";
        if (upgradeCallerInfo != null && upgradeCallerInfo.getIsExportedPluginLib()) {
            string2 = "export.xmi";
        }
        if ((versionCheckInfo = VersionUtil.checkLibraryVersion((File)new File(string, string2))) != null && versionCheckInfo.result > 0) {
            String string3 = "";
            string3 = versionCheckInfo.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)LibraryUIResources.versionMismatchDialog_text, (Object[])new Object[]{Platform.getProduct().getName(), versionCheckInfo.toolVersion}) : NLS.bind((String)LibraryUIResources.versionMismatchDialog_text_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
            if (!OpenLibraryWizard.isUpgradeLibrary(upgradeCallerInfo)) {
                upgradeCallerInfo.setErrorMsg(string3);
                return false;
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, string3);
            return false;
        }
        if (XMILibraryUtil.isMethodLibraryUpgradeRequired((String)string, (String)string2, (VersionUtil.VersionCheckInfo)versionCheckInfo)) {
            if (OpenLibraryWizard.isUpgradeLibrary(upgradeCallerInfo) && !LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.upgradeLibraryDialog_text)) {
                return false;
            }
            if (!OpenLibraryWizard.isUpgradeLibrary(upgradeCallerInfo)) {
                upgradeCallerInfo.copyLibrary();
                if (upgradeCallerInfo.getCopiedLibFile() != null) {
                    string = upgradeCallerInfo.getCopiedLibFile().getParentFile().getAbsolutePath();
                }
            }
            if (!LibraryUIManager.upgradeLibrary(string, upgradeCallerInfo)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isUpgradeLibrary(UpgradeCallerInfo upgradeCallerInfo) {
        return UpgradeCallerInfo.isUpgradeLibrary((UpgradeCallerInfo)upgradeCallerInfo);
    }
}

