/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.add.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.add.part.DiagramVisualIDRegistry;
import org.eclipse.epf.diagram.add.providers.DiagramElementTypes;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class ActivityDetailDiagramCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    private Collection myLinkDescriptors = new LinkedList();
    private Map myEObject2ViewMap = new HashMap();

    public EObject getSemanticHost() {
        return this.host().getModel() != null ? super.getSemanticHost() : null;
    }

    protected void refreshOnActivate() {
        super.refreshOnActivate();
        EditPart editPart = this.getHost();
        if (editPart instanceof DiagramEditPart) {
            DiagramEditorUtil.initializeOnActivate((DiagramEditPart)((DiagramEditPart)editPart));
        }
    }

    protected List getSemanticChildrenList() {
        LinkedList<EObject> linkedList = new LinkedList<EObject>();
        EObject eObject = ((View)this.getHost().getModel()).getElement();
        View view = (View)this.getHost().getModel();
        for (EObject eObject2 : ((NodeContainer)eObject).getNodes()) {
            int n = DiagramVisualIDRegistry.getNodeVisualID(view, eObject2);
            switch (n) {
                case 1001: {
                    linkedList.add(eObject2);
                    break;
                }
                case 1002: {
                    linkedList.add(eObject2);
                }
            }
        }
        return linkedList;
    }

    protected boolean shouldDeleteView(View view) {
        return view.isSetElement() && view.getElement() != null && (view.getElement().eIsProxy() || view.getElement() instanceof Node);
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    private static void getConnections(Collection collection, NodeContainer nodeContainer) {
        for (Node node : nodeContainer.getNodes()) {
            collection.addAll(node.getOutgoingConnections());
            if (!(node instanceof NodeContainer)) continue;
            ActivityDetailDiagramCanonicalEditPolicy.getConnections(collection, (NodeContainer)node);
        }
    }

    protected List getSemanticConnectionsList() {
        ActivityDetailDiagram activityDetailDiagram = (ActivityDetailDiagram)((View)this.getHost().getModel()).getElement();
        ArrayList arrayList = new ArrayList();
        ActivityDetailDiagramCanonicalEditPolicy.getConnections(arrayList, (NodeContainer)activityDetailDiagram);
        return arrayList;
    }

    protected EObject getSourceElement(EObject eObject) {
        if (eObject instanceof Link) {
            return ((Link)eObject).getSource();
        }
        return null;
    }

    protected EObject getTargetElement(EObject eObject) {
        if (eObject instanceof Link) {
            return ((Link)eObject).getTarget();
        }
        return null;
    }

    protected boolean shouldIncludeConnection(Edge edge, Collection collection) {
        return super.shouldIncludeConnection(edge, collection);
    }

    protected void refreshSemantic() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.refreshSemanticChildren());
        LinkedList linkedList2 = new LinkedList();
        linkedList2.addAll(this.refreshSemanticConnections());
        linkedList2.addAll(this.refreshConnections());
        linkedList.addAll(linkedList2);
        this.makeViewsImmutable(linkedList);
    }

    private Collection refreshConnections() {
        try {
            this.collectAllLinks((View)this.getDiagram());
            LinkedList linkedList = new LinkedList(this.getDiagram().getEdges());
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                EObject eObject = edge.getElement();
                EObject eObject2 = edge.getSource().getElement();
                EObject eObject3 = edge.getTarget().getElement();
                int n = DiagramVisualIDRegistry.getVisualID((View)edge);
                Iterator iterator2 = this.myLinkDescriptors.iterator();
                while (iterator2.hasNext()) {
                    LinkDescriptor linkDescriptor = (LinkDescriptor)iterator2.next();
                    if (eObject != linkDescriptor.getLinkElement() || eObject2 != linkDescriptor.getSource() || eObject3 != linkDescriptor.getDestination() || n != linkDescriptor.getVisualID()) continue;
                    iterator.remove();
                    iterator2.remove();
                }
            }
            this.deleteViews(linkedList.iterator());
            Collection collection = this.createConnections(this.myLinkDescriptors);
            return collection;
        }
        finally {
            this.myLinkDescriptors.clear();
            this.myEObject2ViewMap.clear();
        }
    }

    private void collectAllLinks(View view) {
        EObject eObject = view.getElement();
        int n = DiagramVisualIDRegistry.getVisualID(view);
        switch (n) {
            case 79: 
            case 1001: 
            case 1002: 
            case 2001: 
            case 2002: 
            case 2003: {
                this.myEObject2ViewMap.put(eObject, view);
                this.storeLinks(eObject, this.getDiagram());
            }
        }
        for (View view2 : view.getChildren()) {
            this.collectAllLinks(view2);
        }
    }

    private Collection createConnections(Collection collection) {
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<IAdaptable> linkedList = new LinkedList<IAdaptable>();
        for (LinkDescriptor linkDescriptor : collection) {
            EditPart editPart = this.getEditPartFor(linkDescriptor.getSource());
            EditPart editPart2 = this.getEditPartFor(linkDescriptor.getDestination());
            if (editPart == null || editPart2 == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor connectionViewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(linkDescriptor.getSemanticAdapter(), null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest createConnectionViewRequest = new CreateConnectionViewRequest(connectionViewDescriptor);
            createConnectionViewRequest.setType((Object)"connection start");
            createConnectionViewRequest.setSourceEditPart(editPart);
            editPart.getCommand((Request)createConnectionViewRequest);
            createConnectionViewRequest.setTargetEditPart(editPart2);
            createConnectionViewRequest.setType((Object)"connection end");
            Command command = editPart2.getCommand((Request)createConnectionViewRequest);
            if (command == null || !command.canExecute()) continue;
            this.executeCommand(command);
            IAdaptable iAdaptable = (IAdaptable)createConnectionViewRequest.getNewObject();
            if (iAdaptable == null) continue;
            linkedList.add(iAdaptable);
        }
        return linkedList;
    }

    private EditPart getEditPartFor(EObject eObject) {
        View view = (View)this.myEObject2ViewMap.get(eObject);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private void storeLinks(EObject eObject, Diagram diagram) {
        EClass eClass = eObject.eClass();
        this.storeFeatureModelFacetLinks(eObject, eClass, diagram);
        this.storeTypeModelFacetLinks(eObject, eClass);
    }

    private void storeTypeModelFacetLinks(EObject eObject, EClass eClass) {
        this.storeTypeModelFacetLinks_Link_3001(eObject, eClass);
    }

    private void storeTypeModelFacetLinks_Link_3001(EObject eObject, EClass eClass) {
        if (ModelPackage.eINSTANCE.getNode().isSuperTypeOf(eClass)) {
            for (EObject eObject2 : ((Node)eObject).getOutgoingConnections()) {
                Node node;
                int n = DiagramVisualIDRegistry.getLinkWithClassVisualID(eObject2);
                if (3001 != n || !((node = ((Link)eObject2).getTarget()) instanceof EObject)) continue;
                EObject eObject3 = (EObject)node;
                node = ((Link)eObject2).getSource();
                if (!(node instanceof EObject)) continue;
                EObject eObject4 = (EObject)node;
                this.myLinkDescriptors.add(new LinkDescriptor(eObject4, eObject3, eObject2, DiagramElementTypes.Link_3001, n));
            }
        }
    }

    private void storeFeatureModelFacetLinks(EObject eObject, EClass eClass, Diagram diagram) {
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private class LinkDescriptor {
        private EObject mySource;
        private EObject myDestination;
        private EObject myLinkElement;
        private int myVisualID;
        private IAdaptable mySemanticAdapter;

        protected LinkDescriptor(EObject eObject, EObject eObject2, EObject eObject3, IElementType iElementType, int n) {
            this(eObject, eObject2, n);
            this.myLinkElement = eObject3;
            final IElementType iElementType2 = iElementType;
            this.mySemanticAdapter = new EObjectAdapter(eObject3){

                public Object getAdapter(Class clazz) {
                    if (IElementType.class.equals((Object)clazz)) {
                        return iElementType2;
                    }
                    return super.getAdapter(clazz);
                }
            };
        }

        protected LinkDescriptor(EObject eObject, EObject eObject2, IElementType iElementType, int n) {
            this(eObject, eObject2, n);
            this.myLinkElement = null;
            final IElementType iElementType2 = iElementType;
            this.mySemanticAdapter = new IAdaptable(){

                public Object getAdapter(Class clazz) {
                    if (IElementType.class.equals((Object)clazz)) {
                        return iElementType2;
                    }
                    return null;
                }
            };
        }

        private LinkDescriptor(EObject eObject, EObject eObject2, int n) {
            this.mySource = eObject;
            this.myDestination = eObject2;
            this.myVisualID = n;
        }

        protected EObject getSource() {
            return this.mySource;
        }

        protected EObject getDestination() {
            return this.myDestination;
        }

        protected EObject getLinkElement() {
            return this.myLinkElement;
        }

        protected int getVisualID() {
            return this.myVisualID;
        }

        protected IAdaptable getSemanticAdapter() {
            return this.mySemanticAdapter;
        }
    }
}

