/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.add.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.part.DiagramCreationWizardPage;
import org.eclipse.epf.diagram.add.part.DiagramDiagramEditorUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DiagramCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected DiagramCreationWizardPage diagramModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean bl) {
        this.openNewlyCreatedDiagramEditor = bl;
    }

    public void addPages() {
        this.diagramModelFilePage = new DiagramCreationWizardPage("DiagramModelFile", this.getSelection(), "xmi");
        this.diagramModelFilePage.setTitle("Create ADD Diagram");
        this.diagramModelFilePage.setDescription("Select file that will contain diagram and domain models.");
        this.addPage((IWizardPage)this.diagramModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
                DiagramCreationWizard.this.diagram = DiagramDiagramEditorUtil.createDiagram(DiagramCreationWizard.this.diagramModelFilePage.getURI(), iProgressMonitor);
                if (DiagramCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && DiagramCreationWizard.this.diagram != null) {
                    try {
                        DiagramDiagramEditorUtil.openDiagram(DiagramCreationWizard.this.diagram);
                    }
                    catch (PartInitException partInitException) {
                        ErrorDialog.openError((Shell)DiagramCreationWizard.this.getContainer().getShell(), (String)"Error opening diagram editor", null, (IStatus)partInitException.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Creation Problems", null, (IStatus)((CoreException)invocationTargetException.getTargetException()).getStatus());
            } else {
                ActivityDetailDiagramEditorPlugin.getInstance().logError("Error creating diagram", invocationTargetException.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setWindowTitle("New ADD Diagram");
        this.setDefaultPageImageDescriptor(ActivityDetailDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewModelWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }
}

