/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.common.service.versioning.EPFVersions;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.refresh.internal.RefreshEvent;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUtil {
    public static final String getUMANsURI() {
        return "http://www.eclipse.org/epf/uma/1.0.4/uma.ecore";
    }

    public static final String getUMANsURI(String string) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new File(string));
            Element element = document.getDocumentElement();
            String string2 = element.getAttribute("xmlns:com.ibm.uma");
            if (string2 == null || string2.equals("")) {
                string2 = element.getAttribute("xmlns:org.eclipse.epf.uma");
            }
            if (string2 == null || string2.equals("")) {
                string2 = String.valueOf(element.getAttribute("xmlns:uma")) + "/uma.ecore";
            }
            return string2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static final boolean conversionRequired(String string) {
        String string2;
        String string3 = PersistenceUtil.getUMANsURI();
        if (string3.equals(string2 = PersistenceUtil.getUMANsURI(string))) {
            return false;
        }
        return "http:///com/ibm/uma.ecore".equals(string2);
    }

    public static final IResource getWorkspaceResource(Object object) {
        Resource resource = null;
        if (object instanceof DescribableElement) {
            DescribableElement describableElement = (DescribableElement)object;
            ContentDescription contentDescription = describableElement.getPresentation();
            resource = contentDescription.eResource();
            if (resource == null) {
                resource = describableElement.eResource();
            }
        } else if (object instanceof EObject) {
            resource = ((EObject)object).eResource();
        } else if (object instanceof Resource) {
            resource = (Resource)object;
        }
        if (resource != null && resource.getURI().isFile()) {
            return FileManager.getResourceForLocation(resource.getURI().toFileString());
        }
        return null;
    }

    public static final Collection<EObject> getProxies(EObject eObject) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject2 = (EObject)treeIterator.next();
            if (!eObject2.eIsProxy()) continue;
            arrayList.add(eObject2);
        }
        return arrayList;
    }

    public static final int checkToolVersion(Resource resource) {
        String string;
        File file = new File(resource.getURI().toFileString());
        Map map = VersionUtil.readVersionsFromFile((File)file);
        if (map != null && (string = (String)map.get(VersionUtil.getPrimaryToolID())) != null) {
            EPFVersions ePFVersions = VersionUtil.getVersions((String)VersionUtil.getPrimaryToolID());
            return ePFVersions.getCurrentVersion().compareToolVersionTo(new Version(string));
        }
        return -1;
    }

    public static MethodElement getMethodElement(Resource resource) {
        for (Object e : resource.getContents()) {
            if (!(e instanceof MethodElement)) continue;
            return (MethodElement)e;
        }
        return null;
    }

    public static EObject resolve(EObject eObject, ResourceSet resourceSet) {
        EObject eObject2;
        try {
            eObject2 = EcoreUtil.resolve((EObject)eObject, (ResourceSet)resourceSet);
        }
        catch (Exception exception) {
            eObject2 = eObject;
        }
        EObject eObject3 = eObject.eContainer();
        if (eObject2.eContainer() == null && eObject3 != null) {
            EReference eReference;
            if (eObject3.eIsProxy()) {
                eObject3 = PersistenceUtil.resolve(eObject3, resourceSet);
            }
            if ((eReference = eObject.eContainmentFeature()).isMany()) {
                List list = (List)eObject3.eGet((EStructuralFeature)eReference);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            } else {
                eObject3.eGet((EStructuralFeature)eReference);
            }
        }
        return eObject2;
    }

    public static Resource getResource(IPath iPath, ResourceSet resourceSet) {
        return PersistenceUtil.getResource(iPath.toOSString(), resourceSet);
    }

    public static Resource getResource(String string, ResourceSet resourceSet) {
        URI uRI = URI.createFileURI((String)string);
        for (Resource resource : new ArrayList(resourceSet.getResources())) {
            if (!uRI.equals((Object)MultiFileSaveUtil.getFinalURI(resource))) continue;
            return resource;
        }
        return null;
    }

    public static void resolveContainer(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet instanceof MultiFileResourceSetImpl) {
            ((MultiFileResourceSetImpl)resourceSet).resolveContainer(resource);
        }
    }

    public static MethodElement getMethodElement(IResource iResource, ResourceSet resourceSet) {
        MethodElement methodElement = null;
        URI uRI = URI.createFileURI((String)iResource.getLocation().toOSString());
        Resource resource = resourceSet.getResource(uRI, true);
        if (resource != null) {
            EObject eObject;
            if (resourceSet instanceof MultiFileResourceSetImpl) {
                ((MultiFileResourceSetImpl)resourceSet).resolveContainer(resource);
            }
            if ((methodElement = PersistenceUtil.getMethodElement(resource)) instanceof ContentDescription && (eObject = ((ContentDescription)methodElement).eContainer()) instanceof MethodElement) {
                methodElement = (MethodElement)eObject;
            }
        }
        return methodElement;
    }

    public static void loadAllLibraryResources(MethodLibrary methodLibrary) {
        TreeIterator treeIterator = methodLibrary.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (!(eObject instanceof MethodElement)) continue;
            try {
                Iterator iterator = eObject.eCrossReferences().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            catch (Exception exception) {
                CommonPlugin.INSTANCE.log((Object)exception);
            }
        }
    }

    public static String getTopAttribute(File file, final String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            final String[] stringArray = new String[1];
            try {
                sAXParser.parse(file, new DefaultHandler(){
                    private boolean started;

                    public void startElement(String string4, String string2, String string3, Attributes attributes) throws SAXException {
                        if (this.started) {
                            throw new OperationCanceledException();
                        }
                        stringArray[0] = attributes.getValue(string);
                        this.started = true;
                    }
                });
            }
            catch (OperationCanceledException operationCanceledException) {}
            return stringArray[0];
        }
        catch (Exception exception) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
            return null;
        }
    }

    public static void unload(Collection<Resource> collection) {
        HashMap<MultiFileResourceSetImpl, ArrayList<Resource>> hashMap = new HashMap<MultiFileResourceSetImpl, ArrayList<Resource>>();
        for (Resource object : collection) {
            ResourceSet resourceSet = object.getResourceSet();
            boolean bl = false;
            try {
                if (resourceSet instanceof ILibraryResourceSet) {
                    if (((ILibraryResourceSet)resourceSet).unload(object, Collections.EMPTY_MAP)) {
                        resourceSet.getResources().remove((Object)object);
                        bl = true;
                    }
                } else {
                    if (object.isLoaded()) {
                        object.unload();
                        bl = true;
                    }
                    if (resourceSet != null) {
                        resourceSet.getResources().remove((Object)object);
                    }
                }
            }
            catch (Exception exception) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
            }
            if (!bl || !(resourceSet instanceof MultiFileResourceSetImpl)) continue;
            ArrayList<Resource> arrayList = (ArrayList<Resource>)hashMap.get(resourceSet);
            if (arrayList == null) {
                arrayList = new ArrayList<Resource>();
                hashMap.put((MultiFileResourceSetImpl)resourceSet, arrayList);
            }
            arrayList.add(object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ((MultiFileResourceSetImpl)entry.getKey()).notifyRefreshListeners(new RefreshEvent((Collection)entry.getValue()));
        }
    }

    public static boolean hasDuplicateGUID(MethodElement methodElement, Collection<MethodElement> collection) {
        for (MethodElement methodElement2 : collection) {
            if (!methodElement.getGuid().equals(methodElement2.getGuid())) continue;
            return true;
        }
        return false;
    }

    private static String toPrefix(String string) {
        return string.endsWith(File.separator) ? string : String.valueOf(string) + File.separator;
    }

    public static void replaceURIPrefix(Collection<Resource> collection, String string, String string2) {
        URI uRI = URI.createFileURI((String)PersistenceUtil.toPrefix(string));
        URI uRI2 = URI.createFileURI((String)PersistenceUtil.toPrefix(string2));
        for (Resource resource : collection) {
            URI uRI3 = resource.getURI();
            URI uRI4 = null;
            try {
                uRI4 = uRI3.replacePrefix(uRI, uRI2);
            }
            catch (Exception exception) {}
            if (uRI4 == null) continue;
            resource.setURI(uRI4);
        }
    }

    public static URI getProxyURI(EObject eObject) {
        Resource resource = eObject.eResource();
        URI uRI = null;
        if (resource instanceof ILibraryResource) {
            ILibraryResource iLibraryResource = (ILibraryResource)resource;
            uRI = iLibraryResource.getProxyURI(eObject);
        } else {
            uRI = resource.getURI().appendFragment(resource.getURIFragment(eObject));
        }
        return uRI;
    }

    public static void main(String[] stringArray) {
        String string = PersistenceUtil.getTopAttribute(new File(stringArray[0]), stringArray[1]);
        System.out.println(string);
    }
}

