/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.epf.authoring.gef.util.Validation;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.gef.commands.Command;

public class DeleteCommand
extends Command {
    private Command delegate;
    private static final String LABEL = AuthoringUIResources.gef_deleteCommand_label;
    public static final String KEY_PERM_DELETE = "gef.ediagram.$perm";

    public DeleteCommand(boolean bl) {
        super(LABEL);
    }

    public boolean canExecute() {
        return this.delegate != null && this.delegate.canExecute();
    }

    public void execute() {
        this.delegate.execute();
    }

    public Command setPartToBeDeleted(Object object) {
        this.delegate = object instanceof Node ? new DeleteNodeCommand(object) : null;
        return this;
    }

    public void undo() {
        this.delegate.undo();
    }

    private static class DeleteNodeCommand
    extends Command {
        protected Map incomingConnectionsToSource;
        protected Map outgoingConnectionsToTarget;
        protected NodeContainer container;
        protected Node node;
        protected int index;

        public DeleteNodeCommand(Object object) {
            this.node = (Node)object;
            this.container = (NodeContainer)this.node.eContainer();
        }

        public void execute() {
            this.index = this.container.getNodes().indexOf((Object)this.node);
            if (this.index == -1) {
                return;
            }
            this.incomingConnectionsToSource = new HashMap();
            this.outgoingConnectionsToTarget = new HashMap();
            for (Link link : this.node.getOutgoingConnections()) {
                this.outgoingConnectionsToTarget.put(link, link.getTarget());
                link.setTarget(null);
            }
            for (Link link : this.node.getIncomingConnections()) {
                this.incomingConnectionsToSource.put(link, link.getSource());
                link.setSource(null);
            }
            this.container.getNodes().remove(this.index);
        }

        public void undo() {
            if (this.index == -1) {
                return;
            }
            this.container.getNodes().add(this.index, (Object)this.node);
            for (Link link : this.outgoingConnectionsToTarget.keySet()) {
                link.setTarget((Node)this.outgoingConnectionsToTarget.get(link));
                link.setSource(this.node);
            }
            for (Link link : this.incomingConnectionsToSource.keySet()) {
                link.setTarget(this.node);
                link.setSource((Node)this.incomingConnectionsToSource.get(link));
            }
            this.outgoingConnectionsToTarget = null;
            this.incomingConnectionsToSource = null;
        }

        public boolean canExecute() {
            if (Validation.checkDelete(this.node) != null) {
                return false;
            }
            return super.canExecute();
        }
    }
}

