/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.epf.authoring.gef.commands.DeleteLinkCommand;
import org.eclipse.epf.authoring.gef.edit.policies.LinkBendpointEditPolicy;
import org.eclipse.epf.authoring.gef.edit.policies.LinkEndpointEditPolicy;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.authoring.gef.util.Validation;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class LinkEditPart
extends AbstractConnectionEditPart {
    protected Adapter modelListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            LinkEditPart.this.handlePropertyChanged(notification);
        }
    };

    public LinkEditPart(Link link) {
        this.setModel(link);
    }

    public void activate() {
        super.activate();
        this.getLink().eAdapters().add((Object)this.modelListener);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new LinkEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest groupRequest) {
                Boolean bl = (Boolean)groupRequest.getExtendedData().get("gef.ediagram.$perm");
                boolean bl2 = bl == null ? false : bl;
                return new DeleteLinkCommand((Link)this.getHost().getModel(), bl2);
            }
        });
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new LinkBendpointEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection polylineConnection = new PolylineConnection();
        polylineConnection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        this.updateAppearance();
        return polylineConnection;
    }

    private void updateAppearance() {
        if (this.figure == null) {
            return;
        }
        Link link = (Link)this.getModel();
        if (Validation.isReadOnly(link)) {
            this.figure.setForegroundColor(Colors.INHERITED_ELEMENT_LABEL);
        } else {
            this.figure.setForegroundColor(ColorConstants.black);
        }
    }

    public void deactivate() {
        this.getLink().eAdapters().remove((Object)this.modelListener);
        super.deactivate();
    }

    protected Link getLink() {
        return (Link)this.getModel();
    }

    protected void handlePropertyChanged(Notification notification) {
        switch (notification.getFeatureID(Link.class)) {
            case 4: {
                this.refreshVisuals();
                break;
            }
            case 6: {
                this.refreshTargetAnchor();
                break;
            }
            case 5: {
                this.refreshSourceAnchor();
            }
        }
    }

    protected void refreshVisuals() {
        this.updateAppearance();
        this.getConnectionFigure().setRoutingConstraint((Object)this.getLink().getBendpoints());
    }
}

