/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.epf.authoring.gef.edit.ClosestAnchor;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.edit.RelativeXYAnchor;
import org.eclipse.epf.authoring.gef.util.ConnectionAnchorLocator;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.swt.graphics.Color;

public class SynchBarNodeEditPart
extends NodeEditPart
implements ConnectionAnchorLocator {
    private static final Color BG_COLOR = new Color(null, 51, 102, 102);
    private Point recentTargetEndPoint;
    private Point recentSourceEndPoint;

    public SynchBarNodeEditPart(TypedNode typedNode) {
        super((Node)typedNode);
    }

    protected DirectEditPolicy createDirectEditPolicy() {
        return null;
    }

    protected IFigure createFigure() {
        RectangleFigure rectangleFigure = new RectangleFigure();
        rectangleFigure.setBackgroundColor(BG_COLOR);
        rectangleFigure.setSize(100, 5);
        return rectangleFigure;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connectionEditPart) {
        boolean bl = false;
        Point point = null;
        if (this.recentSourceEndPoint == null) {
            Link link = (Link)connectionEditPart.getModel();
            point = link.getSourceEndPoint();
            bl = true;
        } else {
            point = this.recentSourceEndPoint;
        }
        if (point != null) {
            return new RelativeXYAnchor(this.getFigure(), point, bl);
        }
        return super.getSourceConnectionAnchor(connectionEditPart);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point point = null;
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            point = createConnectionRequest.getLocation();
        } else if (request instanceof LocationRequest) {
            point = ((LocationRequest)request).getLocation();
        }
        if (point != null) {
            this.recentSourceEndPoint = this.getLocation(point);
            return new RelativeXYAnchor(this.getFigure(), this.recentSourceEndPoint, true);
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connectionEditPart) {
        boolean bl = false;
        Point point = null;
        if (this.recentTargetEndPoint == null) {
            Link link = (Link)connectionEditPart.getModel();
            point = link.getTargetEndPoint();
            bl = true;
        } else {
            point = this.recentTargetEndPoint;
        }
        if (point != null) {
            return new RelativeXYAnchor(this.getFigure(), point, bl);
        }
        return super.getTargetConnectionAnchor(connectionEditPart);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point point = null;
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            point = createConnectionRequest.getLocation();
        } else if (request instanceof LocationRequest) {
            point = ((LocationRequest)request).getLocation();
        }
        if (point != null) {
            this.recentTargetEndPoint = this.getLocation(point);
            return new RelativeXYAnchor(this.getFigure(), this.recentTargetEndPoint, true);
        }
        return super.getTargetConnectionAnchor(request);
    }

    public Point getLocation(Point point) {
        return ClosestAnchor.getLocation(this.getFigure(), point);
    }
}

