/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.RoleNode;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProductDescriptor;

public final class Validation {
    private static final String errMsg_CanNotConnect = AuthoringUIResources.DiagramValidation_err_cannot_connect_text;
    private static final String errMsg_SamePredAndSucc = AuthoringUIResources.DiagramValidation_err_samepredandsuc_text;
    private static final String errMsg_CanNotDelete = AuthoringUIResources.DiagramValidation_err_cannot_delete_text;

    public static String checkConnect(Node node, Node node2) {
        if (node.getDiagram() != node2.getDiagram()) {
            return AuthoringUIResources.DiagramValidation_err_cannot_connect_text;
        }
        if (node.getDiagram() instanceof ActivityDiagram) {
            Object object;
            ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            Object object2 = composedAdapterFactory.adapt(node.getDiagram().getObject(), ITreeItemContentProvider.class);
            Object object3 = null;
            if (object2 instanceof IBSItemProvider) {
                object3 = ((IBSItemProvider)object2).getTopItem();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object4 = new AdapterFactoryTreeIterator((AdapterFactory)composedAdapterFactory, object3);
            while (object4.hasNext()) {
                object = object4.next();
                arrayList.add(TngUtil.unwrap(object));
            }
            if (object3 != null) {
                if (node2.getDiagram().isReadOnly()) {
                    return errMsg_CanNotConnect;
                }
                if (node.getObject() instanceof WorkBreakdownElement) {
                    if (node2.getObject() instanceof WorkBreakdownElement) {
                        if (ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)node2.getObject()), (WorkBreakdownElement)((WorkBreakdownElement)node.getObject()), arrayList)) {
                            return errMsg_SamePredAndSucc;
                        }
                        if (node2.isReadOnly()) {
                            return errMsg_CanNotConnect;
                        }
                    } else if (node2 instanceof TypedNode) {
                        if (((TypedNode)node2).getType() == 3 || ((TypedNode)node2).getType() == 6) {
                            return errMsg_CanNotConnect;
                        }
                        object4 = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)node2), WorkBreakdownElementNode.class);
                        object = (WorkBreakdownElement)node.getObject();
                        Iterator iterator = object4.iterator();
                        while (iterator.hasNext()) {
                            Node node3 = (Node)iterator.next();
                            if (node3.isReadOnly()) {
                                return errMsg_CanNotConnect;
                            }
                            if (!ProcessUtil.checkCircular((WorkBreakdownElement)((WorkBreakdownElement)node3.getObject()), object, arrayList)) continue;
                            return errMsg_SamePredAndSucc;
                        }
                    }
                } else if (node instanceof TypedNode) {
                    if (node2 == node) {
                        return errMsg_CanNotConnect;
                    }
                    if (((TypedNode)node).getType() == 4 || ((TypedNode)node).getType() == 6) {
                        return errMsg_CanNotConnect;
                    }
                    if (node2 instanceof TypedNode) {
                        if (Validation.checkSyncBarCircularLooop((TypedNode)node, (TypedNode)node2) != null) {
                            return errMsg_CanNotConnect;
                        }
                        if (((TypedNode)node2).getType() == 3 || ((TypedNode)node2).getType() == 6) {
                            return errMsg_CanNotConnect;
                        }
                        object4 = GraphicalDataHelper.getSourceNodes((TypedNode)((TypedNode)node), WorkBreakdownElementNode.class);
                        if (!object4.isEmpty()) {
                            object = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)node2), WorkBreakdownElementNode.class);
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                Node node4 = (Node)iterator.next();
                                if (node4.isReadOnly()) {
                                    return errMsg_CanNotConnect;
                                }
                                WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)node4.getObject();
                                Iterator iterator2 = object4.iterator();
                                while (iterator2.hasNext()) {
                                    WorkBreakdownElement workBreakdownElement2 = (WorkBreakdownElement)((Node)iterator2.next()).getObject();
                                    if (!ProcessUtil.checkCircular((WorkBreakdownElement)workBreakdownElement, (WorkBreakdownElement)workBreakdownElement2, arrayList)) continue;
                                    return errMsg_SamePredAndSucc;
                                }
                            }
                        }
                    } else if (node2 instanceof WorkBreakdownElementNode) {
                        if (node2.isReadOnly()) {
                            return errMsg_CanNotConnect;
                        }
                        object4 = GraphicalDataHelper.getSourceNodes((TypedNode)((TypedNode)node), WorkBreakdownElementNode.class);
                        object = (WorkBreakdownElement)node2.getObject();
                        Iterator iterator = object4.iterator();
                        while (iterator.hasNext()) {
                            WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)((Node)iterator.next()).getObject();
                            if (!ProcessUtil.checkCircular((WorkBreakdownElement)object, (WorkBreakdownElement)workBreakdownElement, arrayList)) continue;
                            return errMsg_SamePredAndSucc;
                        }
                    }
                }
            }
        } else if (node.getDiagram() instanceof ActivityDetailDiagram) {
            if (node.isReadOnly() || node2.isReadOnly()) {
                return errMsg_CanNotConnect;
            }
            if (node.getObject() instanceof RoleDescriptor || node2.getObject() instanceof RoleDescriptor || node.getObject() instanceof TaskDescriptor && node2.getObject() instanceof TaskDescriptor || node.getObject() instanceof WorkProductDescriptor && node2.getObject() instanceof WorkProductDescriptor) {
                return errMsg_CanNotConnect;
            }
            for (Link link : node.getOutgoingConnections()) {
                if (link.getTarget() != node2) continue;
                return errMsg_CanNotConnect;
            }
        } else if (node.getDiagram() instanceof WorkProductDependencyDiagram && (node.isReadOnly() || node2.isReadOnly())) {
            return errMsg_CanNotConnect;
        }
        return null;
    }

    public static String checkDelete(Link link) {
        Node node = link.getSource();
        Node node2 = link.getTarget();
        if (node2 != null && node2.getDiagram() instanceof ActivityDetailDiagram) {
            return errMsg_CanNotDelete;
        }
        if (node2 != null && node2.getDiagram() instanceof ActivityDiagram) {
            if (node2 instanceof WorkBreakdownElementNode) {
                if (node instanceof WorkBreakdownElementNode) {
                    if (link.getTarget().isReadOnly()) {
                        return errMsg_CanNotDelete;
                    }
                    return null;
                }
                if (node instanceof TypedNode) {
                    TypedNode typedNode = (TypedNode)node;
                    if (!node2.isReadOnly()) {
                        return null;
                    }
                    if (typedNode.getType() == 2) {
                        return null;
                    }
                    if (typedNode.getType() == 1) {
                        return Validation.checkSyncBarIncomingLinks(typedNode);
                    }
                    if (typedNode.isReadOnly()) {
                        return errMsg_CanNotDelete;
                    }
                }
            } else if (node2 instanceof TypedNode) {
                TypedNode typedNode = (TypedNode)node2;
                if (typedNode.getType() == 2) {
                    return null;
                }
                if (node instanceof WorkBreakdownElementNode) {
                    if (Validation.checkSyncBarOutgoingLinks((TypedNode)node2) == null) {
                        return null;
                    }
                    if (node.isReadOnly()) {
                        return errMsg_CanNotDelete;
                    }
                }
                if (node instanceof TypedNode) {
                    TypedNode typedNode2 = (TypedNode)node;
                    if (typedNode2.getType() == 2) {
                        return null;
                    }
                    if (typedNode2.getType() == 1) {
                        return Validation.checkSyncBarIncomingLinks(typedNode2);
                    }
                }
            }
        }
        return null;
    }

    public static String checkDelete(Node node) {
        if (node.isReadOnly()) {
            return errMsg_CanNotDelete;
        }
        Diagram diagram = node.getDiagram();
        if (diagram instanceof ActivityDiagram) {
            if (node instanceof TypedNode) {
                Collection collection = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)node), WorkBreakdownElementNode.class);
                for (Node node2 : collection) {
                    if (!node2.isReadOnly()) continue;
                    return errMsg_CanNotDelete;
                }
            }
        } else if (diagram instanceof ActivityDetailDiagram && node instanceof RoleNode) {
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkReconnect(Node node, Node node2, Link link) {
        if (node.getDiagram() instanceof ActivityDiagram && link.getTarget() != null) {
            if (link.getTarget().isReadOnly()) {
                return errMsg_CanNotConnect;
            }
            if (link.getTarget() instanceof TypedNode) {
                Collection collection = GraphicalDataHelper.getTargetNodes((TypedNode)((TypedNode)link.getTarget()), WorkBreakdownElementNode.class);
                for (Node node3 : collection) {
                    if (!node3.isReadOnly()) continue;
                    return errMsg_CanNotConnect;
                }
            }
        }
        return Validation.checkConnect(node, node2, link);
    }

    public static String checkConnect(Node node, Node node2, Link link) {
        if (node == node2 && !(node.getObject() instanceof Activity)) {
            return errMsg_CanNotConnect;
        }
        EList eList = node.getOutgoingConnections();
        if (eList != null) {
            if (eList.contains(link) && link.getTarget().equals(node2)) {
                return null;
            }
            for (Link link2 : eList) {
                Node node3 = link2.getTarget();
                if (node3 == null || !node3.equals(node2)) continue;
                return errMsg_CanNotConnect;
            }
        }
        return Validation.checkConnect(node, node2);
    }

    public static String checkSyncBarCircularLooop(TypedNode typedNode, TypedNode typedNode2) {
        EList eList = typedNode2.getOutgoingConnections();
        if (!eList.isEmpty() && eList.size() > 0) {
            for (Link link : eList) {
                Node node = link.getTarget();
                if (typedNode.equals(node)) {
                    return errMsg_CanNotConnect;
                }
                if (!(node instanceof TypedNode)) continue;
                return Validation.checkSyncBarCircularLooop(typedNode, (TypedNode)node);
            }
        }
        return null;
    }

    public static String checkSyncBarIncomingLinks(TypedNode typedNode) {
        for (Link link : typedNode.getIncomingConnections()) {
            Node node = link.getSource();
            if (!(node instanceof WorkBreakdownElementNode ? node.isReadOnly() : node instanceof TypedNode && ((TypedNode)node).getType() == 1 && Validation.checkSyncBarIncomingLinks((TypedNode)node) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static String checkSyncBarOutgoingLinks(TypedNode typedNode) {
        for (Link link : typedNode.getOutgoingConnections()) {
            Node node = link.getTarget();
            if (!(node instanceof WorkBreakdownElementNode ? node.isReadOnly() : node instanceof TypedNode && ((TypedNode)node).getType() == 1 && Validation.checkSyncBarOutgoingLinks((TypedNode)node) != null)) continue;
            return errMsg_CanNotDelete;
        }
        return null;
    }

    public static boolean isReadOnly(Link link) {
        Node node = link.getTarget();
        Node node2 = link.getSource();
        if (node != null && node.getDiagram() instanceof ActivityDiagram) {
            return Validation.checkDelete(link) != null;
        }
        return node != null && node.getDiagram() instanceof ActivityDetailDiagram && (node2 != null && node2 instanceof TaskNode && node2.isReadOnly() || node instanceof TaskNode && node.isReadOnly());
    }
}

