/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.library.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class LibraryViewDeleteAction
extends MethodElementDeleteAction {
    public LibraryViewDeleteAction() {
        this(true);
    }

    public LibraryViewDeleteAction(boolean bl) {
        this.confirm = bl;
    }

    protected void didDelete(Collection collection) {
        super.didDelete(collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = TngUtil.unwrap(iterator.next());
            if (!(object instanceof MethodElement) || ((MethodElement)object).eContainer() != null) continue;
            IEditorKeeper.REFERENCE.getEditorKeeper().closeEditorsOnDeletion((MethodElement)object);
        }
    }

    protected static CustomCategory getRootCustomCategory(Object object) {
        while (object instanceof IWrapperItemProvider) {
            object = ((IWrapperItemProvider)object).getOwner();
        }
        return (object = TngUtil.unwrap((Object)object)) instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)object)) ? (CustomCategory)object : null;
    }

    public boolean updateSelection(IStructuredSelection iStructuredSelection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : iStructuredSelection) {
            Object object;
            CustomCategory customCategory;
            if (e instanceof CustomCategory) {
                arrayList.add(e);
                continue;
            }
            Object object2 = TngUtil.unwrap(e);
            if (object2 instanceof ItemProviderAdapter || object2 instanceof MethodElement && TngUtil.isPredefined((MethodElement)((MethodElement)object2))) continue;
            if (object2 instanceof CustomCategory) {
                customCategory = LibraryViewDeleteAction.getRootCustomCategory(e);
                object = (CustomCategory)object2;
                if (customCategory == null || UmaUtil.getMethodPlugin((EObject)customCategory) != UmaUtil.getMethodPlugin((EObject)object)) continue;
                arrayList.add(object2);
                continue;
            }
            if (e instanceof IWrapperItemProvider) {
                customCategory = (IWrapperItemProvider)e;
                if (TngUtil.isUnderCustomCategoryTree((IWrapperItemProvider)customCategory)) continue;
                if (customCategory.getFeature() == UmaPackage.Literals.DISCIPLINE_GROUPING__DISCIPLINES || customCategory.getFeature() == UmaPackage.Literals.ROLE_SET_GROUPING__ROLE_SETS) {
                    object = customCategory.getOwner();
                    if (!(object instanceof EObject) || !(object2 instanceof EObject) || UmaUtil.getMethodPlugin((EObject)((EObject)object)) != UmaUtil.getMethodPlugin((EObject)((EObject)object2))) continue;
                    arrayList.add(object2);
                    continue;
                }
            }
            arrayList.add(e);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        return super.updateSelection((IStructuredSelection)new StructuredSelection(arrayList));
    }

    protected void performDelete() {
        Object object;
        Object object3;
        Object object4;
        HashSet<ILibraryResourceSet> hashSet = new HashSet<ILibraryResourceSet>();
        HashSet<Resource> hashSet2 = new HashSet<Resource>();
        ILibraryPersister iLibraryPersister = LibraryServiceUtil.getCurrentPersister();
        if (this.selection != null && this.selection.size() > 0) {
            object4 = this.selection.iterator();
            while (object4.hasNext()) {
                EObject object22;
                object3 = TngUtil.unwrap(object4.next());
                if (object3 instanceof MethodConfiguration) {
                    hashSet.add((ILibraryResourceSet)object3);
                }
                if (!(object3 instanceof EObject) || iLibraryPersister.hasOwnResourceWithoutReferrer(object3) || (object22 = ((EObject)object3).eContainer()) == null || object22.eResource() == null) continue;
                hashSet2.add(object22.eResource());
            }
        }
        if (!hashSet.isEmpty()) {
            object4 = new HashSet();
            for (MethodConfiguration methodConfiguration : hashSet) {
                ((HashSet)object4).add(methodConfiguration.getGuid());
            }
            object3 = (ILibraryResourceSet)LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet();
            object3.loadOppositeFeatures(Collections.singletonList(AssociationHelper.MethodConfiguration_DependentProcesses), (Set)object4);
            for (MethodConfiguration methodConfiguration : hashSet) {
                object = AssociationHelper.getDependentProcesses((MethodConfiguration)methodConfiguration);
                if (object == null || object.size() <= 0) continue;
                String string = ((Process)object.get(0)).getName();
                AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AuthoringUIResources.deleteDialog_title, AuthoringUIResources.deleteConfigError_msg, AuthoringUIResources.bind((String)AuthoringUIResources.deleteConfigError_reason, (Object)string));
                return;
            }
        }
        if (!(object4 = UserInteractionHelper.checkModify(hashSet2, (Shell)MsgBox.getDefaultShell())).isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.deleteDialog_title, (IStatus)object4);
            return;
        }
        if (this.confirmDelete()) {
            Collection collection;
            object3 = new ArrayList();
            Iterator iterator = this.selection.iterator();
            while (iterator.hasNext()) {
                Object object2 = TngUtil.unwrap(iterator.next());
                if (!(object2 instanceof MethodElement) || !(object2 instanceof VariabilityElement)) continue;
                object = TngUtil.getGeneralizers((VariabilityElement)((VariabilityElement)object2));
                while (object.hasNext()) {
                    Object e = object.next();
                    object3.add(e);
                }
            }
            DeleteMethodElementCommand deleteMethodElementCommand = (DeleteMethodElementCommand)(this.command instanceof DeleteMethodElementCommand ? this.command : null);
            this.command.execute();
            if (deleteMethodElementCommand != null && (collection = deleteMethodElementCommand.getDescriptorsToDelete()) != null && !collection.isEmpty()) {
                ProcessDeleteAction.delete((Collection)collection);
            }
            if (object3.size() > 0) {
                TreeViewer treeViewer = (TreeViewer)LibraryView.getView().getViewer();
                object = object3.iterator();
                while (object.hasNext()) {
                    treeViewer.refresh(object.next());
                }
            }
        }
    }

    public void notifyPropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    public void filterCustomCategorySelection(Object object, List list) {
        if (object instanceof FeatureValueWrapperItemProvider) {
            list.add(object);
        } else {
            Object object2 = ((DelegatingWrapperItemProvider)object).getOwner();
            while (object2 instanceof DelegatingWrapperItemProvider) {
                if (object2 instanceof FeatureValueWrapperItemProvider) {
                    if (list.contains(object2)) break;
                    list.add(object);
                    break;
                }
                if (list.contains(object2)) break;
                if ((object2 = ((DelegatingWrapperItemProvider)object2).getOwner()) instanceof FeatureValueWrapperItemProvider || list.contains(object2)) continue;
                list.add(object);
                break;
            }
        }
    }
}

