/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.ElementHTMLViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PreviewPage {
    private ElementHTMLViewer previewer = null;

    public PreviewPage(Composite composite) {
        ViewForm viewForm = new ViewForm(composite, -1);
        viewForm.marginHeight = 0;
        viewForm.marginWidth = 0;
        viewForm.setLayout((Layout)new GridLayout());
        viewForm.setLayoutData((Object)new GridData(1808));
        ToolBar toolBar = this.createToolbar(viewForm);
        viewForm.setTopRight((Control)toolBar);
        Control control = this.createContent(viewForm);
        viewForm.setContent(control);
    }

    private Control createContent(ViewForm viewForm) {
        Composite composite = new Composite((Composite)viewForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.previewer = new ElementHTMLViewer(composite);
        return composite;
    }

    public ElementHTMLViewer getPreviewViewer() {
        return this.previewer;
    }

    private ToolBar createToolbar(ViewForm viewForm) {
        ToolBar toolBar = new ToolBar((Composite)viewForm, 0x800000);
        ToolItem toolItem = new ToolItem(toolBar, 0);
        toolItem.setImage(AuthoringUIImages.IMG_BACK);
        toolItem.setToolTipText(AuthoringUIResources.backButton_text);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Browser browser = PreviewPage.this.previewer.getBrowser();
                if (browser != null) {
                    browser.back();
                }
            }
        });
        ToolItem toolItem2 = new ToolItem(toolBar, 0);
        toolItem2.setImage(AuthoringUIImages.IMG_FORWARD);
        toolItem2.setToolTipText(AuthoringUIResources.forwardButton_text);
        toolItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Browser browser = PreviewPage.this.previewer.getBrowser();
                if (browser != null) {
                    browser.forward();
                }
            }
        });
        ToolItem toolItem3 = new ToolItem(toolBar, 0);
        toolItem3.setImage(AuthoringUIImages.IMG_STOP);
        toolItem3.setToolTipText(AuthoringUIResources.stopButton_text);
        toolItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Browser browser = PreviewPage.this.previewer.getBrowser();
                if (browser != null) {
                    browser.stop();
                }
            }
        });
        ToolItem toolItem4 = new ToolItem(toolBar, 0);
        toolItem4.setImage(AuthoringUIImages.IMG_REFRESH);
        toolItem4.setToolTipText(AuthoringUIResources.refreshButton_text);
        toolItem4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreviewPage.this.previewer.refresh();
            }
        });
        ToolItem toolItem5 = new ToolItem(toolBar, 0);
        toolItem5.setImage(AuthoringUIImages.IMG_PRINT);
        toolItem5.setToolTipText(AuthoringUIResources.printButton_text);
        toolItem5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreviewPage.this.previewer.print();
            }
        });
        return toolBar;
    }
}

