/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.internal.wizards;

import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.wizards.NewLibraryMainPage;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.NewLibraryWizardPage;
import org.eclipse.epf.library.ui.wizards.NewLibraryWizardPageFactory;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewLibraryWizard2
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = NewLibraryWizard2.class.getName();
    private NewLibraryMainPage mainPage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setWindowTitle(AuthoringUIResources.newLibraryWizard_title);
    }

    public void addPages() {
        SaveAllEditorsPage.addPageIfNeeded(this, true, null, null, null);
        this.mainPage = new NewLibraryMainPage();
        this.addPage((IWizardPage)this.mainPage);
        for (String string : LibraryManagerFactory.getInstance().getLibraryTypes().keySet()) {
            String string2 = String.valueOf(string) + "Page";
            NewLibraryWizardPage newLibraryWizardPage = NewLibraryWizardPageFactory.getInstance().createWizardPage(string2, string);
            if (newLibraryWizardPage == null) continue;
            newLibraryWizardPage.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
            this.addPage((IWizardPage)newLibraryWizardPage);
        }
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodLibrary.gif"));
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = 1;
        while (n < iWizardPageArray.length) {
            if (!iWizardPageArray[n].isPageComplete()) {
                return false;
            }
            ++n;
        }
        return this.getContainer().getCurrentPage() != this.mainPage;
    }

    public boolean performFinish() {
        String string = this.mainPage.getLibraryName();
        String string2 = this.mainPage.getLibraryType();
        NewLibraryWizardPage newLibraryWizardPage = NewLibraryWizardPageFactory.getInstance().getWizardPage(string2);
        try {
            MethodLibrary methodLibrary = LibraryService.getInstance().createMethodLibrary(string, string2, newLibraryWizardPage.getSelections());
            if (methodLibrary != null) {
                this.addRecentlyOpenedLibrary(methodLibrary);
                PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
                return true;
            }
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            if (string3 == null) {
                string3 = AuthoringUIResources.newLibraryInternlError_reason;
            }
            string3 = String.valueOf(string3) + "\n\n" + AuthoringUIResources.newLibraryError_advice;
            if (exception.getMessage() != null) {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newLibraryWizard_title, AuthoringUIResources.newLibraryError_msg, string3);
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newLibraryWizard_title, AuthoringUIResources.newLibraryError_msg, string3, (Throwable)exception);
        }
        return false;
    }

    protected void addRecentlyOpenedLibrary(MethodLibrary methodLibrary) {
        if (methodLibrary != null) {
            String string = LibraryService.getInstance().getLibraryManager(methodLibrary).getMethodLibraryURI().toString();
            LibraryUIPreferences.addOpenLibraryURI((String)string);
        }
    }
}

