/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.common.preferences.CommonPreferences;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.ui.preferences.BasePreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class AuthoringPreferencePage
extends BasePreferencePage
implements ModifyListener {
    private static int MIN_PREFERENCE_HISTORY_SIZE = 1;
    private static int MAX_PREFERENCE_HISTORY_SIZE = 20;
    private Composite composite;
    private Text defaultLibraryPathText;
    private Button browseButton;
    private Button discardUnresolvedReferencesCheckbox;
    private Button useNewExtendsSemanticsCheckbox;
    private Button enableLibraryValidationCheckbox;
    private Text preferenceHistorySizeText;

    protected Control createContents(Composite composite) {
        this.composite = AuthoringPreferencePage.createGridLayoutComposite((Composite)composite, (int)1);
        Group group = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.methodLibraryGroup_text, (int)3);
        AuthoringPreferencePage.createLabel((Composite)group, (String)AuthoringUIResources.defaultPathLabel_text);
        this.defaultLibraryPathText = AuthoringPreferencePage.createEditableText((Composite)group);
        this.browseButton = AuthoringPreferencePage.createButton((Composite)group, (String)AuthoringUIText.BROWSE_BUTTON_TEXT);
        this.discardUnresolvedReferencesCheckbox = AuthoringPreferencePage.createCheckbox((Composite)group, (String)AuthoringUIResources.discardunresolvedref, (int)3);
        Group group2 = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.modelingGroup_text, (int)1);
        this.useNewExtendsSemanticsCheckbox = AuthoringPreferencePage.createCheckbox((Composite)group2, (String)AuthoringUIResources.extend_semantics_button_text);
        Group group3 = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.userInterfaceGroup_text, (int)2);
        AuthoringPreferencePage.createLabel((Composite)group3, (String)AuthoringUIResources.default_list_length_label);
        this.preferenceHistorySizeText = AuthoringPreferencePage.createEditableText((Composite)group3, (String)"", (int)25);
        Group group4 = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.debugGroup_text, (int)2);
        this.enableLibraryValidationCheckbox = AuthoringPreferencePage.createCheckbox((Composite)group4, (String)AuthoringUIResources.enableLibraryValidationCheckbox_text);
        this.initControls();
        this.addListeners();
        return this.composite;
    }

    protected void initControls() {
        this.defaultLibraryPathText.setText(LibraryUIPreferences.getDefaultLibraryPath());
        this.discardUnresolvedReferencesCheckbox.setSelection(LibraryPreferences.getDiscardUnresolvedReferences());
        this.useNewExtendsSemanticsCheckbox.setSelection(LibraryPreferences.getUseNewExtendsSemantics());
        this.preferenceHistorySizeText.setText("" + CommonPreferences.getPreferenceHistorySize());
        this.enableLibraryValidationCheckbox.setSelection(AuthoringUIPreferences.getEnableLibraryValidation());
    }

    protected void addListeners() {
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AuthoringPreferencePage.this.openDirectoryDialog();
            }
        });
        this.preferenceHistorySizeText.addModifyListener((ModifyListener)this);
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setErrorMessage(null);
        this.setValid(true);
        int n = 0;
        if (modifyEvent.widget == this.preferenceHistorySizeText && ((n = this.getPreferenceHistorySize()) < MIN_PREFERENCE_HISTORY_SIZE || n > MAX_PREFERENCE_HISTORY_SIZE)) {
            this.setErrorMessage(AuthoringUIResources.bind((String)AuthoringUIResources.invalidPreferenceHistorySizeError_msg, (Object[])new Object[]{new Integer(MIN_PREFERENCE_HISTORY_SIZE), new Integer(MAX_PREFERENCE_HISTORY_SIZE)}));
            this.setValid(false);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        String string = LibraryUIPreferences.getInitialDefaultLibraryPath();
        LibraryUIPreferences.setDefaultLibraryPath((String)string);
        this.defaultLibraryPathText.setText(string);
        boolean bl = LibraryPreferences.getDefaultDiscardUnresolvedReferences();
        LibraryPreferences.setDiscardUnresolvedReferences((boolean)bl);
        this.discardUnresolvedReferencesCheckbox.setSelection(bl);
        boolean bl2 = LibraryPreferences.getDefaultUseNewExtendsSemantics();
        LibraryPreferences.setUseNewExtendsSemantics((boolean)bl2);
        this.useNewExtendsSemanticsCheckbox.setSelection(bl2);
        int n = CommonPreferences.getDefaultPreferenceHistorySize();
        CommonPreferences.setPreferenceHistorySize((int)n);
        this.preferenceHistorySizeText.setText("" + n);
        boolean bl3 = AuthoringUIPreferences.getDefaultEnableLibraryValidation();
        AuthoringUIPreferences.setEnableLibraryValidation(bl3);
        this.enableLibraryValidationCheckbox.setSelection(bl3);
    }

    public boolean performOk() {
        LibraryUIPreferences.setDefaultLibraryPath((String)this.getDefaultLibraryPath());
        LibraryPreferences.setDiscardUnresolvedReferences((boolean)this.getDiscardUnresolvedReferences());
        LibraryPreferences.setUseNewExtendsSemantics((boolean)this.getUseNewExtendsSemantics());
        CommonPreferences.setPreferenceHistorySize((int)this.getPreferenceHistorySize());
        AuthoringUIPreferences.setEnableLibraryValidation(this.getEnableLibraryValidation());
        LibraryUIPlugin.getDefault().updateLayoutSettings();
        return true;
    }

    protected String getDefaultLibraryPath() {
        return this.defaultLibraryPathText.getText().trim();
    }

    protected boolean getDiscardUnresolvedReferences() {
        return this.discardUnresolvedReferencesCheckbox.getSelection();
    }

    protected boolean getUseNewExtendsSemantics() {
        return this.useNewExtendsSemanticsCheckbox.getSelection();
    }

    protected int getPreferenceHistorySize() {
        return StrUtil.getIntValue((String)this.preferenceHistorySizeText.getText().trim(), (int)0);
    }

    protected boolean getEnableLibraryValidation() {
        return this.enableLibraryValidationCheckbox.getSelection();
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.composite.getShell(), 0);
            String string = directoryDialog.open();
            if (string != null) {
                this.defaultLibraryPathText.setText(string);
            }
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }
}

