/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessRoleFilter;
import org.eclipse.epf.authoring.ui.properties.DescriptorGeneralSection;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.command.LinkMethodElementCommand;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RoleDescriptorGeneralSection
extends DescriptorGeneralSection {
    protected RoleDescriptor element;
    private Label ctrl_method_element_label;
    private Text ctrl_method_element;
    private Button linkButton;
    private Button clearButton;

    protected void init() {
        super.init();
        this.element = (RoleDescriptor)this.getElement();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        this.ctrl_method_element_label = FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Process_Type_Role);
        this.ctrl_method_element = FormUI.createText(this.toolkit, this.generalComposite, -1, 1);
        this.ctrl_method_element.setText(this.getMethodElementName(this.element));
        this.ctrl_method_element.setEnabled(false);
        Composite composite2 = FormUI.createComposite(this.toolkit, this.generalComposite, 0, 2, true);
        this.linkButton = FormUI.createButton(this.toolkit, composite2, 8, 1);
        this.linkButton.setText(PropertiesResources.Process_Button_LinkMethodElement);
        this.clearButton = FormUI.createButton(this.toolkit, composite2, 8, 1);
        this.clearButton.setText(PropertiesResources.Process_Button_ClearMethodElement);
        this.toggleMethodRole();
    }

    private void toggleMethodRole() {
        if (this.element instanceof CompositeRole) {
            this.ctrl_method_element_label.setVisible(false);
            this.ctrl_method_element.setVisible(false);
            this.linkButton.setVisible(false);
            this.clearButton.setVisible(false);
        } else {
            this.ctrl_method_element_label.setVisible(true);
            this.ctrl_method_element.setVisible(true);
            this.linkButton.setVisible(true);
            this.clearButton.setVisible(true);
        }
    }

    protected void addListeners() {
        super.addListeners();
        this.linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessRoleFilter processRoleFilter = new ProcessRoleFilter(RoleDescriptorGeneralSection.this.getConfiguration(), null, FilterConstants.ROLES);
                ArrayList<Role> arrayList = new ArrayList<Role>();
                if (RoleDescriptorGeneralSection.this.element.getRole() != null) {
                    arrayList.add(RoleDescriptorGeneralSection.this.element.getRole());
                }
                ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)processRoleFilter, RoleDescriptorGeneralSection.this.element, FilterConstants.ROLES, arrayList);
                itemsFilterDialog.setBlockOnOpen(true);
                itemsFilterDialog.setViewerSelectionSingle(true);
                itemsFilterDialog.setTitle(FilterConstants.ROLES);
                itemsFilterDialog.open();
                RoleDescriptorGeneralSection.this.setMethodElement(itemsFilterDialog.getSelectedItems());
                RoleDescriptorGeneralSection.this.ctrl_method_element.setText(RoleDescriptorGeneralSection.this.getMethodElementName(RoleDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RoleDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)RoleDescriptorGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_Role(), null, -1);
                RoleDescriptorGeneralSection.this.ctrl_method_element.setText(RoleDescriptorGeneralSection.this.getMethodElementName(RoleDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    private void setMethodElement(List list) {
        if (list != null && list.size() >= 1 && list.get(0) instanceof Role) {
            Role role = (Role)list.get(0);
            boolean bl = true;
            if (bl) {
                LinkMethodElementCommand linkMethodElementCommand = new LinkMethodElementCommand((Descriptor)this.element, (Object)role, 20);
                this.actionMgr.execute((IResourceAwareCommand)linkMethodElementCommand);
                this.getEditor().setSelection(this.getSelection());
            } else {
                MessageFormat messageFormat = new MessageFormat(PropertiesResources.Process_InvalidLinkMethodElement);
                Object[] objectArray = new Object[]{role.getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.Process_LinkMethodElementTitle, messageFormat.format(objectArray));
            }
        }
    }

    private String getMethodElementName(RoleDescriptor roleDescriptor) {
        String string = PropertiesResources.Process_None;
        if (roleDescriptor.getRole() != null) {
            string = roleDescriptor.getRole().getName();
        }
        return string;
    }

    protected void updateControls() {
        super.updateControls();
        this.linkButton.setEnabled(this.editable);
        this.clearButton.setEnabled(this.editable);
        BreakdownElement breakdownElement = this.getElement();
        if (breakdownElement instanceof RoleDescriptor) {
            RoleDescriptor roleDescriptor = (RoleDescriptor)breakdownElement;
            if (roleDescriptor.getSuperActivities() == null || roleDescriptor.getSuperActivities() == null) {
                this.nameText.setEditable(true);
                this.presentationNameText.setEditable(true);
            } else {
                this.nameText.setEditable(this.editable);
                this.presentationNameText.setEditable(this.editable);
            }
        }
    }

    public void refresh() {
        try {
            super.refresh();
            if (this.getElement() instanceof RoleDescriptor) {
                this.element = (RoleDescriptor)this.getElement();
                this.ctrl_method_element.setText(this.getMethodElementName(this.element));
                this.toggleMethodRole();
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing RoleDescriptor general section: ", (Throwable)exception);
        }
    }

    public String getNamePrefix() {
        if (this.getElement() instanceof CompositeRole) {
            return String.valueOf(LibraryUIText.TEXT_COMPOSITE_ROLE) + ": ";
        }
        return String.valueOf(LibraryUIText.TEXT_ROLE_DESCRIPTOR) + ": ";
    }
}

