/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.internal.IProblemChangedListener;
import org.eclipse.epf.authoring.ui.internal.ImageDescriptorRegistry;
import org.eclipse.epf.authoring.ui.internal.ImageImageDescriptor;
import org.eclipse.epf.authoring.ui.internal.MethodElementImageDescriptor;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private static final int ERRORTICK_ERROR = 64;
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList fListeners;

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry imageDescriptorRegistry) {
        this.fRegistry = imageDescriptorRegistry;
        this.fProblemChangedListener = null;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : AuthoringUIPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String string, Object object) {
        return string;
    }

    public Image decorateImage(Image image, Object object) {
        int n = this.computeAdornmentFlags(object);
        if (n != 0) {
            ImageImageDescriptor imageImageDescriptor = new ImageImageDescriptor(image);
            Rectangle rectangle = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new MethodElementImageDescriptor(imageImageDescriptor, n, new Point(rectangle.width, rectangle.height)));
        }
        return image;
    }

    protected int computeAdornmentFlags(Object object) {
        try {
            if (object instanceof MethodElement) {
                return this.getErrorTicksFromMarkers((MethodElement)object, PersistenceUtil.getWorkspaceResource((Object)object), 2);
            }
            if (object instanceof IResource) {
                return this.getErrorTicksFromMarkers(null, (IResource)object, 2);
            }
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 376) {
                return 0;
            }
            AuthoringUIPlugin.log(coreException);
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(MethodElement methodElement, IResource iResource, int n) throws CoreException {
        if (iResource == null || !iResource.isAccessible()) {
            return 0;
        }
        int n2 = 0;
        IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.core.resources.problemmarker", true, n);
        if (iMarkerArray != null) {
            int n3 = 0;
            while (n3 < iMarkerArray.length && n2 != 64) {
                IMarker iMarker = iMarkerArray[n3];
                int n4 = iMarker.getAttribute("severity", -1);
                if (n4 == 2 && (methodElement == null || methodElement.getGuid().equals(iMarker.getAttribute("guid")))) {
                    n2 = 64;
                }
                ++n3;
            }
        }
        return n2;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            AuthoringUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)iLabelProviderListener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] iResourceArray, boolean bl) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(iResourceArray, bl);
                }
            };
            AuthoringUIPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)iLabelProviderListener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                AuthoringUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] iResourceArray, boolean bl) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent problemsLabelChangedEvent = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, iResourceArray, bl);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((ILabelProviderListener)objectArray[n]).labelProviderChanged((LabelProviderChangedEvent)problemsLabelChangedEvent);
                ++n;
            }
        }
    }

    public void decorate(Object object, IDecoration iDecoration) {
        int n = this.computeAdornmentFlags(object);
        if (n == 64) {
            iDecoration.addOverlay(AuthoringUIImages.IMG_DESC_OVR_ERROR);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider iBaseLabelProvider, IResource[] iResourceArray, boolean bl) {
            super(iBaseLabelProvider, (Object[])iResourceArray);
            this.fMarkerChange = bl;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

