/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;

public class ConfigurationMarkerResolution
implements IMarkerResolution {
    protected MethodConfiguration config;
    protected MethodElement errorElement;
    protected MethodElement causeElement;

    public ConfigurationMarkerResolution(MethodConfiguration methodConfiguration, MethodElement methodElement, MethodElement methodElement2) {
        this.config = methodConfiguration;
        this.errorElement = methodElement;
        this.causeElement = methodElement2;
    }

    public String getLabel() {
        return AuthoringUIResources.ConfigurationMarkerResolutionGenerator_resolveMissingReference;
    }

    public void run(IMarker iMarker) {
        try {
            if (iMarker.getResource() instanceof IFile) {
                IFile iFile = (IFile)iMarker.getResource();
                ResourceSet resourceSet = LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet();
                MethodElement methodElement = PersistenceUtil.getMethodElement((IResource)iFile, (ResourceSet)resourceSet);
                IEditorPart iEditorPart = EditorChooser.getInstance().findEditor(methodElement);
                if (iEditorPart instanceof ConfigurationEditor) {
                    ((ConfigurationEditor)iEditorPart).doQuickFix(iMarker);
                }
            }
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }
}

