/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class SaveAllEditorsPage
extends BaseWizardPage {
    private static final String SAVE_AND_CLOSE_PAGE_TITLE = AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_saveAndClosePageTitle;
    private static final String SAVE_AND_CLOSE_PAGE_DESC = AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_saveAndClosePageDescription;
    private static final String SAVE_PAGE_TITLE = AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_saveTitle;
    private static final String SAVE_PAGE_DESC = AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_saveDescription;
    private boolean doClose;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Button selectAll;
    private Button deselectAll;

    public static boolean addPageIfNeeded(Wizard wizard, boolean bl) {
        if (SaveAllEditorsPage.isUnsavedEditor()) {
            wizard.addPage((IWizardPage)new SaveAllEditorsPage(bl));
            return true;
        }
        SaveAllEditorsPage.performClose(bl);
        return false;
    }

    public static boolean addPageIfNeeded(Wizard wizard, boolean bl, String string, String string2, ImageDescriptor imageDescriptor) {
        if (SaveAllEditorsPage.isUnsavedEditor()) {
            SaveAllEditorsPage saveAllEditorsPage = new SaveAllEditorsPage(bl);
            if (string != null) {
                saveAllEditorsPage.setTitle(string);
            }
            if (string2 != null) {
                saveAllEditorsPage.setDescription(string2);
            }
            if (imageDescriptor != null) {
                saveAllEditorsPage.setImageDescriptor(imageDescriptor);
            }
            wizard.addPage((IWizardPage)saveAllEditorsPage);
            return true;
        }
        SaveAllEditorsPage.performClose(bl);
        return false;
    }

    public SaveAllEditorsPage(boolean bl) {
        super(SAVE_PAGE_TITLE);
        this.doClose = bl;
        if (this.doClose) {
            this.setTitle(SAVE_AND_CLOSE_PAGE_TITLE);
            this.setDescription(SAVE_AND_CLOSE_PAGE_DESC);
        } else {
            this.setTitle(SAVE_PAGE_TITLE);
            this.setDescription(SAVE_PAGE_DESC);
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.ctrl_chkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2308);
        this.ctrl_chkboxTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                IEditorReference iEditorReference = (IEditorReference)object;
                return iEditorReference.getEditor(false).getTitle();
            }

            public Image getImage(Object object) {
                IEditorReference iEditorReference = (IEditorReference)object;
                return iEditorReference.getEditor(false).getTitleImage();
            }
        });
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ctrl_chkboxTableViewer.setInput((Object)EditorChooser.getInstance().getOpenMethodEditors().toArray());
        this.ctrl_chkboxTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return object2 instanceof IEditorReference && ((IEditorReference)object2).isDirty();
            }
        });
        this.ctrl_chkboxTableViewer.setAllChecked(true);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(1, true));
        composite3.setLayoutData((Object)new GridData(-1, 1, false, true));
        this.selectAll = new Button(composite3, 8);
        this.selectAll.setText(AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_SelectAllButtonLabel);
        this.selectAll.setLayoutData((Object)new GridData(4, 1, false, true));
        this.deselectAll = new Button(composite3, 8);
        this.deselectAll.setText(AuthoringUIResources.AuthoringUIPlugin_SaveAllEditorsPage_DeselectAllButtonLabel);
        this.deselectAll.setLayoutData((Object)new GridData(4, 1, false, true));
        this.addListeners();
        this.setControl((Control)composite2);
        this.setPageComplete(true);
    }

    private void refresh() {
        if (this.ctrl_chkboxTableViewer != null) {
            this.ctrl_chkboxTableViewer.refresh();
            if (this.ctrl_chkboxTableViewer.getTable() != null && this.ctrl_chkboxTableViewer.getTable().getItems() != null && this.ctrl_chkboxTableViewer.getTable().getItems().length == 0) {
                if (this.ctrl_chkboxTableViewer.getControl() != null) {
                    this.ctrl_chkboxTableViewer.getControl().setEnabled(false);
                }
                this.selectAll.setEnabled(false);
                this.deselectAll.setEnabled(false);
            }
        }
    }

    private void addListeners() {
        IWizardContainer iWizardContainer;
        if (this.getWizard() != null && (iWizardContainer = this.getWizard().getContainer()) instanceof WizardDialog) {
            ((WizardDialog)iWizardContainer).addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent pageChangedEvent) {
                    SaveAllEditorsPage.this.refresh();
                }
            });
        }
        this.selectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SaveAllEditorsPage.this.ctrl_chkboxTableViewer.setAllChecked(true);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        this.deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SaveAllEditorsPage.this.ctrl_chkboxTableViewer.setAllChecked(false);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public IWizardPage getNextPage() {
        this.performSaveAndClose();
        return super.getNextPage();
    }

    protected void performSaveAndClose() {
        Object[] objectArray = this.ctrl_chkboxTableViewer.getCheckedElements();
        int n = 0;
        while (n < objectArray.length) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveEditor(((IEditorReference)objectArray[n]).getEditor(false), false);
            ++n;
        }
        SaveAllEditorsPage.performClose(this.doClose);
    }

    protected static void performClose(boolean bl) {
        if (bl) {
            EditorChooser.getInstance().closeAllMethodEditors();
        }
    }

    private static boolean isUnsavedEditor() {
        boolean bl = false;
        List<IEditorReference> list = EditorChooser.getInstance().getOpenMethodEditors();
        for (IEditorReference iEditorReference : list) {
            if (!iEditorReference.isDirty()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isOpenEditor(boolean bl) {
        List<IEditorReference> list = EditorChooser.getInstance().getOpenMethodEditors();
        return bl && list.size() > 0;
    }

    public boolean isPageComplete() {
        return true;
    }
}

