/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.common.service.utils.CommandLineRunUtil;
import org.eclipse.epf.library.ConfigurationAlreadyExistsException;
import org.eclipse.epf.library.ConfigurationManager;
import org.eclipse.epf.library.CreateLibraryManagerException;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.UmaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryService
implements ILibraryService {
    protected static final int EVENT_CREATE_LIBRARY = 1;
    protected static final int EVENT_OPEN_LIBRARY = 2;
    protected static final int EVENT_REOPEN_LIBRARY = 3;
    protected static final int EVENT_CLOSE_LIBRARY = 4;
    protected static final int EVENT_SET_CURRENT_LIBRARY = 5;
    protected static final int EVENT_SET_CURRENT_CONFIGURATION = 6;
    protected static ILibraryService instance;
    protected Map<MethodLibrary, ILibraryManager> libraryManagers = new HashMap<MethodLibrary, ILibraryManager>();
    protected Map<MethodConfiguration, IConfigurationManager> configManagers = new HashMap<MethodConfiguration, IConfigurationManager>();
    protected List<ILibraryServiceListener> listeners = new ArrayList<ILibraryServiceListener>();
    protected MethodLibrary currentLibrary;
    protected MethodConfiguration currentConfig;
    private boolean closingCurrentLibrary;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ILibraryService getInstance() {
        if (instance != null) return instance;
        Class<LibraryService> clazz = LibraryService.class;
        synchronized (LibraryService.class) {
            if (instance != null) return instance;
            instance = new LibraryService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryService() {
        this.init();
    }

    protected void init() {
        LibraryManagerFactory.getInstance();
        if (CommandLineRunUtil.getInstance().isNeedToRun()) {
            return;
        }
    }

    @Override
    public MethodLibrary createMethodLibrary(String string, String string2, Map<String, Object> map) throws LibraryServiceException {
        if (string == null || string2 == null || map == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = LibraryService.getInstance().getCurrentMethodLibrary() != null;
        try {
            LibraryService.getInstance().closeCurrentMethodLibrary();
            ILibraryManager iLibraryManager = LibraryManagerFactory.getInstance().createLibraryManager(string2);
            MethodLibrary methodLibrary = iLibraryManager.createMethodLibrary(string, map);
            if (methodLibrary != null) {
                methodLibrary = iLibraryManager.openMethodLibrary(iLibraryManager.getMethodLibraryURI());
                this.setLibraryManager(iLibraryManager);
                this.setCurrentMethodLibrary(methodLibrary);
                this.saveMethodLibraryPreferences(iLibraryManager.getMethodLibraryURI(), string2);
                this.notifyListeners(methodLibrary, 1);
            }
            bl = false;
            MethodLibrary methodLibrary2 = methodLibrary;
            return methodLibrary2;
        }
        catch (LibraryServiceException libraryServiceException) {
            throw libraryServiceException;
        }
        catch (Exception exception) {
            throw new LibraryServiceException(exception);
        }
        finally {
            if (bl) {
                this.openLastOpenedMethodLibrary();
            }
        }
    }

    @Override
    public MethodLibrary openMethodLibrary(String string, URI uRI) throws LibraryServiceException {
        if (uRI == null) {
            throw new IllegalArgumentException();
        }
        try {
            ILibraryManager iLibraryManager = LibraryManagerFactory.getInstance().createLibraryManager(string);
            MethodLibrary methodLibrary = iLibraryManager.openMethodLibrary(uRI);
            if (methodLibrary != null) {
                this.setLibraryManager(iLibraryManager);
                this.setCurrentMethodLibrary(methodLibrary);
                this.saveMethodLibraryPreferences(iLibraryManager.getMethodLibraryURI(), string);
                this.notifyListeners(methodLibrary, 2);
            }
            return methodLibrary;
        }
        catch (CreateLibraryManagerException createLibraryManagerException) {
            throw createLibraryManagerException;
        }
        catch (Exception exception) {
            throw new LibraryServiceException(exception);
        }
    }

    @Override
    public MethodLibrary openMethodLibrary(String string, Map<String, Object> map) throws LibraryServiceException {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        try {
            ILibraryManager iLibraryManager = LibraryManagerFactory.getInstance().createLibraryManager(string);
            MethodLibrary methodLibrary = iLibraryManager.openMethodLibrary(map);
            if (methodLibrary != null) {
                this.setLibraryManager(iLibraryManager);
                this.setCurrentMethodLibrary(methodLibrary);
                this.saveMethodLibraryPreferences(iLibraryManager.getMethodLibraryURI(), string);
                this.notifyListeners(methodLibrary, 2);
            }
            return methodLibrary;
        }
        catch (CreateLibraryManagerException createLibraryManagerException) {
            throw createLibraryManagerException;
        }
        catch (Exception exception) {
            throw new LibraryServiceException(exception);
        }
    }

    @Override
    public MethodLibrary openLastOpenedMethodLibrary() {
        String string;
        URI uRI;
        block5: {
            block4: {
                String string2 = LibraryPreferences.getSavedMethodLibraryURI();
                try {
                    uRI = new URI(string2);
                    if (uRI.getPath().length() != 0) break block4;
                    return null;
                }
                catch (Exception exception) {
                    LibraryPlugin.getDefault().getLogger().logWarning("Unable to open the last opened method library '" + string2 + "'.");
                    LibraryPreferences.setSavedMethodLibraryURI("");
                    return null;
                }
            }
            string = LibraryPreferences.getSavedMethodLibraryType();
            if (string != null && string.length() != 0) break block5;
            return null;
        }
        return this.openMethodLibrary(string, uRI);
    }

    @Override
    public MethodLibrary reopenMethodLibrary(MethodLibrary methodLibrary) throws LibraryServiceException {
        ILibraryManager iLibraryManager = this.getLibraryManager(methodLibrary);
        if (iLibraryManager != null) {
            try {
                this.removeLibraryManager(iLibraryManager);
                methodLibrary = iLibraryManager.reopenMethodLibrary();
                this.setLibraryManager(iLibraryManager);
                this.setCurrentMethodLibrary(methodLibrary);
                this.notifyListeners(methodLibrary, 3);
            }
            catch (Exception exception) {
                throw new LibraryServiceException(exception);
            }
        }
        return null;
    }

    @Override
    public MethodLibrary reopenCurrentMethodLibrary() throws LibraryServiceException {
        return this.reopenMethodLibrary(this.currentLibrary);
    }

    @Override
    public void saveMethodLibrary(MethodLibrary methodLibrary) throws LibraryServiceException {
        ILibraryManager iLibraryManager = this.getLibraryManager(methodLibrary);
        if (iLibraryManager != null) {
            iLibraryManager.saveMethodLibrary();
        }
    }

    @Override
    public void saveCurrentMethodLibrary() throws LibraryServiceException {
        this.saveMethodLibrary(this.currentLibrary);
    }

    @Override
    public void closeMethodLibrary(MethodLibrary methodLibrary) throws LibraryServiceException {
        ILibraryManager iLibraryManager = this.getLibraryManager(methodLibrary);
        if (iLibraryManager != null) {
            this.notifyListeners(methodLibrary, 4);
            iLibraryManager.closeMethodLibrary();
            if (this.currentLibrary == methodLibrary) {
                this.setCurrentMethodLibrary(null);
                this.setCurrentMethodConfiguration(null);
            }
            this.removeLibraryManager(iLibraryManager);
            iLibraryManager.dispose();
        }
    }

    @Override
    public synchronized void closeCurrentMethodLibrary() throws LibraryServiceException {
        if (this.closingCurrentLibrary) {
            return;
        }
        try {
            this.closingCurrentLibrary = true;
            if (this.currentLibrary != null) {
                this.closeMethodLibrary(this.currentLibrary);
            }
        }
        finally {
            this.closingCurrentLibrary = false;
        }
    }

    @Override
    public void replaceMethodLibrary(MethodLibrary methodLibrary, MethodLibrary methodLibrary2) {
        ILibraryManager iLibraryManager = this.getLibraryManager(methodLibrary);
        if (iLibraryManager != null) {
            this.removeLibraryManager(iLibraryManager);
            iLibraryManager.setMethodLibrary(methodLibrary2);
            this.setLibraryManager(iLibraryManager);
        }
    }

    @Override
    public void addListener(ILibraryServiceListener iLibraryServiceListener) {
        this.listeners.add(iLibraryServiceListener);
    }

    @Override
    public void removeListener(ILibraryServiceListener iLibraryServiceListener) {
        this.listeners.remove(iLibraryServiceListener);
    }

    @Override
    public MethodLibrary getCurrentMethodLibrary() {
        return this.currentLibrary;
    }

    @Override
    public void setCurrentMethodLibrary(MethodLibrary methodLibrary) {
        this.currentLibrary = methodLibrary;
        this.notifyListeners(methodLibrary, 5);
    }

    @Override
    public String getCurrentMethodLibraryLocation() {
        ILibraryManager iLibraryManager = this.getLibraryManager(this.currentLibrary);
        if (iLibraryManager != null) {
            return iLibraryManager.getMethodLibraryLocation();
        }
        return null;
    }

    @Override
    public ILibraryManager getLibraryManager(MethodLibrary methodLibrary) {
        return this.libraryManagers.get(methodLibrary);
    }

    @Override
    public void removeLibraryManager(ILibraryManager iLibraryManager) {
        MethodLibrary methodLibrary;
        if (iLibraryManager != null && (methodLibrary = iLibraryManager.getMethodLibrary()) != null) {
            this.removeConfigurationManagers(methodLibrary);
            this.libraryManagers.remove(methodLibrary);
        }
    }

    @Override
    public void setLibraryManager(ILibraryManager iLibraryManager) {
        MethodLibrary methodLibrary = iLibraryManager.getMethodLibrary();
        if (methodLibrary != null) {
            this.libraryManagers.put(methodLibrary, iLibraryManager);
        }
    }

    @Override
    public ILibraryManager getCurrentLibraryManager() {
        return this.getLibraryManager(this.currentLibrary);
    }

    @Override
    public MethodConfiguration createMethodConfiguration(String string, MethodLibrary methodLibrary) throws LibraryServiceException {
        MethodConfiguration methodConfiguration2;
        if (string == null || methodLibrary == null) {
            throw new IllegalArgumentException();
        }
        List list = methodLibrary.getPredefinedConfigurations();
        for (MethodConfiguration methodConfiguration2 : list) {
            if (!string.equals(methodConfiguration2.getName())) continue;
            throw new ConfigurationAlreadyExistsException();
        }
        methodConfiguration2 = UmaFactory.eINSTANCE.createMethodConfiguration();
        methodConfiguration2.setName(string);
        list.add(methodConfiguration2);
        return methodConfiguration2;
    }

    @Override
    public MethodConfiguration getCurrentMethodConfiguration() {
        return this.currentConfig;
    }

    @Override
    public void setCurrentMethodConfiguration(MethodConfiguration methodConfiguration) {
        this.currentConfig = methodConfiguration;
        this.notifyListeners(methodConfiguration, 6);
    }

    @Override
    public IConfigurationManager getConfigurationManager(MethodConfiguration methodConfiguration) {
        if (methodConfiguration == null) {
            throw new IllegalArgumentException();
        }
        IConfigurationManager iConfigurationManager = this.configManagers.get(methodConfiguration);
        if (iConfigurationManager == null) {
            iConfigurationManager = new ConfigurationManager(methodConfiguration);
            this.configManagers.put(methodConfiguration, iConfigurationManager);
        }
        return iConfigurationManager;
    }

    @Override
    public void removeConfigurationManager(MethodConfiguration methodConfiguration) {
        if (methodConfiguration == null) {
            throw new IllegalArgumentException();
        }
        IConfigurationManager iConfigurationManager = this.configManagers.remove(methodConfiguration);
        if (iConfigurationManager != null) {
            iConfigurationManager.dispose();
        }
    }

    @Override
    public void removeConfigurationManagers(MethodLibrary methodLibrary) {
        if (methodLibrary == null) {
            throw new IllegalArgumentException();
        }
        MethodConfiguration[] methodConfigurationArray = LibraryServiceUtil.getMethodConfigurations(methodLibrary);
        int n = 0;
        while (n < methodConfigurationArray.length) {
            this.removeConfigurationManager(methodConfigurationArray[n]);
            ++n;
        }
    }

    @Override
    public IConfigurationManager getCurrentConfigurationManager() {
        if (this.currentConfig != null) {
            return this.getConfigurationManager(this.currentConfig);
        }
        return null;
    }

    protected void notifyListeners(final MethodLibrary methodLibrary, int n) {
        for (final ILibraryServiceListener iLibraryServiceListener : new ArrayList<ILibraryServiceListener>(this.listeners)) {
            switch (n) {
                case 1: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            iLibraryServiceListener.libraryCreated(methodLibrary);
                        }
                    });
                    break;
                }
                case 2: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            iLibraryServiceListener.libraryOpened(methodLibrary);
                        }
                    });
                    break;
                }
                case 3: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            iLibraryServiceListener.libraryReopened(methodLibrary);
                        }
                    });
                    break;
                }
                case 4: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            iLibraryServiceListener.libraryClosed(methodLibrary);
                        }
                    });
                    break;
                }
                case 5: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            iLibraryServiceListener.librarySet(methodLibrary);
                        }
                    });
                }
            }
        }
    }

    protected void notifyListeners(final MethodConfiguration methodConfiguration, int n) {
        for (final ILibraryServiceListener iLibraryServiceListener : new ArrayList<ILibraryServiceListener>(this.listeners)) {
            switch (n) {
                case 6: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            iLibraryServiceListener.configurationSet(methodConfiguration);
                        }
                    });
                }
            }
        }
    }

    protected void saveMethodLibraryPreferences(URI uRI, String string) {
        LibraryPreferences.setSavedMethodLibraryURI(uRI.toString());
        LibraryPreferences.setSavedMethodLibraryType(string);
    }

    @Override
    public void registerMethodLibrary(MethodLibrary methodLibrary, String string, Map<String, Object> map) throws LibraryServiceException {
        ILibraryManager iLibraryManager = LibraryManagerFactory.getInstance().createLibraryManager(string);
        iLibraryManager.registerMethodLibrary(methodLibrary, map);
        LibraryService.getInstance().setLibraryManager(iLibraryManager);
    }

    @Override
    public void unRegisterMethodLibrary(MethodLibrary methodLibrary) throws LibraryServiceException {
        ILibraryManager iLibraryManager = this.getLibraryManager(methodLibrary);
        if (iLibraryManager == null) {
            return;
        }
        this.removeLibraryManager(iLibraryManager);
        iLibraryManager.unRegisterMethodLibrary();
        iLibraryManager.dispose();
    }
}

