/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.DebugUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProductType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationData {
    private static boolean localDebug = false;
    private static boolean profiling = false;
    private MethodConfiguration config;
    private Map<String, MethodElement> substractedElemMap = new HashMap<String, MethodElement>();
    private Map<String, MethodElement> addedElemMap = new HashMap<String, MethodElement>();
    private boolean needUpdateChanges = true;
    private Map<String, ContentCategory> originalSubstracted;
    private Map<String, ContentCategory> orignalAdded;
    private ILibraryManager libraryManager;
    private Adapter configListener;
    private ILibraryChangeListener libListener;
    private boolean enableUpdate = true;

    public ConfigurationData(MethodConfiguration methodConfiguration) {
        this.config = methodConfiguration;
        this.configListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (ConfigurationData.this.isNeedUpdateChanges()) {
                    return;
                }
                int n = notification.getEventType();
                if (n == 3 || n == 5 || n == 4 || n == 6) {
                    ConfigurationData.this.setNeedUpdateChanges(true);
                }
            }
        };
        methodConfiguration.eAdapters().add((Object)this.configListener);
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int n, Collection collection) {
                if (ConfigurationData.this.isNeedUpdateChanges()) {
                    return;
                }
                for (Object e : collection) {
                    if (!(e instanceof ContentCategory)) continue;
                    ConfigurationData.this.setNeedUpdateChanges(true);
                    return;
                }
            }
        };
        MethodLibrary methodLibrary = LibraryServiceUtil.getMethodLibrary((MethodElement)methodConfiguration);
        this.libraryManager = LibraryService.getInstance().getLibraryManager(methodLibrary);
        if (this.libraryManager != null) {
            this.libraryManager.addListener(this.libListener);
        }
    }

    private boolean getUpdatingChanges() {
        return this.originalSubstracted != null && this.orignalAdded != null;
    }

    private void updateChanges() {
        if (!this.isEnableUpdate()) {
            return;
        }
        if (!this.isNeedUpdateChanges()) {
            return;
        }
        if (this.getUpdatingChanges()) {
            return;
        }
        long l = 0L;
        if (profiling) {
            System.out.println("LD> updateChanges_() -> ");
            l = System.currentTimeMillis();
        }
        this.updateChanges_();
        if (profiling) {
            l = System.currentTimeMillis() - l;
            System.out.println("LD> updateChanges_() <- time: " + l);
            System.out.println("");
        }
    }

    private void updateChanges_() {
        boolean bl;
        this.substractedElemMap.clear();
        this.addedElemMap.clear();
        List list = this.config.getSubtractedCategory();
        List list2 = this.config.getAddedCategory();
        if (list.isEmpty() && list2.isEmpty()) {
            if (localDebug) {
                System.out.println("LD> subList/addList are empty.");
            }
            return;
        }
        this.originalSubstracted = this.convertToMap(list);
        this.orignalAdded = this.convertToMap(list2);
        if (localDebug) {
            DebugUtil.print((String)"originalSubstracted: ", null, this.originalSubstracted.values(), (int)2);
            DebugUtil.print((String)"orignalAdded: ", null, this.orignalAdded.values(), (int)2);
        }
        if ((bl = this.remove(this.originalSubstracted, this.orignalAdded)) && localDebug) {
            DebugUtil.print((String)"orignalAdded after remove: ", null, this.orignalAdded.values(), (int)2);
        }
        Map<String, ContentCategory> map = (Map<String, ContentCategory>)((HashMap)this.originalSubstracted).clone();
        Map<String, ContentCategory> map2 = (Map<String, ContentCategory>)((HashMap)this.orignalAdded).clone();
        bl = this.handleContributors(map, true);
        if (bl && localDebug) {
            DebugUtil.print((String)"calSubstracted after handleContributors: ", null, map.values(), (int)2);
        }
        map = this.handleReplacers(map, true);
        map2 = this.handleReplacers(map2, false);
        if (localDebug) {
            DebugUtil.print((String)"calSubstracted: ", null, map.values(), (int)2);
            DebugUtil.print((String)"calAdded: ", null, map2.values(), (int)2);
        }
        if ((bl = this.remove(map, map2)) && localDebug) {
            DebugUtil.print((String)"calAdded after remove: ", null, this.orignalAdded.values(), (int)2);
        }
        if (map != null) {
            this.updateElementMap(map.values(), this.substractedElemMap);
        }
        if (map2 != null) {
            this.updateElementMap(map2.values(), this.addedElemMap);
        }
        if (localDebug) {
            DebugUtil.print((String)"substractedElemMap: ", null, this.substractedElemMap.values(), (int)2);
            DebugUtil.print((String)"addedElemMap: ", null, this.addedElemMap.values(), (int)2);
        }
        this.setNeedUpdateChanges(false);
        this.originalSubstracted = null;
        this.orignalAdded = null;
    }

    private boolean remove(Map<String, ContentCategory> map, Map<String, ContentCategory> map2) {
        if (map == null || map.isEmpty() || map2 == null || map2.isEmpty()) {
            return false;
        }
        boolean bl = false;
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ContentCategory contentCategory = map2.remove(iterator.next());
            if (contentCategory == null) continue;
            bl = true;
        }
        return bl;
    }

    private boolean handleContributors(Map<String, ContentCategory> map, boolean bl) {
        if (map == null || !bl) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        for (ContentCategory contentCategory : map.values()) {
            List list = ConfigurationHelper.getContributors((VariabilityElement)contentCategory, this.config);
            arrayList.addAll(list);
        }
        for (ContentCategory contentCategory : arrayList) {
            map.put(contentCategory.getGuid(), contentCategory);
        }
        return !arrayList.isEmpty();
    }

    private Map<String, ContentCategory> handleReplacers(Map<String, ContentCategory> map, boolean bl) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        HashMap<String, ContentCategory> hashMap = new HashMap<String, ContentCategory>();
        for (ContentCategory contentCategory : map.values()) {
            VariabilityElement variabilityElement = ConfigurationHelper.getReplacer((VariabilityElement)contentCategory, this.config);
            boolean bl2 = true;
            if (variabilityElement != null) {
                bl2 = false;
                VariabilityElement variabilityElement2 = variabilityElement;
                while (variabilityElement2 != null) {
                    variabilityElement = variabilityElement2;
                    variabilityElement2 = ConfigurationHelper.getReplacer(variabilityElement2, this.config);
                }
                if (bl && this.originalSubstracted.containsKey(variabilityElement.getGuid())) {
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            hashMap.put(contentCategory.getGuid(), contentCategory);
        }
        return hashMap;
    }

    private Map<String, ContentCategory> convertToMap(Collection<ContentCategory> collection) {
        if (collection == null || collection.isEmpty()) {
            return new HashMap<String, ContentCategory>();
        }
        LinkedHashMap<String, ContentCategory> linkedHashMap = new LinkedHashMap<String, ContentCategory>();
        this.fillMap(collection, linkedHashMap);
        return linkedHashMap;
    }

    private void fillMap(Collection<ContentCategory> collection, Map<String, ContentCategory> map) {
        for (ContentCategory contentCategory : collection) {
            if (map.containsKey(contentCategory.getGuid())) continue;
            map.put(contentCategory.getGuid(), contentCategory);
        }
    }

    private Collection<ContentCategory> getChildCC(ContentCategory contentCategory) {
        if (contentCategory instanceof CustomCategory) {
            return ((CustomCategory)contentCategory).getSubCategories();
        }
        if (contentCategory instanceof Discipline) {
            return ((Discipline)contentCategory).getSubdiscipline();
        }
        if (contentCategory instanceof DisciplineGrouping) {
            return ((DisciplineGrouping)contentCategory).getDisciplines();
        }
        if (contentCategory instanceof Domain) {
            return ((Domain)contentCategory).getSubdomains();
        }
        boolean cfr_ignored_0 = contentCategory instanceof RoleSet;
        if (contentCategory instanceof RoleSetGrouping) {
            return ((RoleSetGrouping)contentCategory).getRoleSets();
        }
        if (contentCategory instanceof Tool) {
            return ((Tool)contentCategory).getToolMentors();
        }
        boolean cfr_ignored_1 = contentCategory instanceof WorkProductType;
        return null;
    }

    private void updateElementMap(Collection<ContentCategory> collection, Map<String, MethodElement> map) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ContentCategory contentCategory : collection) {
            if (!hashSet.contains(contentCategory.getGuid())) {
                this.addToElementMap(contentCategory, map);
            }
            hashSet.add(contentCategory.getGuid());
        }
    }

    private Collection<MethodElement> getElements(ContentCategory contentCategory) {
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        arrayList.addAll(contentCategory.getAssets());
        arrayList.addAll(contentCategory.getChecklists());
        arrayList.addAll(contentCategory.getConceptsAndPapers());
        arrayList.addAll(contentCategory.getExamples());
        arrayList.addAll(contentCategory.getGuidelines());
        arrayList.addAll(contentCategory.getSupportingMaterials());
        if (contentCategory instanceof CustomCategory) {
            arrayList.addAll(((CustomCategory)contentCategory).getSubCategories());
            arrayList.addAll(((CustomCategory)contentCategory).getCategorizedElements());
        } else if (contentCategory instanceof Discipline) {
            arrayList.addAll(((Discipline)contentCategory).getReferenceWorkflows());
            arrayList.addAll(((Discipline)contentCategory).getSubdiscipline());
            arrayList.addAll(((Discipline)contentCategory).getTasks());
        } else if (contentCategory instanceof DisciplineGrouping) {
            arrayList.addAll(((DisciplineGrouping)contentCategory).getDisciplines());
        } else if (contentCategory instanceof Domain) {
            arrayList.addAll(((Domain)contentCategory).getSubdomains());
            arrayList.addAll(((Domain)contentCategory).getWorkProducts());
        } else if (contentCategory instanceof RoleSet) {
            arrayList.addAll(((RoleSet)contentCategory).getRoles());
        } else if (contentCategory instanceof RoleSetGrouping) {
            arrayList.addAll(((RoleSetGrouping)contentCategory).getRoleSets());
        } else if (contentCategory instanceof Tool) {
            arrayList.addAll(((Tool)contentCategory).getToolMentors());
        } else if (contentCategory instanceof WorkProductType) {
            arrayList.addAll(((WorkProductType)contentCategory).getWorkProducts());
        }
        return this.getUniqueCollection(arrayList);
    }

    private Collection<MethodElement> getUniqueCollection(Collection<MethodElement> collection) {
        LinkedHashSet<MethodElement> linkedHashSet = new LinkedHashSet<MethodElement>();
        for (MethodElement methodElement : collection) {
            if (linkedHashSet.contains(methodElement)) continue;
            linkedHashSet.add(methodElement);
        }
        return linkedHashSet;
    }

    public boolean isOwnerSelected(MethodElement methodElement, boolean bl) {
        boolean bl2 = this.isOwnerSelected_(methodElement, bl);
        if (localDebug) {
            System.out.println("LD> isOwnerSelected: " + bl2 + ", " + DebugUtil.toString((MethodElement)methodElement, (int)2));
        }
        return bl2;
    }

    private boolean isOwnerSelected_(MethodElement methodElement, boolean bl) {
        List list;
        EObject eObject;
        if (methodElement == null) {
            return false;
        }
        if (ConfigurationHelper.isDescriptionElement(methodElement)) {
            return true;
        }
        if (this.getUpdatingChanges()) {
            if (this.originalSubstracted.containsKey(methodElement.getGuid()) || this.orignalAdded.containsKey(methodElement.getGuid())) {
                return true;
            }
        } else {
            this.updateChanges();
            if (bl) {
                if (this.substractedElemMap.containsKey(methodElement.getGuid())) {
                    return false;
                }
                if (methodElement instanceof VariabilityElement && this.contributedBaseInSubstracted((VariabilityElement)methodElement)) {
                    return false;
                }
            }
            if (this.addedElemMap.containsKey(methodElement.getGuid())) {
                return true;
            }
        }
        if (methodElement instanceof MethodLibrary || methodElement instanceof MethodConfiguration) {
            return true;
        }
        if (methodElement instanceof MethodPlugin) {
            List list2 = this.config.getMethodPluginSelection();
            return list2 != null && list2.contains(methodElement);
        }
        if (methodElement instanceof Activity && (eObject = (Activity)((Activity)methodElement).getVariabilityBasedOnElement()) != null && eObject != methodElement && (list = TngUtil.getOwningProcess((BreakdownElement)eObject)) != null && list != methodElement && !ConfigurationHelper.inConfig((MethodElement)list, this.config, bl)) {
            return false;
        }
        eObject = LibraryUtil.getSelectable((EObject)methodElement);
        if (eObject instanceof MethodPackage && ConfigurationHelper.isGlobalPackage((MethodPackage)eObject)) {
            list = LibraryUtil.getMethodPlugin(eObject);
            return ConfigurationHelper.inConfig((MethodElement)list, this.config, bl);
        }
        list = this.config.getMethodPackageSelection();
        if (list == null) {
            return false;
        }
        if (eObject instanceof ProcessPackage) {
            EObject eObject2 = eObject;
            while (eObject != null && !(eObject instanceof ProcessComponent) && !list.contains(eObject)) {
                eObject = eObject.eContainer();
            }
            if (eObject == null) {
                eObject = eObject2;
            }
        }
        return eObject != null && list.contains(eObject);
    }

    private boolean contributedBaseInSubstracted(VariabilityElement variabilityElement) {
        if (variabilityElement.getVariabilityType() != VariabilityType.CONTRIBUTES_LITERAL) {
            return false;
        }
        VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
        if (variabilityElement2 == null) {
            return false;
        }
        if (this.substractedElemMap.containsKey(variabilityElement2.getGuid())) {
            return true;
        }
        if (ConfigurationHelper.inConfig((MethodElement)variabilityElement2, this.config, true)) {
            return this.contributedBaseInSubstracted(variabilityElement2);
        }
        return false;
    }

    private void addToElementMap(ContentCategory contentCategory, Map<String, MethodElement> map) {
        Collection<MethodElement> collection = this.getElements(contentCategory);
        for (MethodElement methodElement : collection) {
            map.put(methodElement.getGuid(), methodElement);
        }
    }

    public void dispose() {
        this.config.eAdapters().remove((Object)this.configListener);
        this.libraryManager.removeListener(this.libListener);
    }

    private boolean isNeedUpdateChanges() {
        return this.needUpdateChanges;
    }

    public void setNeedUpdateChanges(boolean bl) {
        this.needUpdateChanges = bl;
        if (localDebug) {
            System.out.println("LD> setNeedUpdateChanges: " + bl);
        }
    }

    private boolean isEnableUpdate() {
        return this.enableUpdate;
    }

    public void setEnableUpdate(boolean bl) {
        this.enableUpdate = bl;
        if (localDebug) {
            System.out.println("LD> setEnableUpdate: " + bl);
        }
    }

    public Collection<MethodElement> getAddedElements() {
        return this.addedElemMap.values();
    }

    public Collection<MethodElement> getSubtractedElements() {
        return this.substractedElemMap.values();
    }

    public boolean isElementInSubtractedCategory(MethodElement methodElement) {
        return this.substractedElemMap.containsKey(methodElement.getGuid());
    }

    public boolean isElementInAddedCategory(MethodElement methodElement) {
        return this.addedElemMap.containsKey(methodElement.getGuid());
    }

    static /* synthetic */ boolean access$1() {
        return localDebug;
    }
}

