/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.closure.ElementReference;
import org.eclipse.epf.library.configuration.closure.PackageDependency;
import org.eclipse.epf.library.configuration.closure.PackageReference;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class DependencyManager {
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodLibrary library;
    protected ILibraryManager libraryManager;
    protected Map dependencyMap = new HashMap();
    private ILibraryChangeListener libListener = null;

    public DependencyManager(MethodLibrary methodLibrary) {
        this.library = methodLibrary;
        this.libraryManager = LibraryService.getInstance().getLibraryManager(methodLibrary);
        this.init();
    }

    protected void init() {
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int n, Collection collection) {
                if (n == 16) {
                    DependencyManager.this.handleDeletedElement(collection);
                } else if ((n == 8 || n == 32) && collection != null && collection.size() > 0) {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        try {
                            Object e = iterator.next();
                            if (e instanceof MethodElement) {
                                DependencyManager.this.buildDependencyFor((MethodElement)e);
                                continue;
                            }
                            if (!debug) continue;
                            System.out.println(e + " is not a method element");
                        }
                        catch (Exception exception) {
                            if (!debug) continue;
                            exception.printStackTrace();
                        }
                    }
                }
            }
        };
        this.libraryManager.addListener(this.libListener);
    }

    public PackageDependency getDependency(MethodElement methodElement) {
        if (!LibraryUtil.selectable((EObject)methodElement)) {
            return null;
        }
        PackageDependency packageDependency = this.getDependency(methodElement, false);
        if (packageDependency == null || !packageDependency.isLoaded()) {
            this.buildDependency(methodElement);
        }
        return this.getDependency(methodElement, false);
    }

    public void printDependency() {
        Iterator iterator = this.dependencyMap.values().iterator();
        while (iterator.hasNext()) {
            ((PackageDependency)iterator.next()).print();
        }
    }

    private void buildDependency(MethodElement methodElement) {
        block5: {
            if (methodElement == null) {
                return;
            }
            try {
                PackageDependency packageDependency = this.buildDependencyFor(methodElement);
                EList eList = methodElement.eContents();
                if (eList != null) {
                    for (MethodElement methodElement2 : eList) {
                        if (methodElement2 == null || LibraryUtil.selectable((EObject)methodElement2)) continue;
                        this.buildDependencyFor(methodElement2);
                    }
                }
                packageDependency.setLoaded(true);
            }
            catch (Exception exception) {
                if (!debug) break block5;
                exception.printStackTrace();
            }
        }
    }

    private PackageDependency buildDependencyFor(MethodElement methodElement) {
        if (methodElement == null) {
            return null;
        }
        MethodElement methodElement2 = (MethodElement)LibraryUtil.getSelectable((EObject)methodElement);
        if (methodElement2 == null) {
            return null;
        }
        PackageDependency packageDependency = this.getDependency(methodElement2, true);
        packageDependency.removeReference(methodElement);
        List list = LibraryUtil.getStructuralFeatures(methodElement);
        int n = 0;
        while (n < list.size()) {
            Object object;
            EReference eReference;
            EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
            if (eStructuralFeature instanceof EReference && !(eReference = (EReference)eStructuralFeature).isContainer() && !eReference.isContainment() && (object = methodElement.eGet((EStructuralFeature)eReference)) != null) {
                MethodElement methodElement3 = null;
                List list2 = null;
                int n2 = 0;
                if (eReference.isMany()) {
                    list2 = (List)object;
                    if (list2.size() > 0) {
                        methodElement3 = (MethodElement)list2.get(n2);
                    }
                } else if (object instanceof MethodElement) {
                    methodElement3 = (MethodElement)object;
                }
                while (methodElement3 != null) {
                    MethodElement methodElement4 = (MethodElement)LibraryUtil.getSelectable((EObject)methodElement3);
                    if (methodElement4 != null) {
                        PackageReference packageReference = packageDependency.getReference(methodElement4, true);
                        if (methodElement == methodElement2 && methodElement3 == methodElement4) break;
                        ElementReference elementReference = packageReference.getReference(methodElement, methodElement3);
                        if (elementReference == null) {
                            elementReference = new ElementReference(methodElement, methodElement3);
                            packageReference.addReference(elementReference);
                        }
                        elementReference.addFeature((EStructuralFeature)eReference);
                        this.getDependency(methodElement4, true).addDependent(methodElement2);
                    }
                    methodElement3 = null;
                    if (list2 == null || ++n2 >= list2.size()) continue;
                    methodElement3 = (MethodElement)list2.get(n2);
                }
            }
            ++n;
        }
        return packageDependency;
    }

    private PackageDependency getDependency(MethodElement methodElement, boolean bl) {
        if (!LibraryUtil.selectable((EObject)methodElement)) {
            if (debug) {
                System.out.println("Error, Selectable element required: " + methodElement);
            }
            return null;
        }
        PackageDependency packageDependency = (PackageDependency)this.dependencyMap.get(methodElement);
        if (packageDependency == null && bl) {
            packageDependency = new PackageDependency(methodElement);
            this.dependencyMap.put(methodElement, packageDependency);
        }
        return packageDependency;
    }

    private void handleDeletedElement(Collection collection) {
        for (Object e : collection) {
            if (!(e instanceof MethodElement)) continue;
            this.removeReference((MethodElement)e);
        }
    }

    private void removeReference(MethodElement methodElement) {
        PackageDependency packageDependency = null;
        MethodElement methodElement2 = (MethodElement)LibraryUtil.getSelectable((EObject)methodElement);
        if (methodElement2 == null || (packageDependency = this.getDependency(methodElement2, false)) == null) {
            return;
        }
        packageDependency.removeReference(methodElement);
    }
}

