/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.epf.common.utils.I18nUtil;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;

public class HtmlBuilder {
    private boolean debug = false;
    private Properties xslParams = null;
    private ElementLayoutManager mgr = null;
    private ElementLayoutManager internal_mgr = null;
    private boolean scanContent = true;
    private boolean showTreeBrowser = false;
    private String layoutXslRootPath = LibraryPlugin.getDefault().getLayoutXslPath();

    public HtmlBuilder() {
        this(null);
    }

    public HtmlBuilder(ElementLayoutManager elementLayoutManager) {
        this.init();
        this.setLayoutManager(elementLayoutManager);
    }

    public void setLayoutXslRootPath(String string) {
        try {
            if (string != null && string.length() > 0) {
                this.layoutXslRootPath = string;
                if (!this.layoutXslRootPath.endsWith(File.separator)) {
                    this.layoutXslRootPath = String.valueOf(this.layoutXslRootPath) + File.separator;
                }
                File file = new File(this.layoutXslRootPath, "resources.properties");
                Locale locale = Locale.getDefault();
                String string2 = I18nUtil.getLocalizedFile((String)file.getAbsolutePath(), (Locale)locale);
                if (string2 != null) {
                    file = new File(string2);
                }
                if (file.exists()) {
                    this.xslParams.load(new FileInputStream(file));
                }
                PreferenceUtil.setXslProperties(this.xslParams);
            }
        }
        catch (IOException iOException) {}
    }

    protected void init() {
        this.debug = LibraryPlugin.getDefault().isDebugging();
        this.loadDefaultLayoutXsl();
    }

    public void loadDefaultLayoutXsl() {
        this.layoutXslRootPath = LibraryPlugin.getDefault().getLayoutXslPath();
        try {
            this.xslParams = LibraryPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            this.xslParams.put("colon_with_space", LibraryResources.colon_with_space);
            PreferenceUtil.setXslProperties(this.xslParams);
        }
        catch (IOException iOException) {
            this.xslParams = null;
        }
    }

    public String getPublishDir() {
        return this.mgr == null ? null : this.mgr.getPublishDir();
    }

    public void setPublishDir(String string) {
        if (this.mgr != null) {
            this.mgr.setPublishDir(string);
        }
        this.getValidator().setPublishDir(string);
    }

    public IContentValidator getValidator() {
        return this.mgr.getValidator();
    }

    private ContentResourceScanner getScanner(MethodElement methodElement) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr(methodElement);
        if (iLibraryResourceManager == null) {
            return null;
        }
        String string = iLibraryResourceManager.getLogicalPluginPath(methodElement);
        File file = new File(iLibraryResourceManager.getPhysicalPluginPath(methodElement));
        File file2 = new File(this.getPublishDir(), string);
        ContentResourceScanner contentResourceScanner = new ContentResourceScanner(file, file2, string, this.getValidator());
        return contentResourceScanner;
    }

    public void enableTreeBrowser(boolean bl) {
        this.showTreeBrowser = bl;
    }

    public void enableContentScan(boolean bl) {
        this.scanContent = bl;
    }

    public boolean contentScanEnabled() {
        return this.scanContent;
    }

    public void setLayoutManager(ElementLayoutManager elementLayoutManager) {
        this.mgr = elementLayoutManager;
        if (this.mgr == null) {
            this.mgr = this.getDefaultLayoutManager();
        }
        this.getValidator().setPublishDir(this.getPublishDir());
    }

    private ElementLayoutManager getDefaultLayoutManager() {
        if (this.internal_mgr == null) {
            this.internal_mgr = new ElementLayoutManager();
        }
        return this.internal_mgr;
    }

    public ElementLayoutManager getLayoutManager() {
        if (this.mgr == null) {
            this.mgr = this.getDefaultLayoutManager();
        }
        return this.mgr;
    }

    public String generateHtml(MethodElement methodElement) {
        String string = null;
        if (this.debug) {
            long l = System.currentTimeMillis();
            IElementLayout iElementLayout = this.getLayoutManager().getLayout(methodElement, true);
            string = this.generateHtml(iElementLayout);
            long l2 = System.currentTimeMillis();
            System.out.println("Time taken to render HTML page for " + methodElement.getName() + ": " + (l2 - l) + " ms");
        } else {
            IElementLayout iElementLayout = this.getLayoutManager().getLayout(methodElement, true);
            string = this.generateHtml(iElementLayout);
        }
        return string;
    }

    public void generateHtml(String string) {
        IElementLayout iElementLayout = this.getLayoutManager().getLayout(string);
        this.generateHtml(iElementLayout);
    }

    public String generateHtml(IElementLayout iElementLayout) {
        long l;
        long l2;
        if (iElementLayout == null) {
            return "about:blank";
        }
        long l3 = Calendar.getInstance().getTimeInMillis();
        String string = iElementLayout.getFilePath().replace('/', File.separatorChar);
        String string2 = String.valueOf(string) + iElementLayout.getFileName(".html");
        String string3 = String.valueOf(this.getPublishDir()) + string;
        String string4 = String.valueOf(this.getPublishDir()) + string2;
        try {
            StringBuffer stringBuffer = this.getXml(iElementLayout);
            File file = new File(string3);
            if (!file.exists()) {
                file.mkdirs();
            }
            List list = iElementLayout.getLayouts();
            String string5 = String.valueOf(this.layoutXslRootPath) + iElementLayout.getXslUrl();
            this.generateHtml(iElementLayout, string5, string4, stringBuffer);
            if (list != null && list.size() > 0) {
                for (Object object : list) {
                    string5 = String.valueOf(this.layoutXslRootPath) + ((LayoutInfo)object).layout_xsl;
                    String string6 = String.valueOf(string3) + ((LayoutInfo)object).fileName;
                    this.generateHtml(iElementLayout, string5, string6, stringBuffer);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string4 = null;
        }
        if ((l2 = (l = Calendar.getInstance().getTimeInMillis()) - l3) > 1000L) {
            Object object;
            String string7 = String.valueOf(l2) + " mini-second(s) publishing element " + LibraryUtil.getTypeName(iElementLayout.getElement()) + "[" + string2 + "]";
            object = this.getValidator();
            if (object == null) {
                System.out.println(string7);
            } else {
                object.logInfo(string7);
            }
        }
        if (string4 != null) {
            return string4;
        }
        return "about:blank";
    }

    private void generateHtml(IElementLayout iElementLayout, String string, String string2, StringBuffer stringBuffer) {
        Exception exception = null;
        if (iElementLayout == null) {
            return;
        }
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
        }
        try {
            StringWriter stringWriter = new StringWriter();
            XSLTProcessor.transform((String)string, (String)stringBuffer.toString(), (Properties)this.xslParams, (Writer)stringWriter);
            stringWriter.flush();
            String string3 = stringWriter.getBuffer().toString();
            if (this.debug) {
                timer.stop();
                System.out.println(String.valueOf(timer.getTime()) + " mini seconds for xml/xslt transformation");
                timer.start();
            }
            string3 = ResourceHelper.validateContent(iElementLayout.getElement(), string3, this.getValidator(), iElementLayout.getLayoutMgr().getConfiguration());
            if (this.contentScanEnabled()) {
                this.scanContentForResources(iElementLayout.getElement(), string3, iElementLayout.getFilePath());
            }
            if (this.debug) {
                timer.stop();
                System.out.println(String.valueOf(timer.getTime()) + " mini seconds scanning content");
                timer.start();
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "utf-8");
            outputStreamWriter.write(string3);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            exception = unsupportedEncodingException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            exception = fileNotFoundException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            exception = iOException;
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
            exception = exception2;
        }
        if (exception != null) {
            this.getValidator().logError(iElementLayout.getElement(), "Error generating element content", exception);
        }
    }

    private StringBuffer getXml(IElementLayout iElementLayout) {
        StringBuffer stringBuffer = new StringBuffer();
        XmlElement xmlElement = iElementLayout.getXmlElement(true);
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        xmlElement.setAttribute("lang", string);
        if (this.showTreeBrowser) {
            xmlElement.setAttribute("showTreeBrowser", "true");
        }
        stringBuffer.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
        if (this.debug) {
            try {
                String string2 = String.valueOf(this.getPublishDir()) + "xml" + File.separator;
                string2 = String.valueOf(string2) + iElementLayout.getType() + "." + iElementLayout.getFileName(".xml");
                File file = new File(string2);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
                outputStreamWriter.write(stringBuffer.toString());
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringBuffer;
    }

    private void scanContentForResources(MethodElement methodElement, String string, String string2) {
        ContentResourceScanner contentResourceScanner = this.getScanner(methodElement);
        if (contentResourceScanner != null) {
            contentResourceScanner.resolveResources(methodElement, string, string2);
        }
    }

    public void dispose() {
        if (this.internal_mgr != null) {
            this.internal_mgr.clear();
            this.internal_mgr = null;
        }
        this.mgr = null;
    }
}

