/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;

public class LayoutResources {
    private static ResourceBundle resourceBundle;
    private static ResourceBundle shapeiconBundle;
    private static String TEMP_LAYOUT_DIR;

    static {
        TEMP_LAYOUT_DIR = "";
        try {
            String string = LayoutResources.class.getPackage().getName();
            String string2 = LayoutResources.class.getName();
            resourceBundle = ResourceBundle.getBundle(string2);
            shapeiconBundle = ResourceBundle.getBundle(String.valueOf(string) + ".DefaultShapeicons");
            String string3 = System.getProperty("user.home");
            TEMP_LAYOUT_DIR = String.valueOf(string3) + File.separator + "EPF" + File.separator + "layout" + File.separator + Long.toHexString(Calendar.getInstance().getTimeInMillis()) + File.separator;
            File file = new File(TEMP_LAYOUT_DIR);
            if (!file.exists()) {
                file.mkdirs();
            } else {
                FileUtil.deleteAllFiles((String)file.getAbsolutePath());
            }
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            resourceBundle = null;
        }
    }

    public static void clear() {
        try {
            FileUtil.deleteAllFiles((String)TEMP_LAYOUT_DIR);
            new File(TEMP_LAYOUT_DIR).delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BrowsingLayoutSettings.INSTANCE.setChanged();
    }

    public static String getDefaultPublishDir() {
        return TEMP_LAYOUT_DIR;
    }

    public static String getDefaultXslPath(String string, String string2) {
        String string3 = LayoutResources.getXslUri(string, string2);
        if (string3 != null) {
            return String.valueOf(LibraryPlugin.getDefault().getLayoutXslPath()) + string3;
        }
        return "";
    }

    public static String getXslUri(String string, String string2) {
        String string3 = LayoutResources.getString(resourceBundle, string.toLowerCase());
        if (string3 == null && string2 != null) {
            string3 = LayoutResources.getString(resourceBundle, string2.toLowerCase());
        }
        if (string3 == null) {
            string3 = LayoutResources.getString(resourceBundle, "default");
        }
        return string3;
    }

    public static String getDefaultShapeiconUrl(String string) {
        String string2 = LayoutResources.getString(shapeiconBundle, string);
        if (string2 == null) {
            string2 = LayoutResources.getString(shapeiconBundle, "general");
        }
        return string2;
    }

    private static String getString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle != null ? resourceBundle.getString(string) : null;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getString(String string) {
        return LayoutResources.getString(resourceBundle, string);
    }

    public static void copyDir(String string, String string2) {
        String string3 = "*.*, **/css/*.*, **/icons/*.*, **/images/*.*, **/resources/*.*, **/stylesheets/*.*, **/scripts/*.*";
        LayoutResources.copyDir(string, string2, string3, null);
    }

    public static void copyDir(String string, String string2, String string3, String string4) {
        LayoutResources.copyDir(new File(string), new File(string2), string3, string4);
    }

    public static void copyDir(File file, File file2, String string, String string2) {
        LayoutResources.copyDir(file, file2, string, string2, true);
    }

    public static void copyDir(File file, File file2, String string, String string2, boolean bl) {
        Copy copy = new Copy();
        copy.setOverwrite(bl);
        if (string != null || string2 != null) {
            FileSet fileSet = new FileSet();
            if (string != null) {
                fileSet.setIncludes(string);
            }
            if (string2 != null) {
                fileSet.setExcludes(string2);
            }
            fileSet.setDir(file);
            copy.addFileset(fileSet);
        }
        copy.setTodir(file2);
        copy.setProject(new Project());
        copy.execute();
    }

    public static void copyLayoutFiles(String string) {
        String string2 = LibraryPlugin.getDefault().getLayoutPath();
        LayoutResources.copyDir(string2, string);
        try {
            LibraryPlugin.getDefault().copyLocalizedFiles("layout/scripts/", new File(string, "scripts"), true, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void unzip(File file, File file2) {
        Expand expand = new Expand();
        expand.setOverwrite(true);
        expand.setSrc(file);
        expand.setDest(file2);
        expand.setProject(new Project());
        expand.execute();
    }
}

