/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.util;

import java.util.Map;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;

public class XmlHelper {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + FileUtil.LINE_SEP;

    public static String validName(String string) {
        return XMLUtil.escape((String)string.replace(' ', '-'));
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    public static String validate(String string) {
        return string == null ? "" : string;
    }

    public static String beginElement(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<" + XmlHelper.validName(string));
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                String string3 = XmlHelper.quote(XMLUtil.escape((String)XmlHelper.validate((String)entry.getValue()), (boolean)true));
                stringBuffer.append(" " + XmlHelper.validName(string2) + "=" + string3);
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static String endElement(String string) {
        return "</" + XmlHelper.validName(string) + ">";
    }

    public static String getElement(String string, String string2, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlHelper.beginElement(string, map)).append(XMLUtil.escape((String)XmlHelper.validate(string2), (boolean)true)).append(XmlHelper.endElement(string));
        return stringBuffer.toString();
    }
}

