/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.MethodLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    private static final String methodLibraryNature = "org.eclipse.epf.library.project.MethodLibraryProjectNature";
    private static final String[] methodLibraryNatures = new String[]{"org.eclipse.epf.library.project.MethodLibraryProjectNature"};
    private static final boolean debug = LibraryPlugin.getDefault().isDebugging();
    public static final String LOCK_FILENAME = ".lock";

    public static final void open(MethodLibrary methodLibrary, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        ResourceUtil.open(ResourceUtil.getLibraryDirectory(methodLibrary), iProgressMonitor);
    }

    public static final void open(String string, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        IProjectDescription iProjectDescription;
        Path path;
        block25: {
            path = new Path(String.valueOf(string) + File.separator + ".project");
            iProjectDescription = null;
            try {
                iProjectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
            }
            catch (CoreException coreException) {
                if (!debug) break block25;
                System.out.println("### - exception in loadProjectDescription");
            }
        }
        IProject iProject = null;
        try {
            IFile iFile;
            File file;
            if (iProjectDescription == null) {
                if (debug) {
                    System.out.println("### - creating new method library project");
                }
                iProject = ResourceUtil.createValidProjectFromPath(string, iProgressMonitor);
            } else {
                if (debug) {
                    System.out.println("### - opening existing method library project " + iProjectDescription.getName());
                }
                if (!(iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iProjectDescription.getName())).exists()) {
                    try {
                        if (debug) {
                            System.out.println("### - creating existing .project " + iProjectDescription.getName() + " in workspace");
                        }
                        iProject = ResourceUtil.createProject(string, iProject.getName(), iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        if (debug) {
                            System.out.println("### - creating existing .project failed - deleting workspace-project in " + string + " and creating workspace-project " + iProject.getName());
                        }
                        ResourceUtil.deleteProject(string, iProgressMonitor);
                        iProject = ResourceUtil.createProject(string, iProject.getName(), iProgressMonitor);
                    }
                } else {
                    if (debug) {
                        System.out.println("### - project " + iProject.getName() + " exists in workspace");
                    }
                    if (new File(string).compareTo(iProject.getLocation().toFile()) != 0) {
                        if (debug) {
                            System.out.println("### - project " + iProject.getName() + " exists in workspace, but location differs - create a new project");
                        }
                        if (!(file = path.toFile()).canWrite()) {
                            throw new IOException("###" + file.getAbsolutePath());
                        }
                        file.delete();
                        iProject = ResourceUtil.createValidProjectFromPath(string, iProgressMonitor);
                    }
                }
            }
            if (iProject == null) {
                throw new IOException(LibraryResources.invalidLibraryPathError_reason);
            }
            iProject.open(128, iProgressMonitor);
            file = new File(string, LOCK_FILENAME);
            if (file.exists()) {
                try {
                    iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
                    if (iFile != null) {
                        iFile.refreshLocal(0, null);
                        iFile.setTeamPrivateMember(true);
                    }
                }
                catch (Exception exception) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
            if (!Arrays.asList(iFile = (iProjectDescription = iProject.getDescription()).getNatureIds()).contains(methodLibraryNature)) {
                if (debug) {
                    System.out.println("### - adding methodlibrarynature to " + iProjectDescription.getName());
                }
                iProjectDescription.setNatureIds(methodLibraryNatures);
                iProject.setDescription(iProjectDescription, 3, iProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)coreException);
            throw coreException;
        }
    }

    public static final void close(MethodLibrary methodLibrary, IProgressMonitor iProgressMonitor) throws CoreException {
        ResourceUtil.close(ResourceUtil.getLibraryDirectory(methodLibrary), iProgressMonitor);
    }

    public static final void close(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = ResourceUtil.findProject(string);
        if (iProject != null && iProject.isOpen()) {
            if (debug) {
                System.out.println("### - closing project " + iProject.getName());
            }
            iProject.close(iProgressMonitor);
        } else if (debug) {
            System.out.println("### - ERROR closing project for library in \"" + string + "\": project could not be found.");
        }
    }

    public static IProject findProject(MethodLibrary methodLibrary) {
        return ResourceUtil.findProject(ResourceUtil.getLibraryDirectory(methodLibrary));
    }

    public static IProject findProject(String string) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        try {
            int n = 0;
            while (n < iProjectArray.length) {
                IProject iProject = iProjectArray[n];
                if (new File(string).compareTo(iProject.getLocation().toFile()) == 0) {
                    if (debug) {
                        System.out.println("### - found project " + iProject.getName() + " with location " + string);
                    }
                    return iProject;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        return null;
    }

    public static final boolean deleteProject(MethodLibrary methodLibrary, IProgressMonitor iProgressMonitor) throws CoreException {
        return ResourceUtil.deleteProject(ResourceUtil.getLibraryDirectory(methodLibrary), iProgressMonitor);
    }

    private static boolean deleteProject(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = ResourceUtil.findProject(string);
        try {
            if (iProject != null) {
                if (debug) {
                    System.out.println("### - deleting project " + iProject.getName());
                }
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                iProject.delete(9, iProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            LibraryPlugin.getDefault().getLogger().logError((Throwable)coreException);
            return false;
        }
        return true;
    }

    public static IProject createProject(MethodLibrary methodLibrary, IProgressMonitor iProgressMonitor) {
        return ResourceUtil.createValidProjectFromPath(ResourceUtil.getLibraryDirectory(methodLibrary), iProgressMonitor);
    }

    public static IProject createValidProjectFromPath(String string, IProgressMonitor iProgressMonitor) {
        IProject iProject = ResourceUtil.findProject(string);
        try {
            if (iProject != null) {
                iProject.delete(9, iProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)coreException);
            return null;
        }
        String string2 = new File(string).getName();
        String string3 = new File(string).getAbsolutePath();
        String string4 = string2;
        int n = 2;
        while (n < 100) {
            try {
                iProject = ResourceUtil.createProject(string3, string4, iProgressMonitor);
                if (debug) {
                    System.out.println("### - creating new method library project " + string4);
                }
                return iProject;
            }
            catch (CoreException coreException) {
                string4 = new StringBuffer(string2).append(' ').append(n++).toString();
            }
        }
        return null;
    }

    private static final IProject createProject(String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(string2);
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        iProjectDescription.setNatureIds(methodLibraryNatures);
        Path path = new Path(string);
        if (!Platform.getLocation().isPrefixOf((IPath)path)) {
            iProjectDescription.setLocation((IPath)path);
        }
        iProject.create(iProjectDescription, iProgressMonitor);
        return iProject;
    }

    public static void closeAllMethodLibraryProjects(IProgressMonitor iProgressMonitor) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        try {
            int n = 0;
            while (n < iProjectArray.length) {
                IProject iProject = iProjectArray[n];
                if (iProject.isOpen() && iProject.getNature(methodLibraryNature) != null) {
                    if (debug) {
                        System.out.println("### - closing method library project " + iProject.getName());
                    }
                    iProject.close(iProgressMonitor);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            LibraryPlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
    }

    public static String getLibraryDirectory(MethodLibrary methodLibrary) {
        return new File(methodLibrary.eResource().getURI().toFileString()).getParent();
    }

    public static Collection<Resource> getOutOfSyncResources(Collection<Resource> collection) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource resource : collection) {
            String string = resource.getURI().toFileString();
            IResource iResource = FileManager.getResourceForLocation((String)string);
            if (iResource == null || iResource.isSynchronized(0)) continue;
            arrayList.add(resource);
        }
        return arrayList;
    }

    public static boolean hasOutOfSynch(Collection<Resource> collection) {
        for (Resource resource : collection) {
            String string;
            IResource iResource;
            if (!resource.getURI().isFile() || (iResource = FileManager.getResourceForLocation((String)(string = resource.getURI().toFileString()))) == null || iResource.isSynchronized(0)) continue;
            return true;
        }
        return false;
    }

    public static void checkOutOfSynchResources(Collection collection, Collection collection2, Collection collection3) {
        for (Resource resource : collection) {
            String string = resource.getURI().toFileString();
            IResource iResource = FileManager.getResourceForLocation((String)string);
            if (iResource == null) {
                collection2.add(resource);
                continue;
            }
            if (iResource.isSynchronized(0)) continue;
            collection3.add(resource);
        }
    }

    public static void refreshResources(MethodLibrary methodLibrary, IProgressMonitor iProgressMonitor) {
        IProject iProject;
        if (methodLibrary != null && (iProject = MethodLibraryProject.findProject(methodLibrary)) != null) {
            try {
                iProject.refreshLocal(2, iProgressMonitor);
            }
            catch (CoreException coreException) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)coreException);
            }
        }
    }
}

