/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.xml.CachedTransformer;

public class XSLTProcessor {
    private static boolean cacheXSL;
    private static Map<String, CachedTransformer> transformerCache;

    static {
        String string = CommonPlugin.getDefault().getString("cacheXSL");
        cacheXSL = string != null && !string.startsWith("[") ? Boolean.getBoolean(string) : true;
        if (cacheXSL) {
            transformerCache = new HashMap<String, CachedTransformer>();
        }
        System.setProperty("entityExpansionLimit", "1000000");
    }

    private XSLTProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(Source source, Source source2, Writer writer, Properties properties, String string) throws Exception {
        if (source != null && source2 != null) {
            Transformer transformer = null;
            String string2 = source.getSystemId();
            if (cacheXSL && string2 != null) {
                CachedTransformer cachedTransformer = null;
                Map<String, CachedTransformer> map = transformerCache;
                synchronized (map) {
                    cachedTransformer = transformerCache.get(string2);
                    if (cachedTransformer == null) {
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        transformer = transformerFactory.newTransformer(source);
                        transformerCache.put(string2, new CachedTransformer(transformer, properties));
                    } else {
                        cachedTransformer.setParams(properties);
                        transformer = cachedTransformer.getTransformer();
                    }
                }
            } else {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformer = transformerFactory.newTransformer(source);
                if (properties != null && properties.size() > 0) {
                    for (String string3 : properties.keySet()) {
                        String string4 = properties.getProperty(string3);
                        transformer.setParameter(string3, string4);
                    }
                }
            }
            if (string != null && string.length() > 0) {
                transformer.setOutputProperty("encoding", string);
            } else {
                transformer.setOutputProperty("encoding", "utf-8");
            }
            transformer.transform(source2, new StreamResult(writer));
        }
    }

    public static void transform(Source source, Source source2, Writer writer, String string) throws Exception {
        XSLTProcessor.transform(source, source2, writer, null, string);
    }

    public static void transform(String string, Source source, Writer writer, Properties properties, String string2) throws Exception {
        InputStream inputStream = XSLTProcessor.getXslInputStream(string);
        if (inputStream != null) {
            StreamSource streamSource = new StreamSource(inputStream);
            streamSource.setSystemId(new File(string));
            XSLTProcessor.transform(streamSource, source, writer, properties, string2);
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void transform(String string, Source source, Writer writer, String string2) throws Exception {
        XSLTProcessor.transform(string, source, writer, null, string2);
    }

    public static void transform(String string, String string2, Writer writer, Properties properties, String string3) throws Exception {
        InputStream inputStream = XSLTProcessor.getXslInputStream(string);
        if (inputStream != null) {
            StreamSource streamSource = new StreamSource(inputStream);
            streamSource.setSystemId(new File(string));
            byte[] byArray = string2.getBytes("utf-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            StreamSource streamSource2 = new StreamSource(byteArrayInputStream);
            XSLTProcessor.transform(streamSource, (Source)streamSource2, writer, properties, string3);
            try {
                inputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void transform(String string, String string2, Writer writer, String string3) throws Exception {
        XSLTProcessor.transform(string, string2, writer, null, string3);
    }

    public static void transform(String string, String string2, File file, Properties properties, String string3) throws Exception {
        FileWriter fileWriter = new FileWriter(file);
        if (fileWriter != null) {
            XSLTProcessor.transform(string, string2, (Writer)fileWriter, properties, string3);
            try {
                fileWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void transform(String string, String string2, File file, String string3) throws Exception {
        XSLTProcessor.transform(string, string2, file, null, string3);
    }

    public static void transform(String string, Source source, Properties properties, Writer writer) throws Exception {
        XSLTProcessor.transform(string, source, writer, properties, null);
    }

    public static void transform(String string, Source source, Writer writer) throws Exception {
        XSLTProcessor.transform(string, source, writer, null, null);
    }

    public static void transform(String string, String string2, Properties properties, Writer writer) throws Exception {
        XSLTProcessor.transform(string, string2, writer, properties, null);
    }

    public static void transform(String string, String string2, Writer writer) throws Exception {
        XSLTProcessor.transform(string, string2, writer, null, null);
    }

    public static void transform(String string, String string2, Properties properties, File file) throws Exception {
        XSLTProcessor.transform(string, string2, file, properties, null);
    }

    public static void transform(String string, String string2, File file) throws Exception {
        XSLTProcessor.transform(string, string2, file, null, null);
    }

    private static InputStream getXslInputStream(String string) {
        InputStream inputStream;
        block2: {
            inputStream = null;
            try {
                inputStream = new FileInputStream(string);
            }
            catch (Exception exception) {
                if (inputStream != null) break block2;
                inputStream = XSLTProcessor.class.getClassLoader().getResourceAsStream(string);
            }
        }
        return inputStream;
    }
}

