/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.IRichTextEditor;
import org.eclipse.epf.richtext.IRichTextToolBar;
import org.eclipse.epf.richtext.RichText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.RichTextSelection;
import org.eclipse.epf.richtext.RichTextToolBar;
import org.eclipse.epf.richtext.actions.CopyAction;
import org.eclipse.epf.richtext.actions.CutAction;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.actions.PasteAction;
import org.eclipse.epf.richtext.actions.PastePlainTextAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IReadOnlyDependent;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextEditor
implements IRichTextEditor {
    protected static final String HTML_TAB_NAME = RichTextResources.htmlTab_text;
    protected boolean debug;
    protected Logger logger;
    protected String basePath;
    protected ViewForm form;
    protected IRichTextToolBar toolBar;
    protected Composite content;
    protected CTabFolder tabFolder;
    protected CTabItem richTextTab;
    protected CTabItem htmlTab;
    protected IRichText richText;
    protected TextViewer sourceViewer;
    protected IDocument currentDoc;
    protected DropTarget sourceEditDropTarget;
    protected Menu contextMenu;
    protected boolean sourceModified = false;
    protected boolean editable = true;
    private OperationHistoryActionHandler undoAction;
    private OperationHistoryActionHandler redoAction;
    private IEditorSite editorSite;
    private Map<String, IAction> fActions = new HashMap<String, IAction>(10);
    private ActivationCodeTrigger fActivationCodeTrigger = new ActivationCodeTrigger();
    private List fActivationCodes = new ArrayList(2);
    final IUndoManager undoManager = new TextViewerUndoManager(10);
    private String[] fKeyBindingScopes;
    protected IDocumentListener sourceEditDocumentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            RichTextEditor.this.sourceModified = true;
            if (RichTextEditor.this.richText != null && RichTextEditor.this.richText instanceof RichText) {
                RichTextEditor.this.richText.notifyModifyListeners();
            }
        }
    };
    protected Listener sourceEditDeactivateListener = new Listener(){

        public void handleEvent(Event event) {
            if (RichTextEditor.this.sourceModified) {
                RichTextEditor.this.updateRichText(RichTextEditor.this.sourceViewer.getTextWidget().getText());
                RichTextEditor.this.setModified(true);
                RichTextEditor.this.sourceModified = false;
            }
        }
    };
    protected KeyListener sourceEditKeyListener = new KeyListener(){

        public void keyPressed(KeyEvent keyEvent) {
            String string;
            ParameterizedCommand parameterizedCommand;
            int n;
            KeyStroke keyStroke;
            KeySequence keySequence;
            Binding binding;
            Object object = PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            if (object != null && object instanceof IBindingService && (binding = ((IBindingService)object).getPerfectMatch((TriggerSequence)(keySequence = KeySequence.getInstance((KeyStroke)(keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)(n = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)keyEvent)))))))) != null && (parameterizedCommand = binding.getParameterizedCommand()) != null && (string = parameterizedCommand.getId()) != null && string.equals("org.eclipse.ui.edit.findReplace")) {
                RichTextEditor.this.richText.getFindReplaceAction().execute(RichTextEditor.this);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    };

    public RichTextEditor(Composite composite, int n, IEditorSite iEditorSite) {
        this(composite, n, iEditorSite, null);
    }

    public RichTextEditor(Composite composite, int n, IEditorSite iEditorSite, String string) {
        this.basePath = string;
        this.editorSite = iEditorSite;
        this.debug = RichTextPlugin.getDefault().isDebugging();
        this.logger = RichTextPlugin.getDefault().getLogger();
        this.init(composite, n);
    }

    protected void init(Composite composite, int n) {
        try {
            this.form = new ViewForm(composite, n);
            this.form.marginHeight = 0;
            this.form.marginWidth = 0;
            this.toolBar = new RichTextToolBar((Composite)this.form, 0x800000, this);
            this.content = new Composite((Composite)this.form, 0x800000);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.content.setLayout((Layout)gridLayout);
            this.tabFolder = this.createEditorTabFolder(this.content, n);
            this.form.setTopCenter((Control)((RichTextToolBar)this.toolBar).getToolbarMgr().getControl());
            this.form.setTopLeft((Control)((RichTextToolBar)this.toolBar).getToolbarMgrCombo().getControl());
            this.form.setContent((Control)this.content);
        }
        catch (Exception exception) {
            this.logger.logError((Throwable)exception);
        }
    }

    @Override
    public Control getControl() {
        return this.form;
    }

    public IRichText getRichTextControl() {
        return this.richText;
    }

    @Override
    public void setLayoutData(Object object) {
        if (this.form != null) {
            this.form.setLayoutData(object);
        }
    }

    @Override
    public Object getLayoutData() {
        if (this.form != null) {
            return this.form.getLayoutData();
        }
        return null;
    }

    @Override
    public void setFocus() {
        if (this.richText != null) {
            this.richText.setFocus();
        }
        this.setSelection(0);
        if (this.toolBar != null && this.tabFolder != null) {
            this.toolBar.updateToolBar(this.editable);
        }
    }

    @Override
    public void setBlur() {
        if (this.richText != null) {
            this.richText.setBlur();
        }
    }

    @Override
    public boolean hasFocus() {
        if (this.richText != null) {
            return this.richText.hasFocus();
        }
        return false;
    }

    @Override
    public void setSelection(int n) {
        if (this.tabFolder != null) {
            this.tabFolder.setSelection(n);
        }
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public URL getCopyURL() {
        if (this.richText != null) {
            return this.richText.getCopyURL();
        }
        return null;
    }

    @Override
    public void setCopyURL() {
        if (this.richText != null) {
            this.richText.setCopyURL();
        }
    }

    @Override
    public boolean getEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean bl) {
        this.editable = bl;
        if (this.toolBar != null && this.tabFolder != null) {
            this.toolBar.updateToolBar(bl);
        }
        if (this.richText != null) {
            this.richText.setEditable(bl);
        }
        if (this.sourceViewer != null) {
            this.sourceViewer.setEditable(bl);
        }
    }

    @Override
    public boolean getModified() {
        if (this.richText != null) {
            return this.richText.getModified();
        }
        return false;
    }

    @Override
    public void setModified(boolean bl) {
        if (this.richText != null) {
            this.richText.setModified(bl);
        }
    }

    @Override
    public String getText() {
        if (this.sourceModified) {
            this.setText(this.getSourceEdit().getText());
            this.setModified(true);
            this.sourceModified = false;
        }
        if (this.richText != null) {
            return this.richText.getText();
        }
        return "";
    }

    @Override
    public void setText(String string) {
        if (this.richText != null) {
            this.richText.setText(string);
        }
        this.sourceModified = false;
        if (this.tabFolder != null) {
            if (this.toolBar != null) {
                this.toolBar.updateToolBar(this.editable);
            }
            if (this.getSourceEdit() != null) {
                this.removeModifyListeners();
                this.currentDoc.set(string);
                this.addModifyListeners();
            }
        }
    }

    protected void addModifyListeners() {
        if (this.currentDoc != null) {
            this.currentDoc.addDocumentListener(this.sourceEditDocumentListener);
        }
    }

    protected void removeModifyListeners() {
        if (this.currentDoc != null) {
            this.currentDoc.removeDocumentListener(this.sourceEditDocumentListener);
        }
    }

    @Override
    public void checkModify() {
        this.richText.checkModify();
        if (this.sourceModified) {
            this.notifyModifyListeners();
        }
        if (this.debug) {
            this.printDebugMessage("checkModify", "modified=" + this.sourceModified);
        }
    }

    @Override
    public void restoreText() {
        if (this.richText != null) {
            this.richText.restoreText();
        }
    }

    @Override
    public RichTextSelection getSelected() {
        if (this.tabFolder.getSelection() == this.htmlTab) {
            String string = this.getSourceEdit().getText();
            Point point = this.sourceViewer.getSelectedRange();
            int n = point.x;
            int n2 = point.x + point.y - 1;
            this.richText.getSelected().clear();
            this.richText.getSelected().setText(string.substring(n, n2 + 1));
        }
        return this.richText.getSelected();
    }

    @Override
    public Object getData(String string) {
        if (this.richText != null) {
            this.richText.getData(string);
        }
        return null;
    }

    @Override
    public void setData(String string, Object object) {
        if (this.richText != null) {
            this.richText.setData(string, object);
        }
    }

    @Override
    public int executeCommand(String string) {
        if (this.richText != null) {
            return this.richText.executeCommand(string);
        }
        return 0;
    }

    @Override
    public int executeCommand(String string, String string2) {
        if (this.richText != null) {
            return this.richText.executeCommand(string, string2);
        }
        return 0;
    }

    @Override
    public int executeCommand(String string, String[] stringArray) {
        if (this.richText != null) {
            return this.richText.executeCommand(string, stringArray);
        }
        return 0;
    }

    @Override
    public void dispose() {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.sourceEditDropTarget != null) {
            this.sourceEditDropTarget.dispose();
            this.sourceEditDropTarget = null;
        }
        if (this.fActivationCodeTrigger != null) {
            this.fActivationCodeTrigger.uninstall();
            this.fActivationCodeTrigger = null;
        }
        this.removeModifyListeners();
        if (this.getSourceEdit() != null) {
            this.getSourceEdit().removeListener(27, this.sourceEditDeactivateListener);
            this.getSourceEdit().removeKeyListener(this.sourceEditKeyListener);
            this.sourceEditDeactivateListener = null;
            this.sourceEditKeyListener = null;
        }
        if (this.sourceViewer != null) {
            this.sourceViewer = null;
        }
        if (this.fActions != null) {
            this.fActions.clear();
            this.fActions = null;
        }
        if (this.fActivationCodes != null) {
            this.fActivationCodes.clear();
            this.fActivationCodes = null;
        }
        if (this.richText != null) {
            this.richText.dispose();
            this.richText = null;
        }
    }

    @Override
    public boolean isDisposed() {
        if (this.richText != null) {
            return this.richText.isDisposed();
        }
        return true;
    }

    @Override
    public Iterator<ModifyListener> getModifyListeners() {
        if (this.richText != null) {
            this.richText.getModifyListeners();
        }
        return null;
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        if (this.richText != null) {
            this.richText.addKeyListener(keyListener);
        }
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        if (this.richText != null) {
            this.richText.removeKeyListener(keyListener);
        }
    }

    @Override
    public void addModifyListener(ModifyListener modifyListener) {
        if (this.richText != null) {
            this.richText.addModifyListener(modifyListener);
        }
    }

    @Override
    public void removeModifyListener(ModifyListener modifyListener) {
        if (this.richText != null) {
            this.richText.removeModifyListener(modifyListener);
        }
    }

    @Override
    public void addDisposeListener(DisposeListener disposeListener) {
        if (this.richText != null) {
            this.richText.addDisposeListener(disposeListener);
        }
    }

    @Override
    public void removeDisposeListener(DisposeListener disposeListener) {
        if (this.richText != null) {
            this.richText.removeDisposeListener(disposeListener);
        }
    }

    @Override
    public void addHelpListener(HelpListener helpListener) {
        if (this.richText != null) {
            this.richText.addHelpListener(helpListener);
        }
    }

    @Override
    public void removeHelpListener(HelpListener helpListener) {
        if (this.richText != null) {
            this.richText.removeHelpListener(helpListener);
        }
    }

    @Override
    public void addListener(int n, Listener listener) {
        if (this.richText != null) {
            this.richText.addListener(n, listener);
        }
    }

    @Override
    public void removeListener(int n, Listener listener) {
        if (this.richText != null) {
            this.richText.removeListener(n, listener);
        }
    }

    @Override
    public Iterator<RichTextListener> getListeners() {
        if (this.richText != null) {
            return this.richText.getListeners();
        }
        return null;
    }

    @Override
    public void notifyModifyListeners() {
        if (this.richText != null) {
            Event event = new Event();
            event.display = Display.getCurrent();
            event.widget = this.richText.getControl();
            Iterator<ModifyListener> iterator = this.getModifyListeners();
            while (iterator != null && iterator.hasNext()) {
                ModifyListener modifyListener = iterator.next();
                modifyListener.modifyText(new ModifyEvent(event));
            }
        }
    }

    @Override
    public void fillToolBar(IRichTextToolBar iRichTextToolBar) {
    }

    protected IRichText createRichTextControl(Composite composite, int n, String string) {
        return new RichText(composite, n, string);
    }

    protected CTabFolder createEditorTabFolder(Composite composite, int n) {
        CTabFolder cTabFolder = new CTabFolder(composite, 0x800400);
        cTabFolder.setLayout((Layout)new GridLayout(1, true));
        cTabFolder.setLayoutData((Object)new GridData(1808));
        Composite composite2 = new Composite((Composite)cTabFolder, 0x800000);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.richText = this.createRichTextControl(composite2, n, this.basePath);
        this.richText.setData("richText", this);
        this.richText.getFindReplaceAction().setRichText(this);
        this.richTextTab = new CTabItem(cTabFolder, 0x800000);
        this.richTextTab.setText(RichTextResources.richTextTab_text);
        this.richTextTab.setToolTipText(RichTextResources.richTextTab_toolTipText);
        this.richTextTab.setControl((Control)composite2);
        Composite composite3 = new Composite((Composite)cTabFolder, 0x800000);
        composite3.setLayout((Layout)new FillLayout());
        this.sourceViewer = new TextViewer(composite3, 8389186);
        this.sourceViewer.setUndoManager(this.undoManager);
        this.setDocument(null);
        this.addModifyListeners();
        this.getSourceEdit().addListener(27, this.sourceEditDeactivateListener);
        this.getSourceEdit().addKeyListener(this.sourceEditKeyListener);
        this.contextMenu = new Menu((Decorations)composite.getShell(), 8);
        this.getSourceEdit().setMenu(this.contextMenu);
        this.fillContextMenu(this.contextMenu);
        this.htmlTab = new CTabItem(cTabFolder, 0);
        this.htmlTab.setText(HTML_TAB_NAME);
        this.htmlTab.setToolTipText(RichTextResources.htmlTab_toolTipText);
        this.htmlTab.setControl((Control)composite3);
        cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CTabItem cTabItem = (CTabItem)selectionEvent.item;
                if (cTabItem.getText().equals(HTML_TAB_NAME)) {
                    RichTextEditor.this.removeModifyListeners();
                    RichTextEditor.this.currentDoc.set(RichTextEditor.this.getText());
                    RichTextEditor.this.sourceModified = false;
                    RichTextEditor.this.addModifyListeners();
                    if (RichTextEditor.this.toolBar != null) {
                        RichTextEditor.this.toolBar.updateToolBar(RichTextEditor.this.editable);
                    }
                } else {
                    RichTextEditor.this.updateRichText(RichTextEditor.this.getSourceEdit().getText());
                    RichTextEditor.this.setModified(true);
                    if (RichTextEditor.this.toolBar != null) {
                        RichTextEditor.this.toolBar.updateToolBar(RichTextEditor.this.editable);
                    }
                }
            }
        });
        this.fillToolBar(this.toolBar);
        this.initializeActivationCodeTrigger();
        this.createActions();
        cTabFolder.setSelection(0);
        return cTabFolder;
    }

    private void setDocument(IDocument iDocument) {
        if (iDocument == null) {
            iDocument = new Document();
        }
        this.undoManager.disconnect();
        IDocument iDocument2 = this.sourceViewer.getDocument();
        if (iDocument2 != null) {
            iDocument2.removeDocumentListener(this.sourceEditDocumentListener);
        }
        this.currentDoc = iDocument;
        this.sourceViewer.setDocument(this.currentDoc);
        this.currentDoc.addDocumentListener(this.sourceEditDocumentListener);
        this.undoManager.connect((ITextViewer)this.sourceViewer);
        if (this.undoAction != null) {
            this.undoAction.setContext(this.getUndoContext());
        }
        if (this.redoAction != null) {
            this.redoAction.setContext(this.getUndoContext());
        }
    }

    public StyledText getSourceEdit() {
        if (this.sourceViewer != null) {
            return this.sourceViewer.getTextWidget();
        }
        return null;
    }

    public void addHTML(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.tabFolder.getSelection() == this.richTextTab) {
            this.executeCommand("addHTML", string);
        } else if (this.tabFolder.getSelection() == this.htmlTab) {
            String string2 = this.getSourceEdit().getText();
            Point point = this.sourceViewer.getSelectedRange();
            int n = point.x;
            int n2 = point.x + point.y - 1;
            String string3 = String.valueOf(string2.substring(0, n)) + string + string2.substring(n2 + 1);
            this.removeModifyListeners();
            this.currentDoc.set(string3);
            this.addModifyListeners();
            this.updateRichText(string3);
        }
    }

    public void addImage(String string, String string2, String string3, String string4) {
        if (this.tabFolder.getSelection() == this.richTextTab) {
            this.executeCommand("addImage", new String[]{string, string2, string3, string4});
        } else if (this.tabFolder.getSelection() == this.htmlTab) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<img");
            if (string2.length() > 0) {
                stringBuffer.append(" height=\"" + string2 + "\"");
            }
            if (string4.length() > 0) {
                stringBuffer.append(" alt=\"" + string4 + "\"");
            }
            stringBuffer.append(" src=\"" + string + "\"");
            if (string3.length() > 0) {
                stringBuffer.append(" width=\"" + string3 + "\"");
            }
            stringBuffer.append(" />");
            String string5 = this.getSourceEdit().getText();
            Point point = this.sourceViewer.getSelectedRange();
            int n = point.x;
            int n2 = point.x + point.y - 1;
            String string6 = String.valueOf(string5.substring(0, n)) + stringBuffer.toString() + string5.substring(n2 + 1);
            this.removeModifyListeners();
            this.currentDoc.set(string6);
            this.addModifyListeners();
            this.updateRichText(string6);
        }
    }

    public boolean isHTMLTabSelected() {
        return this.tabFolder.getSelection() == this.htmlTab;
    }

    protected void fillContextMenu(Menu menu) {
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(RichTextResources.cutAction_text);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CutAction cutAction = new CutAction(RichTextEditor.this);
                cutAction.execute(RichTextEditor.this);
            }
        });
        final MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText(RichTextResources.copyAction_text);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CopyAction copyAction = new CopyAction(RichTextEditor.this);
                copyAction.execute(RichTextEditor.this);
            }
        });
        final MenuItem menuItem3 = new MenuItem(menu, 8);
        menuItem3.setText(RichTextResources.pasteAction_text);
        menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PasteAction pasteAction = new PasteAction(RichTextEditor.this);
                pasteAction.execute(RichTextEditor.this);
            }
        });
        final MenuItem menuItem4 = new MenuItem(menu, 8);
        menuItem4.setText(RichTextResources.pastePlainTextAction_text);
        menuItem4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PastePlainTextAction pastePlainTextAction = new PastePlainTextAction(RichTextEditor.this);
                pastePlainTextAction.execute(RichTextEditor.this);
            }
        });
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent menuEvent) {
            }

            public void menuShown(MenuEvent menuEvent) {
                String string = RichTextEditor.this.getSelected().getText();
                boolean bl = string.length() > 0;
                menuItem.setEnabled(RichTextEditor.this.editable && bl);
                menuItem2.setEnabled(bl);
                menuItem3.setEnabled(RichTextEditor.this.editable);
                menuItem4.setEnabled(RichTextEditor.this.editable);
            }
        });
    }

    private void updateRichText(String string) {
        if (this.richText != null) {
            this.richText.setText(string);
            this.richText.checkModify();
        }
        this.sourceModified = false;
        if (this.tabFolder != null && this.toolBar != null) {
            this.toolBar.updateToolBar(this.editable);
        }
    }

    private void addDropSupportToStyledText() {
        int n = 19;
        this.sourceEditDropTarget = new DropTarget((Control)this.getSourceEdit(), n);
        final TextTransfer textTransfer = TextTransfer.getInstance();
        final HTMLTransfer hTMLTransfer = HTMLTransfer.getInstance();
        Transfer[] transferArray = new Transfer[]{hTMLTransfer, textTransfer};
        this.sourceEditDropTarget.setTransfer(transferArray);
        this.sourceEditDropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = (dropTargetEvent.operations & 1) != 0 ? 1 : 0;
                }
                if (!RichTextEditor.this.getEditable()) {
                    dropTargetEvent.detail = 0;
                }
                int n = 0;
                while (n < dropTargetEvent.dataTypes.length) {
                    if (hTMLTransfer.isSupportedType(dropTargetEvent.dataTypes[n])) {
                        dropTargetEvent.currentDataType = dropTargetEvent.dataTypes[n];
                        break;
                    }
                    ++n;
                }
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
                dropTargetEvent.feedback = 13;
            }

            public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = (dropTargetEvent.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
            }

            public void dropAccept(DropTargetEvent dropTargetEvent) {
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                if (textTransfer.isSupportedType(dropTargetEvent.currentDataType) || hTMLTransfer.isSupportedType(dropTargetEvent.currentDataType)) {
                    String string = (String)dropTargetEvent.data;
                    RichTextEditor.this.addHTML(string);
                }
            }
        });
    }

    private void printDebugMessage(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RichTextEditor[").append(this.richText.getControl().handle).append(']').append('.').append(string);
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(": ").append(string2);
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append('\n').append(string3);
        }
        System.out.println(stringBuffer);
    }

    private void printDebugMessage(String string, String string2) {
        this.printDebugMessage(string, string2, null);
    }

    @Override
    public FindReplaceAction getFindReplaceAction() {
        return this.richText.getFindReplaceAction();
    }

    @Override
    public void setFindReplaceAction(FindReplaceAction findReplaceAction) {
        if (this.richText != null) {
            this.richText.setFindReplaceAction(findReplaceAction);
            this.richText.getFindReplaceAction().setRichText(this);
        }
    }

    @Override
    public void setInitialText(String string) {
        if (this.richText != null) {
            this.richText.setInitialText(string);
        }
        if (this.getSourceEdit() != null) {
            this.removeModifyListeners();
            this.setDocument((IDocument)new Document(string));
            this.addModifyListeners();
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager iUndoManager;
        if (this.sourceViewer instanceof ITextViewerExtension6 && (iUndoManager = this.sourceViewer.getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)iUndoManager).getUndoContext();
        }
        return null;
    }

    protected void createActions() {
        this.createUndoRedoActions();
        Action action = new Action(){

            public void run() {
                RichTextEditor.this.getSourceEdit().selectAll();
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.registerAction(ActionFactory.SELECT_ALL.getId(), (IAction)action);
    }

    protected void createUndoRedoActions() {
        IUndoContext iUndoContext = this.getUndoContext();
        if (iUndoContext != null) {
            this.undoAction = new UndoActionHandler((IWorkbenchPartSite)this.getEditorSite(), iUndoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
            this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.registerAction(ITextEditorActionConstants.UNDO, (IAction)this.undoAction);
            this.redoAction = new RedoActionHandler((IWorkbenchPartSite)this.getEditorSite(), iUndoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
            this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.registerAction(ITextEditorActionConstants.REDO, (IAction)this.redoAction);
        }
    }

    private IEditorSite getEditorSite() {
        return this.editorSite;
    }

    private void registerAction(String string, IAction iAction) {
        IAction iAction2 = this.getAction(string);
        if (iAction2 instanceof OperationHistoryActionHandler) {
            ((OperationHistoryActionHandler)iAction2).dispose();
        }
        this.setAction(string, iAction);
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        if (iActionBars != null) {
            iActionBars.setGlobalActionHandler(string, iAction);
        }
    }

    public IAction getAction(String string) {
        assert (string != null);
        IAction iAction = this.fActions.get(string);
        return iAction;
    }

    public void setAction(String string, IAction iAction) {
        assert (string != null);
        if (iAction == null) {
            iAction = this.fActions.remove(string);
            if (iAction != null) {
                this.fActivationCodeTrigger.unregisterActionFromKeyActivation(iAction);
            }
        } else {
            this.fActions.put(string, iAction);
            this.fActivationCodeTrigger.registerActionForKeyActivation(iAction);
        }
    }

    private void initializeActivationCodeTrigger() {
        this.fActivationCodeTrigger.install();
        this.fActivationCodeTrigger.setScopes(this.fKeyBindingScopes);
    }

    static class ActionActivationCode {
        public String fActionId;
        public char fCharacter;
        public int fKeyCode = -1;
        public int fStateMask = -1;

        public ActionActivationCode(String string) {
            this.fActionId = string;
        }

        public boolean matches(VerifyEvent verifyEvent) {
            return !(verifyEvent.character != this.fCharacter || this.fKeyCode != -1 && verifyEvent.keyCode != this.fKeyCode || this.fStateMask != -1 && verifyEvent.stateMask != this.fStateMask);
        }
    }

    class ActivationCodeTrigger
    implements VerifyKeyListener {
        private boolean fIsInstalled = false;
        private IKeyBindingService fKeyBindingService;

        ActivationCodeTrigger() {
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            ActionActivationCode actionActivationCode = null;
            int n = RichTextEditor.this.fActivationCodes.size();
            int n2 = 0;
            while (n2 < n) {
                IAction iAction;
                actionActivationCode = (ActionActivationCode)RichTextEditor.this.fActivationCodes.get(n2);
                if (actionActivationCode.matches(verifyEvent) && (iAction = RichTextEditor.this.getAction(actionActivationCode.fActionId)) != null) {
                    if (iAction instanceof IUpdate) {
                        ((IUpdate)iAction).update();
                    }
                    if (!iAction.isEnabled() && iAction instanceof IReadOnlyDependent) {
                        IReadOnlyDependent iReadOnlyDependent = (IReadOnlyDependent)iAction;
                        boolean bl = iReadOnlyDependent.isEnabled(true);
                        if (bl) {
                            verifyEvent.doit = false;
                            return;
                        }
                    } else if (iAction.isEnabled()) {
                        verifyEvent.doit = false;
                        iAction.run();
                        return;
                    }
                }
                ++n2;
            }
        }

        public void install() {
            if (!this.fIsInstalled) {
                if (RichTextEditor.this.sourceViewer instanceof ITextViewerExtension) {
                    TextViewer textViewer = RichTextEditor.this.sourceViewer;
                    textViewer.prependVerifyKeyListener((VerifyKeyListener)this);
                } else {
                    StyledText styledText = RichTextEditor.this.sourceViewer.getTextWidget();
                    styledText.addVerifyKeyListener((VerifyKeyListener)this);
                }
                this.fKeyBindingService = RichTextEditor.this.getEditorSite().getKeyBindingService();
                this.fIsInstalled = true;
            }
        }

        public void uninstall() {
            if (this.fIsInstalled) {
                StyledText styledText;
                if (RichTextEditor.this.sourceViewer instanceof ITextViewerExtension) {
                    TextViewer textViewer = RichTextEditor.this.sourceViewer;
                    textViewer.removeVerifyKeyListener((VerifyKeyListener)this);
                } else if (RichTextEditor.this.sourceViewer != null && (styledText = RichTextEditor.this.sourceViewer.getTextWidget()) != null && !styledText.isDisposed()) {
                    styledText.removeVerifyKeyListener((VerifyKeyListener)RichTextEditor.this.fActivationCodeTrigger);
                }
                this.fIsInstalled = false;
                this.fKeyBindingService = null;
            }
        }

        public void registerActionForKeyActivation(IAction iAction) {
            if (iAction.getActionDefinitionId() != null) {
                this.fKeyBindingService.registerAction(iAction);
            }
        }

        public void unregisterActionFromKeyActivation(IAction iAction) {
            if (iAction.getActionDefinitionId() != null) {
                this.fKeyBindingService.unregisterAction(iAction);
            }
        }

        public void setScopes(String[] stringArray) {
            if (stringArray != null && stringArray.length > 0) {
                this.fKeyBindingService.setScopes(stringArray);
            }
        }
    }
}

