/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.dialogs;

import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.epf.richtext.html.Table;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddTableDialog
extends BaseDialog {
    private static final int DEFAULT_ROWS = 2;
    private static final int DEFAULT_COLUMNS = 2;
    private static final String DEFAULT_WIDTH = "85%";
    private static final String[] TABLE_STYLE_LABELS = new String[]{RichTextResources.tableHeaderNone_text, RichTextResources.tableHeaderCols_text, RichTextResources.tableHeaderRows_text, RichTextResources.tableHeaderBoth_text};
    private Table table = new Table();
    private Text rowsText;
    private Text colsText;
    private Text widthText;
    private Combo tableTypeCombo;
    private Text summaryText;
    private Text captionText;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            if (AddTableDialog.this.okButton != null) {
                try {
                    int n = Integer.parseInt(AddTableDialog.this.rowsText.getText().trim());
                    int n2 = Integer.parseInt(AddTableDialog.this.colsText.getText().trim());
                    String string = AddTableDialog.this.widthText.getText().trim();
                    AddTableDialog.this.okButton.setEnabled(n > 0 && n2 > 0 && string.length() > 0);
                }
                catch (Exception exception) {
                    AddTableDialog.this.okButton.setEnabled(false);
                }
            }
        }
    };

    public AddTableDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = new Label(composite2, 0);
        label.setText(RichTextResources.rowsLabel_text);
        this.rowsText = new Text(composite2, 2048);
        this.rowsText.setTextLimit(2);
        this.rowsText.setText("2");
        GridData gridData = new GridData(768);
        this.rowsText.setLayoutData((Object)gridData);
        this.rowsText.addModifyListener(this.modifyListener);
        gridData = new Label(composite2, 0);
        gridData.setText(RichTextResources.columnsLabel_text);
        this.colsText = new Text(composite2, 2048);
        this.colsText.setTextLimit(2);
        this.colsText.setText("2");
        GridData gridData2 = new GridData(768);
        this.colsText.setLayoutData((Object)gridData2);
        this.colsText.addModifyListener(this.modifyListener);
        gridData2 = new Label(composite2, 0);
        gridData2.setText(RichTextResources.widthLabel_text);
        this.widthText = new Text(composite2, 2048);
        this.widthText.setText(DEFAULT_WIDTH);
        GridData gridData3 = new GridData(768);
        this.widthText.setLayoutData((Object)gridData3);
        this.widthText.addModifyListener(this.modifyListener);
        gridData3 = new Label(composite2, 0);
        gridData3.setText(RichTextResources.tableStyleLabel_text);
        this.tableTypeCombo = new Combo(composite2, 2056);
        this.tableTypeCombo.setLayoutData((Object)new GridData(768));
        this.tableTypeCombo.setItems(TABLE_STYLE_LABELS);
        this.tableTypeCombo.setText(TABLE_STYLE_LABELS[0]);
        Label label2 = new Label(composite2, 0);
        label2.setText(RichTextResources.summaryLabel_text);
        this.summaryText = new Text(composite2, 2048);
        GridData gridData4 = new GridData(768);
        this.summaryText.setLayoutData((Object)gridData4);
        gridData4 = new Label(composite2, 0);
        gridData4.setText(RichTextResources.captionLabel_text);
        this.captionText = new Text(composite2, 2048);
        GridData gridData5 = new GridData(768);
        this.captionText.setLayoutData((Object)gridData5);
        super.getShell().setText(RichTextResources.addTableDialog_title);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
    }

    protected void okPressed() {
        String string;
        String string2;
        String string3 = this.rowsText.getText();
        if (string3 != null && string3.length() > 0) {
            try {
                int n = Integer.parseInt(string3);
                this.table.setRows(n);
            }
            catch (Exception exception) {
                this.table.setRows(2);
            }
        }
        if ((string2 = this.colsText.getText()) != null && string2.length() > 0) {
            try {
                int n = Integer.parseInt(string2);
                this.table.setColumns(n);
            }
            catch (Exception exception) {
                this.table.setColumns(2);
            }
        }
        if ((string = this.widthText.getText()) != null && string.length() > 0) {
            this.table.setWidth(string);
        } else {
            this.table.setWidth(DEFAULT_WIDTH);
        }
        this.table.setSummary(this.summaryText.getText().trim());
        this.table.setCaption(this.captionText.getText().trim());
        this.table.setTableHeaders(this.tableTypeCombo.getSelectionIndex());
        super.okPressed();
    }

    public Table getTable() {
        return this.table;
    }
}

