/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.I18nUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractPlugin
extends AbstractUIPlugin {
    private static final String ICON_PATH = "icons/";
    private static Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static Map<String, MsgDialog> msgDialogs = new HashMap<String, MsgDialog>();
    private static Map<String, Image> sharedImages = new HashMap<String, Image>();
    private ResourceBundle resourceBundle;
    private String pluginId;
    private URL installURL;
    private String installPath;
    private URL iconURL;
    private boolean profiling;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.init(bundleContext);
        if (this.isDebugging()) {
            this.getLogger().logInfo("Started " + this.pluginId);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        for (Image image : sharedImages.values()) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
        super.stop(bundleContext);
        if (this.isDebugging()) {
            this.getLogger().logInfo("Stopped " + this.pluginId);
        }
    }

    protected void init(BundleContext bundleContext) throws Exception {
        Bundle bundle = this.getBundle();
        this.resourceBundle = Platform.getResourceBundle((Bundle)bundle);
        this.pluginId = bundle.getSymbolicName();
        if (this.isDebugging()) {
            this.getLogger().logInfo("Initializing " + this.pluginId);
        }
        this.installURL = bundle.getEntry("/");
        try {
            this.installPath = FileLocator.resolve((URL)this.installURL).getPath();
        }
        catch (IOException iOException) {
            this.installPath = Platform.getInstallLocation().getURL().getPath();
        }
        try {
            this.iconURL = new URL(this.installURL, ICON_PATH);
        }
        catch (IOException iOException) {}
        String string = bundle.getSymbolicName();
        if (string != null) {
            String string2 = String.valueOf(string) + "/profiling";
            String string3 = InternalPlatform.getDefault().getOption(string2);
            boolean bl = this.profiling = string3 == null ? false : string3.equalsIgnoreCase("true");
        }
        if (this.isDebugging()) {
            this.getLogger().logInfo("Initialized " + this.pluginId + ", installPath=" + this.installPath);
        }
    }

    public String getId() {
        return this.pluginId;
    }

    public URL getInstallURL() {
        return this.installURL;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public Properties getProperties(String string) throws IOException {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        String string2 = this.getLocalizedFile(string, true);
        if (string2 != null) {
            properties.load(new FileInputStream(string2));
        }
        return properties;
    }

    public String getLocalizedFile(String string, boolean bl) throws IOException {
        URL uRL;
        URL uRL2;
        String string2 = null;
        String string3 = FileUtil.getFileName(string);
        int n = string.lastIndexOf(string3);
        String string4 = string.substring(0, n);
        Locale locale = Locale.getDefault();
        Bundle bundle = this.getBundle();
        Bundle[] bundleArray = Platform.getFragments((Bundle)bundle);
        if (bundleArray != null) {
            int n2 = 0;
            while (n2 < bundleArray.length) {
                URL uRL3;
                uRL2 = bundleArray[n2].getEntry(string4);
                if (uRL2 != null && (string2 = I18nUtil.getLocalizedFile(String.valueOf((uRL3 = FileLocator.resolve((URL)uRL2)).getPath()) + string3, locale)) != null) break;
                ++n2;
            }
        }
        if (string2 == null && (uRL = bundle.getEntry(string)) != null && (string2 = I18nUtil.getLocalizedFile((uRL2 = FileLocator.resolve((URL)uRL)).getPath(), locale)) == null && bl) {
            string2 = uRL2.getPath();
        }
        return string2;
    }

    public void copyLocalizedFiles(String string, File file, boolean bl, boolean bl2) throws IOException {
        String string2 = this.getInstallPath();
        URI uRI = new File(string2).toURI();
        URI uRI2 = new File(string2, string).toURI();
        ArrayList<File> arrayList = new ArrayList<File>();
        File file2 = new File(string2, string);
        FileUtil.getAllFiles(file2, arrayList, bl);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            URI uRI3 = ((File)iterator.next()).toURI();
            String string3 = uRI.relativize(uRI3).getPath();
            String string4 = this.getLocalizedFile(string3, false);
            if (string4 == null) continue;
            string3 = uRI2.relativize(uRI3).getPath();
            File file3 = new File(string4);
            File file4 = new File(file, string3);
            File file5 = file4.getParentFile();
            if (bl2) {
                String string5 = file3.getName();
                file4 = new File(file5, string5);
            }
            if (this.isDebugging()) {
                System.out.println("Copying localized file: ");
                System.out.println("Source: " + file3);
                System.out.println("Target: " + file4);
                System.out.println("");
            }
            try {
                if (!file5.exists()) {
                    file5.mkdirs();
                }
                if (!file4.exists()) {
                    file4.createNewFile();
                }
                FileUtil.copyFile(file3, file4);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String getString(String string) {
        if (this.resourceBundle != null) {
            try {
                return this.resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('[') + string + ']';
    }

    public String formatMessage(String string, Object object) {
        if (this.resourceBundle != null) {
            try {
                String string2 = this.resourceBundle.getString(string);
                Object[] objectArray = new Object[]{object};
                return MessageFormat.format(string2, objectArray);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('[') + string + ']';
    }

    public URL getImageURL(String string) {
        try {
            URL uRL = new URL(this.iconURL, string);
            return FileLocator.resolve((URL)uRL);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ImageDescriptor getImageDescriptor(String string) {
        try {
            URL uRL = new URL(this.iconURL, string);
            return ImageDescriptor.createFromURL((URL)uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public Image getImage(String string) {
        Image image = null;
        ImageDescriptor imageDescriptor = this.getImageDescriptor(string);
        if (imageDescriptor != null) {
            image = imageDescriptor.createImage(false);
        }
        return image;
    }

    public Image getSharedImage(String string) {
        Image image = sharedImages.get(string);
        if (image != null) {
            return image;
        }
        ImageDescriptor imageDescriptor = this.getImageDescriptor(string);
        if (imageDescriptor != null && (image = imageDescriptor.createImage(false)) != null) {
            sharedImages.put(string, image);
        }
        return image;
    }

    public boolean isProfiling() {
        return this.profiling;
    }

    public Logger getLogger() {
        Logger logger = loggers.get(this.pluginId);
        if (logger == null) {
            logger = new Logger(this);
            loggers.put(this.pluginId, logger);
        }
        return logger;
    }

    public MsgDialog getMsgDialog() {
        MsgDialog msgDialog = msgDialogs.get(this.pluginId);
        if (msgDialog == null) {
            msgDialog = new MsgDialog(this);
            msgDialogs.put(this.pluginId, msgDialog);
        }
        return msgDialog;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

